
// Wizard
const steps = document.querySelectorAll(".wizard-steps .step");
const tabs = document.querySelectorAll(".wizard-content .tab");
let currentStep = 0;

function showStep(index) {
  tabs.forEach((tab, i) => {
    tab.classList.toggle("active", i === index);
  });
  steps.forEach((step, i) => {
    step.classList.toggle("active", i === index);
    step.classList.toggle("completed", i < index);
  });
  currentStep = index;
}

document.querySelectorAll(".next").forEach(btn => {
  btn.addEventListener("click", () => {
    if (currentStep < tabs.length - 1) {
      showStep(currentStep + 1);
    }
  });
});

document.querySelectorAll(".prev").forEach(btn => {
  btn.addEventListener("click", () => {
    if (currentStep > 0) {
      showStep(currentStep - 1);
    }
  });
});

// Initialize
showStep(0);
