(async () => {
    "use strict";
    await loadTranslationFile();

    $(document).ready(function () {

        // define here so everything below can use it
        function loadWishlist(type, page, load = '') {
    $(".spinner-loader").removeClass('d-none');
    $.ajax({
        url: "/customer/wishlist/load",
        method: "GET",
        data: { type, page, previous_ids: $('#all_ids').val() },
        success: function (response) {
            if (load === '') $('#wishlist-content-' + type).empty();

            $("#all_ids").attr("data-type", type);
            $("#all_ids").val(response.serviceIds);

            let html = '';
            if (response.html === '') {
                html = '<p>'+_l("no_record_found")+'</p>';
                $('#' + type + '-load-more').addClass('d-none');
            } else {
                html = response.html;
                $('.remove-all').removeClass('d-none');

                // Show "Load More" only if total items >= 6 AND hasMore is true
                const totalItems = response.totalItems || 0; // make sure backend returns total count
                if (totalItems >= 6 && response.hasMore) {
                    $('#' + type + '-load-more').removeClass('d-none')
                        .attr('data-page', response.next_page);
                } else {
                    $('#' + type + '-load-more').addClass('d-none');
                }
            }

            $('#wishlist-content-' + type).append(html);
            setTimeout(() => {
                $(".spinner-loader").addClass('d-none');
            }, 150);
        },
        error: function () {
            showToast("error", _l("something_went_wrong"));
            $(".spinner-loader").addClass('d-none');
        }
    });
}


        // Initial load
        loadWishlist('products', 1, '');

        // Load more
        $('.load-more').on('click', function () {
            const type = $(this).data('type');
            const page = parseInt($('#' + type + '-load-more').attr('data-page')); // uses next_page set by server
            loadWishlist(type, page, 'load'); // do NOT clear container
        });

        // Tab click
        $('a[data-bs-toggle="tab"]').on('shown.bs.tab', function (e) {
            const type = $(e.target).text().trim().toLowerCase();
            const container = '#wishlist-content-' + type;

            // Check if this tab content is already loaded
            if ($(container).children().length === 0) {
                // Only show loader if making AJAX request
                $(".spinner-loader").removeClass('d-none');
                loadWishlist(type, 1, '');
            } else {
                // Already loaded → just make sure loader is hidden
                $(".spinner-loader").addClass('d-none');
            }
        });


        // ✅ Move this handler inside so it sees loadWishlist
        $(document).on('click', '#clearWishlist', function (e) {
            e.preventDefault();

            $('#clearWishlist').html(
                '<div class="spinner-border spinner-border-sm text-light" role="status"></div>'
                ).prop('disabled', true);

            const type = $('#all_ids').attr('data-type');

            $.ajax({
                url: "wishlist/clear",
                type: "DELETE",
                data: { type, all_ids: $('#all_ids').val() },
                headers: {
                    Accept: "application/json",
                    "X-CSRF-TOKEN": $('meta[name="csrf-token"]').attr("content")
                },
                success: function (response) {
                    $('#clearWishlist').html(_l("remove")).prop("disabled", false);
                    if (response.status) {
                        showToast("success", response.message);
                        $('#remove_all').modal('hide');
                        $('.remove-all').addClass('d-none')
                        $('#wishlist-content-' + type).empty();
                        loadWishlist(type, 1, '');       // reload first page
                        $('#all_ids').val('');            // ✅ actually clear the hidden input
                    } else {
                        showToast("error", response.message);
                    }
                },
                error: function () {
                    $('#clearWishlist').html(_l("remove")).prop("disabled", false);
                    showToast("error", _l("something_went_wrong"));
                }
            });
        });
    });
})();
