(async function () {
    "use strict";
    await loadTranslationFile();

    let userId = $("body").data("authid");
    walletList(userId);

    function formatDateRange(range) {
        let [start, end] = range.split(" - ");

        let startDate = moment(start, "D MMM YY").format("YYYY-MM-DD");
        let endDate   = moment(end, "D MMM YY").format("YYYY-MM-DD");

        return [startDate, endDate];
    }

    $('#reportrange').on('apply.daterangepicker', function (ev, picker) {
        $('.reportrange-picker-field').text(
            picker.startDate.format('D MMM YY') + ' - ' + picker.endDate.format('D MMM YY')
        );
        walletList(userId, picker.startDate.format('YYYY-MM-DD'), picker.endDate.format('YYYY-MM-DD'));
    });

    function walletList(userId, startDate = '', endDate = '') {
        if (startDate == '' && endDate == '') {
            let dateRange = $(".reportrange-picker-field").text();
            [startDate, endDate] = formatDateRange(dateRange);
        }
        $(".spinner-loader").addClass('d-none');
        $.ajax({
            url: "/api/walletHistory",
            type: "POST",
            headers: {
                Accept: "application/json",
            },
            data: {
                userId: userId,
                start_date: startDate,
                end_date: endDate
            },
            success: function (response) {
                if (response.success) {
                    $(".spinner-loader").addClass('d-none');
                    $("#loader-table").hide();
                    $(".label-loader, .input-loader").hide();
                    $(".real-label, .real-input").removeClass("d-none");
                    $(".wallet_balance .currency").text(response.Currency);
                    $(".wallet_balance .balance").text(
                        response.totalAmountBalance
                    );
                    $(".total_debit .currency").text(response.Currency);
                    $(".total_amount .currency").text(response.Currency);
                    $(".total_debit .totalAmountdebit").text(
                        response.totalAmountdebit
                    );
                    $(".total_amount .totalAmount").text(response.totalAmount);

                    let currency_symbol = response.Currency;
                    let tableBody = $("#walletHistoryTable tbody");
                    let tableRow = "";
                    let walletHistories = response.data;

                    if (walletHistories.length == 0) {
                        if ($.fn.DataTable.isDataTable("#walletHistoryTable")) {
                            $("#walletHistoryTable").DataTable().destroy();
                        }
                        tableRow += `
                            <tr>
                                <td colspan="8" class="text-center">${$(
                                    "#walletHistoryTable"
                                ).data("empty")}</td>
                            </tr>`;
                    } else {
                        response.data.forEach((record, index) => {
                            tableRow += `
                                <tr>
                                    <td>${index + 1}</td>
                                    <td>${currency_symbol}${record.amount}</td>
                                    <td>${record.payment_type.charAt(0).toUpperCase() + record.payment_type.slice(1)}</td>
                                    <td>${record.status}</td>
                                    <td>${record.transaction_date}</td>
                                </tr>
                            `;
                        });
                    }

                    tableBody.html(tableRow);

                    if (
                        walletHistories.length != 0 &&
                        !$.fn.DataTable.isDataTable("#walletHistoryTable")
                    ) {
                        $("#walletHistoryTable").DataTable({
                            ordering: true,
                            lengthChange: false,
                            searching: false,
                            pagelength: 10,
                        });
                    }
                }
                renderBookingChart(response.wallet_booking_chart, response.Currency);
            },
            error: function () {
                showToast('error', "Error fetching wallet history");
            },
        });
    }

    function renderBookingChart(chartData, currency) {
        if ($("#wallet_booking_chart").length > 0) {
            let bookingChart = {
                chart: {
                    height: 200,
                    type: 'bar',
                    toolbar: { show: false }
                },
                plotOptions: {
                    bar: {
                        horizontal: false,
                        columnWidth: '80%',
                        endingShape: 'rounded',
                        borderRadius: 5
                    }
                },
                dataLabels: { enabled: false },
                colors: ['#FFA500'],
                fill: {
                    type: "gradient",
                    gradient: {
                        shade: 'light',
                        type: "vertical",
                        shadeIntensity: 0.3,
                        gradientToColors: ["#FFD580"],
                        inverseColors: false,
                        opacityFrom: 1,
                        opacityTo: 1,
                        stops: [0, 100]
                    }
                },
                series: [{
                    name: 'Bookings',
                    data: chartData.data
                }],
                grid: {
                    borderColor: '#E2E4E6',
                    strokeDashArray: 5,
                    padding: { right: 0, left: 0 },
                },
                xaxis: {
                    categories: chartData.labels,
                    axisBorder: { show: false },
                    axisTicks: { show: false }
                },
                yaxis: {
                    labels: {
                        formatter: function (val) {
                            return currency + val;
                        }
                    }
                },
                tooltip: {
                    y: {
                        formatter: function (val) {
                            return "Bookings: " + currency + val;
                        }
                    }
                },
                legend: { show: false }
            }

            $("#wallet_booking_chart").empty(); // clear old chart
            var chart = new ApexCharts(
                document.querySelector("#wallet_booking_chart"),
                bookingChart
            );
            chart.render();
        }
    }

    $(document).on("click", ".add_wallet", function () {
        let csrfToken = document
                .querySelector('meta[name="csrf-token"]')
                .getAttribute("content");

        let amount = $(".amount").val();
        let paymentMethod = $('input[name="paymentMethod"]:checked').val();

        $(".add_wallet").html('<span class="spinner-border spinner-border-sm me-2" role="status"></span> Processing...').prop("disabled", true);

        if (!amount || amount < 50) {
            showToast('error', _l('minimum_amount'));
            $(".add_wallet").html(_l('add_payment')).prop("disabled", false);
            return;
        }
        if (!paymentMethod) {
            showToast('error', _l('please_select_payment_method'));
            $(".add_wallet").html(_l('add_payment')).prop("disabled", false);
            return;
        }
        $.ajax({
            url: "/api/addWalletAmount",
            type: "POST",
            data: {
                amount: amount,
                paymentMethod: paymentMethod,
                userId: $("body").data('authid'),
                id: $("body").data('authid'),
            },
            headers: {
                "X-CSRF-TOKEN": $(
                    'meta[name="csrf-token"]'
                ).attr("content"),
            },
            success: function (response) {

                let trxId = response.data.id;
                if (response.data.payment_type === "paypal") {
                    processPayment(
                        "/processpayment",
                        amount,
                        "paypal",
                        trxId,
                        userId
                    );
                } else if (paymentMethod === "stripe") {
                    let form = $("<form>", {
                        action: "/stripepayment",
                        method: "POST",
                    }).append(
                        $("<input>", {
                            type: "hidden",
                            name: "_token",
                            value: csrfToken,
                        }),
                        $("<input>", {
                            type: "hidden",
                            name: "amount",
                            value: amount,
                        }),
                        $("<input>", {
                            type: "hidden",
                            name: "trxId",
                            value: trxId,
                        }),
                        $("<input>", {
                            type: "hidden",
                            name: "userId",
                            value: userId,
                        }),
                        $("<input>", {
                            type: "hidden",
                            name: "type",
                            value: "wallet",
                        })
                    );

                    // Append the form to the body and submit it
                    $("body").append(form);
                    form.submit();
                } else {
                    showToast('error', _l('please_select_payment_method') );
                }
            },
            error: function () {
                showToast('error', _l('error_adding_wallet') );
            },
        });
    });

    function processPayment(url, amount, method, trxId, userId) {
        $.ajax({
            url: url,
            type: "POST",
            data: {
                paymenttype: method === "paypal" ? 1 : 2,
                service_amount: amount,
                trx_id: trxId,
                type: "wallet",
                name: "kddd",
            },
            headers: {
                Authorization: "Bearer " + localStorage.getItem("admin_token"),
                Accept: "application/json",
                "X-CSRF-TOKEN": $('meta[name="csrf-token"]').attr("content"),
            },
            success: function (response) {
                if (method === "paypal") {
                    window.location.href = response;
                } else if (method === "stripe") {
                    window.location.href = response;
                }
            },
            error: function (error) {
                showToast('error', error.responseJSON.message || `Error processing ${method} payment`);
            },
            complete: function () {
                $(".add_wallet").html(_l('add_payment')).prop("disabled", false);
            },
        });
    }
})();