$(document).ready(function() {
    let currentPage = 1;
    let isLoading = false;
    const GET_SHOPS_URL = '/shops-filters/filter';

    // Main function to fetch shops via AJAX
    function fetchShops(page = 1, append = false) {
        if (isLoading) return;
        isLoading = true;

        let formData = $('#filter-form').serialize();
        formData += '&page=' + page;
        
        // --- NEW ---
        // Before the AJAX call, get the current position of the 'Load More' button.
        // We will scroll to this position after the new content is added.
        let scrollPosition = 0;
        if (append) {
            // We subtract a small offset (e.g., 100px) so the button isn't at the very top of the screen after scroll.
            scrollPosition = $('#load-more-container').offset().top - 100;
        }
        
        if (!append) {
             $('#shops-grid').html('<div class="col-12 text-center p-5"><div class="spinner-border" role="status"><span class="visually-hidden">Loading...</span></div></div>');
        }

        $.ajax({
            url: GET_SHOPS_URL,
            type: 'GET',
            data: formData,
            success: function(response) {
                if (response.success) {
                    if (append) {
                        $('#shops-grid').append(response.html);
                        $('html, body').animate({ scrollTop: 0 }, 500);

                    } else {
                        $('#shops-grid').html(response.html);
                        // This still scrolls to the top when applying new filters (not loading more).
                        $('html, body').animate({ scrollTop: 0 }, 500);
                    }
                    
                    if(response.total > 0) {
                        $('#result-count').text(`Showing ${response.firstItem} – ${response.lastItem} of ${response.total} results`);
                    } else {
                         $('#result-count').text(`Showing 0 results`);
                    }

                    if (response.hasMorePages) {
                        $('#load-more-container').html(
                            `<button id="load-more-btn" class="btn btn-dark d-inline-flex align-items-center gap-2">
                                <i class="isax isax-rotate-left"></i>Load More
                            </button>`
                        );
                    } else {
                        $('#load-more-container').html('');
                    }
                }
            },
            error: function() {
                alert('An error occurred. Please try again.');
                if (!append) {
                     $('#shops-grid').html('<div class="col-12"><div class="alert alert-danger">Failed to load shops.</div></div>');
                }
            },
            complete: function() {
                isLoading = false;
            }
        });
    }

    // Handle filter form submission
    $('#filter-form').on('submit', function(e) {
        e.preventDefault();
        currentPage = 1;
        fetchShops(currentPage, false);
    });

    // Handle filter reset
    $('#reset-filter-btn').on('click', function(e) {
        e.preventDefault();
        $('#filter-form')[0].reset();
        $('#sort-by-label').text('Recent Listing');
        $('#sort_by_input').val('recent');
        currentPage = 1;
        fetchShops(currentPage, false);
    });

    // Handle sorting dropdown change
    $('#sort-by-options a').on('click', function(e) {
        e.preventDefault();
        $('#sort_by_input').val($(this).data('value'));
        $('#sort-by-label').text($(this).text());
        currentPage = 1;
        fetchShops(currentPage, false);
    });

    // Handle "Load More" button click
    $(document).on('click', '#load-more-btn', function() {
        const $button = $(this);
        
        // This part is already correct. It shows the loading text BEFORE the AJAX call.
        $button.prop('disabled', true);
        $button.html('<span class="spinner-border spinner-border-sm" role="status" aria-hidden="true"></span> Loading...');

        currentPage++;
        fetchShops(currentPage, true);
    });
});