(async () => {
    "use strict";
    await loadTranslationFile();

    listReviews();
    function listReviews(page = 1, reset = true) {
        if (reset) {
            $("#review_list_container").empty();
        }

        $.ajax({
            url: "/reviews/list",
            type: "GET",
            data: {
                shop_id: $("#shop_id").val(),
                page: page,
            },
            headers: {
                Accept: "application/json",
                "X-CSRF-TOKEN": $("meta[name=\"csrf-token\"]").attr("content"),
            },
            beforeSend: function () {
                $(".load-more-reviews-btn").attr("disabled", true).html(`
                    <span class="spinner-border spinner-border-sm align-middle me-1" role="status" aria-hidden="true"></span> ${_l("loading")}
                `);
            },
            complete: function () {
                $(".load-more-reviews-btn").removeAttr("disabled").html(`${_l("load_more")}`);
            },
            success: function (response) {
                if (response.code === 200 && response.data) {
                    renderReviewsMeta(response.data.reviews_meta);
                    renderReviews(response.data.reviews);
                    if (response.data.next_page) {
                        $(".load-more-reviews-btn").data("page", response.data.next_page).removeClass("d-none");
                    } else {
                        $(".load-more-reviews-btn").addClass("d-none");
                    }
                }
            },
            error: function (res) {
                if (res.responseJSON.code === 500) {
                    showToast("success", res.responseJSON.message);
                }
            },
        });
    }

    function renderReviews(reviews) {
        if (reviews.length > 0) {
            $("#review_list_main_container").removeClass("d-none");
            $.each(reviews, function (index, review) {
                let starsHtml = "";
                let avgRating = review.rating;

                for (let i = 1; i <= 5; i++) {
                    if (avgRating >= i) {
                        starsHtml += '<i class="fas fa-star text-warning"></i>'; // full star
                    } else if (avgRating >= i - 0.5) {
                        starsHtml += '<i class="fas fa-star-half-alt text-warning"></i>'; // half star
                    } else {
                        starsHtml += '<i class="far fa-star text-muted"></i>'; // empty star
                    }
                }

                $("#review_list_container").append(`
					<div class="card review-items mb-3">
						<div class="card-body">
							<div class="d-flex align-center justify-content-between gap-2 flex-wrap">
								<div class="mb-3 d-flex align-items-center gap-2 flex-wrap flex-lg-nowrap">
									<div class="avatar avatar-lg">
										<img src="${review.user.profile_image}" alt="user" class="img-fluid rounded-circle">
									</div>
									<div class="">
										<h6 class="fs-16  mb-1">${review.user.name}</h6>
										<p class="fs-14 mb-0 text-body">${review.review_date}</p>
									</div>
								</div>
								<div class="d-flex align-items-center gap-2 flex-wrap">
									<div class="d-flex align-items-center justify-content-center fs-14">
										${starsHtml}
									</div>
									<p class="fs-14 mb-0 text-body">${avgRating}</p>
								</div>
							</div>
                            <p class="mb-2 fw-semibold">${review.product?.source_name ? (review.type + ": " + review.product?.source_name) : (review.type + ": " + review.product?.source_name)}</p>
							<p class="mb-0 text-body">${review.review}</p>
						</div>
						<div class="review_reply_list ps-4 pe-2" id="review_reply_list_${review.id}">
						</div>
					</div>
                `);
                if (review.replies) {
                    renderReviewReplies(review.id, review.replies);
                }
            });
        } else {
            $("#review_list_main_container").addClass("d-none");
        }
    }

    function renderReviewReplies(review_id, replies) {
        $.each(replies, function (index, reply) {
            $("#review_reply_list_" + review_id).append(`
                <div class="card review-items mb-3">
					<div class="card-body ps-3">
						<div class="d-flex align-center justify-content-between gap-2 flex-wrap">
							<div class="mb-3 d-flex align-items-center gap-2 flex-wrap flex-lg-nowrap">
								<div class="avatar avatar-lg">
									<img src="${reply.user.profile_image}" alt="user" class="img-fluid rounded-circle">
								</div>
								<div class="">
									<h6 class="fs-16  mb-1">${reply.user.name}</h6>
									<p class="fs-14 mb-0 text-body">${reply.reply_date}</p>
								</div>
							</div>
						</div>
						<p class="mb-0 text-body">${reply.review}</p>
					</div>
				</div>
            `);
        });
    }

    function renderReviewsMeta(reviews_meta) {
        let avgRating = reviews_meta.avg_ratings;
        let starRatingCount = reviews_meta.star_ratings_count;
        let starRatingCountPercentage = reviews_meta.star_ratings_percentage;
        $(".total_reviews").text(reviews_meta.total_reviews + " " + (reviews_meta.total_reviews > 1 ? _l("Reviews") : _l("review")));
        $(".total_reviews_count").text(reviews_meta.total_reviews);
        $(".average_ratings").text(reviews_meta.avg_ratings);
        let starsHTML = "";
        for (let i = 1; i <= 5; i++) {
            if (avgRating >= i) {
                starsHTML += '<i class="fas fa-star text-warning"></i>'; // full star
            } else if (avgRating >= i - 0.5) {
                starsHTML += '<i class="fas fa-star-half-alt text-warning"></i>'; // half star
            } else {
                starsHTML += '<i class="far fa-star text-muted"></i>'; // empty star
            }
        }
        $(".star_icons").html(starsHTML);

        $("#1_star_progress").width(starRatingCountPercentage["1_star"] + "%");
        $("#2_star_progress").width(starRatingCountPercentage["2_star"] + "%");
        $("#3_star_progress").width(starRatingCountPercentage["3_star"] + "%");
        $("#4_star_progress").width(starRatingCountPercentage["4_star"] + "%");
        $("#5_star_progress").width(starRatingCountPercentage["5_star"] + "%");

        $("#1_star_count").text(starRatingCount["1_star"]);
        $("#2_star_count").text(starRatingCount["2_star"]);
        $("#3_star_count").text(starRatingCount["3_star"]);
        $("#4_star_count").text(starRatingCount["4_star"]);
        $("#5_star_count").text(starRatingCount["5_star"]);
    }

    $(".load-more-reviews-btn").on("click", function () {
        let page = $(this).data("page");
        listReviews(page, false);
    });

})();