/* global $, loadTranslationFile, document, FormData, showToast, _l */

(async () => {
    "use strict";
    await loadTranslationFile();
    let viewType = "grid";
    let page = 1;
    let pageLength = 6;
    let highlighted = [];
    let shops = [];
    let reviews = [];
    let vendor = [];
    let category = [];
    let filter_location = [];
    let from_price;
    let to_price;
    let sort_by = "new";
    let isLoading = false;
    let keyword = "";
    const language_id = $("#language_id").val() || 1;

    $(document).on("change", "#sortBy", function () {
        fetchServices(page);
    });
    setTimeout(() => {
        const params = new URLSearchParams(window.location.search);
        // Example: category_id → match with "category" checkboxes
        if (params.has("category") && params.get("category") != "") {
            const catId = params.get("category");

            // ✅ mark the checkbox as checked
            const categoryCheckbox = document.querySelector(
                `input[name="category"][data-slug="${catId}"]`
            );
            if (categoryCheckbox) {
                categoryCheckbox.checked = true;
            }

            // ✅ now update filter after checkbox is marked
            updateFilter("category");
        }
        // Example: keyword → set in search input
        if (params.has("keywords") && params.has("keywords") != "") {
            keyword = params.get("keywords");
            if (keyword) {
                keyword = keyword.replace(/['"]+/g, "");
            }
        }
        fetchServices(page);
    }, 200);
    function fetchServices(page = 1) {

        $("html, body").animate({ scrollTop: 0 }, "fast");

        if (isLoading) return;
        isLoading = true;
        sort_by = $("#sort_by li.selected a").data("value") || 'new';
        var price_range = $(".price_range").val();

        const $gridLoaderWrapper = $("#grid-loader-wrapper");
        const $listLoaderWrapper = $("#list-loader-wrapper");

        reviews = $("input[name=reviews]:checked")
            .map(function () {
                return $(this).val();
            })
            .get();

        const loaderHtml = $("#global-loader").html();

        if (viewType === "grid") {
            $gridLoaderWrapper.removeClass("d-none").html(loaderHtml);
            $listLoaderWrapper.addClass("d-none").empty();
        } else {
            $listLoaderWrapper.removeClass("d-none").html(loaderHtml);
            $gridLoaderWrapper.addClass("d-none").empty();
        }

        if (price_range) {
            const [from, to] = price_range.split(";");
            from_price = from || undefined;
            to_price = to || undefined;
        }

        $.ajax({
            type: "GET",
            url: "/services/list",
            dataType: "json",
            data: {
                page: page,
                paginate: pageLength,
                sort_by: sort_by,
                highlighted: highlighted,
                shops: shops,
                reviews: reviews,
                vendor: vendor,
                from_price: from_price || null,
                to_price: to_price || null,
                location: filter_location,
                category: category,
                language_id: language_id,
                keywords: keyword,
                user_id: $("#user_id").val(),
            },
            success: function (response) {
                $(".listCardDiv")
                    .removeClass()
                    .addClass(
                        viewType === "grid"
                            ? "listCardDiv col-lg-12"
                            : "listCardDiv col-xl-12 col-lg-8 col-sm-12 col-12"
                    );

                $(".listCardDiv .row").addClass("serviceListCard");
                const $serviceListCard = $(".serviceListCard");

                // Only clear content if page = 1
                if (page === 1) {
                    $serviceListCard.empty();
                }

                if (
                    response.code === 200 &&
                    Array.isArray(response.data) &&
                    response.data.length > 0
                ) {
                    const html = response.data
                        .map((service) =>
                            viewType === "grid"
                                ? createServiceGridCard(service)
                                : createServiceListCard(service)
                        )
                        .join("");

                    // Append instead of replacing
                    $serviceListCard.append(html);

                    // update button state
                    const pagination = response.pagination;
                    if (pagination.current_page < pagination.last_page) {
                        $("#load-more")
                            .data("page", pagination.current_page + 1)
                            .removeClass('d-none');
                    } else {
                        $("#load-more").addClass('d-none'); // hide if no more pages
                    }

                    const from =
                        (pagination.current_page - 1) * pagination.per_page + 1;
                    const to = Math.min(
                        pagination.current_page * pagination.per_page,
                        pagination.total
                    );
                    const total = pagination.total;
                    const totalServiceText = `${_l(
                        "showing"
                    )} ${from} - ${to} ${_l("of")} ${total} ${_l("results")}`;
                    $("#total_service").text(totalServiceText);
                    $("#content-loader").addClass("d-none");

                } else {
                    if (page === 1) {
                        $serviceListCard.html(
                            `<h6 class="text-center mt-5">${_l("no_service_found")}</h6>`
                        );
                    }
                    $("#load-more").addClass('d-none');
                    $("#content-loader").addClass("d-none");
                }
            },

            complete: function () {
                setTimeout(() => {
                    isLoading = false;
                }, 500);
            },
        });
    }

    // Load more on button click
    $("#load-more").on("click", function () {
        let nextPage = $(this).data("page");
        fetchServices(nextPage);
    });

    // Handle view type toggle (grid/list)
    $(document).on("click", ".viewType", function () {
        viewType = $(this).data("view");
        $("#gridView, #listView").removeClass("active");
        $(this).addClass("active");
        fetchServices(page);
    });

    // Filter button click handler to refresh services listing
    $(document).on("click", "#filterbtn", () => {
        fetchServices(page);
    });

    // Reset filter
    // Reset all filter values to default
    $(document).on("click", ".reset-filter", () => {
        // Clear all filter state variables
        highlighted = [];
        shops = [];
        reviews = [];
        vendor = [];
        category = [];
        filter_location = [];
        from_price = null;
        to_price = null;
        reviews = null;

        // Uncheck all filter inputs
        const $allInputs = $(
            ".highlighted, .shops, .vendor, .category, .filter_location, .reviews"
        );
        $allInputs.prop("checked", false);
        // Clear keyword and rental type selections
        $("#price_range").val("");
        // Fetch updated vehicle list with cleared filters
        fetchServices(page);
        window.location.href = '/services';
    });

    // Update results when user changes the number of items per page
    $(document).on("change", "#pageLength", function () {
        const selected = $(this).val();
        pageLength = selected ? parseInt(selected, 10) : 12;
        fetchServices(page);
    });

    $(document).on("click", "#sort_by li", function () {
        $("#sort_by li").removeClass("selected");
        $(this).addClass("selected");
        $(".selected-value").text($(this).text());
        fetchServices(1);
    });

    // document.addEventListener("DOMContentLoaded", function () {
    // Filter groups you want to track
    const filterGroups = [
        "highlighted",
        "shops",
        "vendor",
        "category",
        "filter_location",
        "reviews",
    ];

    function updateFilter(groupName) {
        let values = Array.from(
            document.querySelectorAll(`input[name='${groupName}']:checked`)
        ).map((cb) => cb.value);

        switch (groupName) {
            case "highlighted":
                highlighted = values;
                break;
            case "shops":
                shops = values;
                break;
            case "vendor":
                vendor = values;
                break;
            case "category":
                category = values;
                break;
            case "filter_location":
                filter_location = values;
                break;
            case "reviews":
                reviews = values;
                break;
        }
    }

    // Attach listeners for all groups
    filterGroups.forEach((group) => {
        document
            .querySelectorAll(`input[name='${group}']`)
            .forEach((checkbox) => {
                checkbox.addEventListener("change", () => updateFilter(group));
            });
    });
    // });

    $("#toggleCategories").on("click", function () {
        let hiddenItems = $(".extra-category");

        if (hiddenItems.hasClass("d-none")) {
            hiddenItems.removeClass("d-none").hide().slideDown();
            $(this).text("See Less");
        } else {
            hiddenItems.slideUp(function () {
                $(this).addClass("d-none");
            });
            $("#toggleCategories").text("See More");
        }
    });

    function ucfirst(str) {
        if (!str) return "";
        return str.charAt(0).toUpperCase() + str.slice(1);
    }

    function createServiceGridCard(service) {
        const serviceName = ucfirst(service.name ?? "");
        const serviceImages = `
					<a href="/servicedetail/${service.slug}">
						<img src="${service.image}" class="img-fluid" alt="${serviceName}">
					</a>
				`;
        const hasMultipleImages = 0;
        const listingImage = hasMultipleImages
            ? `
            	<div class="service-img position-relative overflow-hidden">
	            	<div class="img-slider owl-carousel">${serviceImages}</div>
			      	<div class="badge-item w-100 d-flex align-items-center justify-content-end position-absolute top-0 start-0">
			      		<span class="badge bg-secondary">${service.category}</span>
			      	</div>
			      	${
                        service.trending
                            ? '<span class="feature-icon bg-purple"><i class="isax isax-status-up"></i></span>'
                            : service.is_featured
                            ? '<span class="feature-icon bg-info"><i class="isax isax-flag-2"></i></span>'
                            : ""
                    }
					<a href="javascript:void(0)" data-type="services"
					   class="favourite ${service.wishlist ? "active" : ""}"
					   data-product-id=${service.id}
					   aria-label="Add to favourites">
					   <i class="isax isax-heart"></i>
					</a>

		        </div>
    		`
            : `
            	<div class="service-img position-relative overflow-hidden">
	            	<div class="img-slider owl-carousel">${serviceImages}</div>
			      	<div class="badge-item w-100 d-flex align-items-center justify-content-end position-absolute top-0 start-0">
			      		<span class="badge bg-secondary">${service.category}</span>
			      	</div>
			      	${
                        service.trending
                            ? '<span class="feature-icon bg-purple"><i class="isax isax-status-up"></i></span>'
                            : service.is_featured
                            ? '<span class="feature-icon bg-info"><i class="isax isax-flag-2"></i></span>'
                            : ""
                    }
	                <a href="javascript:void(0)" data-type="services"
					   class="favourite ${service.wishlist ? "active" : ""}"
					   data-product-id=${service.id}
					   aria-label="Add to favourites">
					   <i class="isax isax-heart"></i>
					</a>

		        </div>
    		`;

        const listingContent = `
    		<div class="service-content">
    			<h6 class="title">
    				<a href="/servicedetail/${service.slug}">${service.title}</a>
                </h6>
                <div class="d-flex align-items-center justify-content-between flex-wrap flex-wrap gap-1">
                    <div class="d-flex align-items-center">
                        <a href="/servicedetail/${service.slug}" class="avatar me-2">
                            <img src="${service.shop_image}" alt="shop" class="rounded-circle border">
                        </a>
                        <div>
                            <h6 class="fs-16 fw-semibold mb-1"><a href="/servicedetail/${service.slug}">${service.shop_name}</a></h6>
                            ${renderRatingBlock(service)}
                        </div>
                    </div>
                    <div>
                        <div>
                            <p class="mb-1 fs-14">Starts From </p>
                            <h6 class="mb-0 text-end">${service.currency}${service.starts_from}</h6>
                        </div>
                    </div>
                </div>
    		</div>
    	`;
        return `
		    <div class="col-xl-6 col-lg-6 col-md-6 d-flex">
		      	<div class="service-item flex-fill overflow-hidden mb-0">
			        ${listingImage}
			        ${listingContent}
			    </div>
		    </div>
	  	`;
    }

    function createServiceListCard(service) {
        const serviceName = ucfirst(service.name ?? "");
        const serviceImages = `
					<a href="/servicedetail/${service.slug}">
						<img src="${service.image}" class="img-fluid" alt="${serviceName}">
					</a>
				`;
        const hasMultipleImages = 0;
        const listingImage = hasMultipleImages
            ? `
            	<div class="service-img service-img-list position-relative overflow-hidden">${serviceImages}
		      	<div class="badge-item w-100 d-flex align-items-center justify-content-end position-absolute top-0 start-0">
		      		<span class="badge bg-secondary">${service.title}</span>
		      	</div>
		      	${
                    service.trending
                        ? '<span class="feature-icon bg-purple"><i class="isax isax-status-up"></i></span>'
                        : service.is_featured
                        ? '<span class="feature-icon bg-info"><i class="isax isax-flag-2"></i></span>'
                        : ""
                }
                <a href="javascript:void(0)" class="favourite" aria-label="Add to favourites ${
                    service.wishlist ? "active" : ""
                } data-product-id="${service.id}" data-type="services">
	                <i class="isax isax-heart"></i>
	            </a><div>
    		`
            : `
            	<div class="service-img service-img-list position-relative overflow-hidden">${serviceImages}
		      	<div class="badge-item w-100 d-flex align-items-center justify-content-end position-absolute top-0 start-0">
		      		<span class="badge bg-secondary">${service.title}</span>
		      	</div>
		      	${
                    service.trending
                        ? '<span class="feature-icon bg-purple"><i class="isax isax-status-up"></i></span>'
                        : service.is_featured
                        ? '<span class="feature-icon bg-info"><i class="isax isax-flag-2"></i></span>'
                        : ""
                }
                <a href="javascript:void(0)" class="favourite" aria-label="Add to favourites ${
                    service.wishlist ? "active" : ""
                } data-product-id="${service.id}" data-type="services">
	                <i class="isax isax-heart"></i>
	            </a></div>
    		`;

        const listingContent = `
    		<div class="service-content w-100">
    			<p class="text-body mb-2 fs-16 fw-normal d-flex align-items-center gap-1"><i class="isax isax-location"></i> Newyork, USA</p>
    			<h6 class="title mb-2">
    				<a href="/servicedetail/${service.slug}">${service.category}</a>
                </h6>
                <p class="text-body mb-3 pb-3 border-bottom">${service.title}</p>
                <div class="d-flex align-items-center justify-content-between flex-wrap flex-wrap gap-1">
                    <div class="d-flex align-items-center">
                        <a href="shop-details.html" class="avatar me-2">
                            <img src="${service.shop_image}" alt="shop" class="rounded-circle border">
                        </a>
                        <div>
                            <h6 class="fs-16 fw-semibold mb-1"><a href="/servicedetail/${service.slug}">${service.shop_name}</a></h6>
                            <p class="fs-14 d-flex align-items-center gap-1"><i class="fa-solid fa-star text-warning"></i>${service.rating} (${service.review_count} Reviews)}</p>
                        </div>
                    </div>
                    <div>
                        <div>
                            <p class="mb-1 fs-14">Starts From </p>
                            <h6 class="mb-0 text-end">${service.currency}${service.starts_from}</h6>
                        </div>
                    </div>
                </div>
    		</div>
    	`;
        return `
       		<div class="col-xl-12 col-lg-12 col-md-6 d-flex">
                <div class="service-item flex-fill d-flex flex-wrap flex-lg-nowrap flex-lg-row overflow-hidden">
                    ${listingImage}
                    ${listingContent}
                </div>
            </div>
	  	`;
    }

    function renderRatingBlock(service) {

        let starClass = "";

        if (service.rating >= 1) {
            starClass = "fa-solid fa-star";
        } else if (service.rating > 0 && service.rating < 1) {
            starClass = "fa-solid fa-star-half-stroke";
        } else {
            starClass = "fa-regular fa-star";
        }
        let starsHtml = `<i class="me-1 text-warning ${starClass}"></i>`;

      return `
        <div class="d-flex align-items-center flex-wrap gap-1 mb-2">
          <div class="d-flex align-items-center fs-14">
            ${starsHtml}
          </div>
          <p class="fs-14 text-body mb-0">${service.rating} (${service.review_count} ${ service.review_count > 1 ? _l("Reviews") : _l("review") })</p>
        </div>
      `;
    }
})();
