/* global $, loadTranslationFile, document, FormData, showToast, _l */

(async () => {
    "use strict";
    await loadTranslationFile();

	setTimeout(() => {
	    fetchServicedetails();
	}, 200);
	$('#content-loader').removeClass('d-none');

    $("#bookServiceButton").click(function (e) {
        e.preventDefault();
        const productSlug = $("#product_slug").val(); // Use product_slug instead of product_id
        $(".book-btn").text(_l('please_wait')).prop("disabled", true);
        $.ajax({
            url: "/check-product-user",
            type: "GET",
            data: { product_slug: productSlug }, // Send product_slug in the payload
            success: function (response) {
                if (response.exists === "yes") {
                    window.location.href = `/user/booking/service-booking/${productSlug}`;
                } else {
                    window.location.href = `/user/booking/${productSlug}`;
                }
            },
            complete: function () {
                $(".book-btn").text("Book Service").prop("disabled", false);
            },
        });
    });

	function fetchServicedetails() {
		let lastSegment = getLastUrlSegment();
	    $.ajax({
	        type: "GET",
	       	url: "/services/service-details/" + lastSegment,
	        dataType: "json",
	        success: function (response) {
	        	if (response.code === 200) {
	        		if (response.data.gallery && Array.isArray(response.data.gallery) && response.data.gallery.length > 0) {
			            loadSliderImages(response.data.gallery);
		            }
	        		loadContentdetails(response.data);

	            } else {
	                $serviceListCard.html(
	                    `<p class="text-center">${_l(
	                        "no_service_found"
	                    )}</p>`
	                );
	            }
				$('#content-loader').addClass('d-none');
	        },
			error: function() {
				$("#content-loader").removeClass("d-none");
			}
	    });
	}

	function loadSliderImages(gallery)
	{
		let slider_images = "";
        let small_images = "";
        let gallery_images = "";
        gallery.forEach(function (imgUrl, index) {
            // Large slider images
            slider_images += `
                <div class="service-img position-relative">
                    <img src="${imgUrl}" class="img-fluid rounded" alt="slide-img-${index + 1}">
                    <div class="d-flex align-items-center justify-content-between gap-2 position-absolute view-item top-0">
                        <span class="badge bg-danger"> <i class="isax isax-flash-1"></i></span>
                        <a href="${imgUrl}" data-fancybox="gallery" class="btn btn-icon border rounded">
                            <i class="isax isax-maximize-21"></i>
                        </a>
                    </div>
                </div>
            `;

            gallery_images += `
            	<div class="col-lg-4 col-md-6 col-sm-12">
                    <div class="img-full-view">
                        <a href="${imgUrl}" data-fancybox="gallery">
                            <img src="${imgUrl}" class="rounded img-fluid w-100" alt="social">
                            <span class="avatar avatar-md avatar-rounded"><i class="isax isax-eye fs-20"></i></span>
                        </a>
                    </div>
                </div>
            `;


            // Thumbnail images
            small_images += `
                <div class="img-view">
                    <img src="${imgUrl}" class="img-fluid rounded" alt="slider-thumb-${index + 1}">
                </div>
            `;
        });

        // Inject into DOM
        $('#large-img').html(slider_images);
        $('#small-img').html(small_images);
        $('.gallery_images').html(gallery_images);

        // Reinitialize sliders (important if using Slick/Owl)
        $('#large-img').slick('unslick');
        $('#small-img').slick('unslick');

        $('#large-img').slick({
            slidesToShow: 1,
            slidesToScroll: 1,
            arrows: true,
            fade: true,
            asNavFor: '#small-img'
        });

        $('#small-img').slick({
            slidesToShow: 5,
            slidesToScroll: 1,
            asNavFor: '#large-img',
            focusOnSelect: true,
            arrows: false
        });

        // Rebind fancybox
        $("[data-fancybox='gallery']").fancybox();
	}

    function renderStars(rating) {
        let html = "";
        let fullStars = Math.floor(rating); // full stars
        let halfStar = rating % 1 >= 0.5 ? 1 : 0; // half star
        let emptyStars = 5 - fullStars - halfStar;

        // full stars
        for (let i = 0; i < fullStars; i++) {
            html += '<i class="fa-solid fa-star text-warning"></i>';
        }
        // half star
        if (halfStar) {
            html += '<i class="fa-solid fa-star-half-stroke text-warning"></i>';
        }
        // empty stars
        for (let i = 0; i < emptyStars; i++) {
            html += '<i class="fa-regular fa-star text-warning"></i>';
        }

        return html;
    }


    function loadContentdetails(data) {
        $('#main_header').html(data.title);
        $('#shop').html(data.category);

        let rating = data.rating ? parseFloat(data.rating) : 0;
        let reviewCount = data.review_count ? data.review_count : 0;

        // update stars
        $('#star_container').html(renderStars(rating));

        // update review count
        $('#reviews_count').html(rating + ' (' + reviewCount + ' ' + _l("reviews") + ')');

        $('#booking_count').html(data.no_of_bookings);
        $('#location').html(data.location);
        $('#amount').html(data.currency + data.starts_from);
        $(".overview_details").html(data.overview.description);

		let addServicesHtml = "";
        $.each(data.add_services, function(index, service) {
            addServicesHtml += `
            	<div class=" col-xl-4 col-lg-4 col-md-6 col-sm-12 d-flex">
                    <div class="product-item card rounded mb-0 overflow-hidden flex-fill mb-0">
                        <div class="product-img position-relative">
                            <img src="${service.image}" class="img-fluid w-100" alt="${service.name}">
                        </div>
                        <div class="product-content card-body">
                            <div class="product-info mb-3">
                                <h6 class="mb-1 fs-16"><a href="product.html" class="text-dark">Gas Top up Check</a></h6>
                                <p class="mb-0">${data.currency}${service.name}</p>
                            </div>
                            <div class="product-action d-flex align-items-center justify-content-between gap-2 flex-wrap">
                                <h6 class="mb-0">$${service.price}</h6>
                                <p class="mb-0 fs-14">${service.duration}</p>
                            </div>
                        </div>
                    </div>
                </div>
            `;
        });
        $(".add_services_container").html(addServicesHtml);
        $('#additional_service_count').html(`(${data.add_services.length})`);

        if (data.include) {
		    let includeItems = data.include.split(",");
		    let includeHtml = "";

		    $.each(includeItems, function(index, item) {
		        includeHtml += `
		            <div class="col-lg-4 col-md-6 col-sm-6">
		                <div class="card mb-0">
		                    <div class="card-body d-flex align-items-center">
		                        <h6 class="fs-16 fw-normal d-flex align-items-center mb-0 text-truncate text-body">
		                            <i class="isax isax-tick-circle5 text-success fs-16 me-2"></i>
		                            ${item.trim()}
		                        </h6>
		                    </div>
		                </div>
		            </div>
		        `;
		    });

		    $(".include_container").html(includeHtml);
		}

		if(data.video)
		{
			var video = `
				<a href="${data.video}" class="video-icon" data-fancybox="">
					<i class="isax isax-arrow-right-25"></i>
				</a>
                <img src="${data.img}" class="img-fluid w-100 rounded" alt="w-100">
			`;
			$(".video-container").html(video);
		}
		else
			$(".video-container").html( _l("video_not_found"));

		// Assuming you already have this provider object from your API / AJAX response
		let provider =  data.provider;

		// Fill the HTML fields
		$('#provider_name').html(provider.first_name + ' ' + provider.last_name);
		$('#provider_email_text').html(provider.email);
		$('#provider_email').val(provider.email);
		$('#provider_mobile').html(provider.mobile_number);
		$('#provider_address').html(provider.address);
		$('#member_since').html(provider.member_since);

		// If you want to set avatar dynamically:
		$('#provider_avatar').attr('src', provider.profile_image ?? '/frontend/assets/img/users/user-01.jpg');

		if (provider.rating && provider.review_count) {
		    $('#provider_rating').html(provider.rating + ' (' + provider.review_count + ' ' + _l("reviews") + ')');
		} else {
		    $('#provider_rating').html(_l("no_review_yet"));
		}

		if (data.social_profile && data.social_profile.length > 0) {
		    let socialHtml = '';

		    data.social_profile.forEach(function(profile) {
		        socialHtml += `
		            <a href="${profile.url}" target="_blank">
		                <i class="fa-brands ${profile.icon} fs-20 me-2 img-fluid"></i>
		            </a>
		        `;
		    });

		    $('.social-icon').html(socialHtml);
		} else {
		    // If no social links, hide the block or show fallback
		    $('.social-icon').html('<p class="mb-0 text-muted">No social profiles</p>');
		}

		if (data.map_url && data.map_url !== "") {
		    $('.custom-map iframe').attr('src', data.map_url);
		    $('.custom-map').show(); // show the map if exists
		} else {
		    $('.custom-map').hide(); // hide the map block if no map url
		}

		// Updated related services section with navigation
		if (data.related_service && data.related_service.length > 0) {
		    let html = '';
		    let currentPage = 0;
		    const itemsPerPage = 3; // 3 items per page (3 columns)
		    const totalPages = Math.ceil(data.related_service.length / itemsPerPage);

		    // Function to render services
		    function renderServices(page = 0) {
		        html = '';
		        const startIndex = page * itemsPerPage;
		        const endIndex = startIndex + itemsPerPage;
		        const servicesToShow = data.related_service.slice(startIndex, endIndex);

		        servicesToShow.forEach(service => {
		            html += `
		            <div class="col-lg-4 col-md-6 col-sm-12 mb-4">
		                <div class="service-details-slider-item">
		                    <div class="service-item flex-fill overflow-hidden mb-0">
		                        <div class="service-img position-relative overflow-hidden">
		                            <a href="/servicedetail/${service.slug}">
		                                <img class="img-fluid" src="${service.image}" alt="${service.title}">
		                            </a>
		                            <div class="badge-item w-100 d-flex align-items-center justify-content-end position-absolute top-0 start-0">
		                                <span class="badge bg-secondary">
		                                    ${service.category ?? ''}
		                                </span>
		                            </div>
		                            ${service.featured ? `<span class="feature-icon"><i class="isax isax-flash-1"></i></span>` : ''}
		                            <a href="javascript:void(0)" class="favourite ${service.wishlist ? 'active' : ''}" aria-label="Add to favourites">
		                                <i class="isax isax-heart"></i>
		                            </a>
		                        </div>
		                        <div class="service-content">
		                            <h6 class="title">
		                                <a href="/servicedetail/${service.slug}">${service.title}</a>
		                            </h6>
		                            <div class="d-flex align-items-center justify-content-between flex-wrap flex-wrap gap-1">
		                                <div class="d-flex align-items-center">
		                                    <a href="/shop/${service.provider_id}" class="avatar me-2">
		                                        <img src="${service.shop_image}" alt="${service.shop_name}" class="rounded-circle border">
		                                    </a>
		                                    <div>
		                                        <h6 class="fs-16 fw-semibold mb-1">
		                                            <a href="/shop/${service.provider_id}">${service.shop_name}</a>
		                                        </h6>
		                                        <p class="fs-14 d-flex align-items-center gap-1">
		                                            <i class="fa-solid fa-star text-warning"></i>
		                                            ${service.rating ? service.rating.toFixed(1) : '0.0'} (${service.review_count} Reviews)
		                                        </p>
		                                    </div>
		                                </div>
		                                <div>
		                                    <div>
		                                        <p class="mb-1">Starts From </p>
		                                        <h6 class="mb-0">${service.currency}${service.starts_from}</h6>
		                                    </div>
		                                </div>
		                            </div>
		                        </div>
		                    </div>
		                </div>
		            </div>`;
		        });

		        $('#related_services_container').html(html);
		        updateNavigationButtons();
		    }

		    // Function to update navigation button states
		    function updateNavigationButtons() {
		        $('#prevBtn').prop('disabled', currentPage === 0);
		        $('#nextBtn').prop('disabled', currentPage >= totalPages - 1);

		        // Add visual feedback for disabled state
		        if (currentPage === 0) {
		            $('#prevBtn').addClass('disabled').css('opacity', '0.5');
		        } else {
		            $('#prevBtn').removeClass('disabled').css('opacity', '1');
		        }

		        if (currentPage >= totalPages - 1) {
		            $('#nextBtn').addClass('disabled').css('opacity', '0.5');
		        } else {
		            $('#nextBtn').removeClass('disabled').css('opacity', '1');
		        }
		    }

		    // Navigation button event handlers
		    $('#prevBtn').off('click').on('click', function() {
		        if (currentPage > 0) {
		            currentPage--;
		            renderServices(currentPage);

		            // Smooth scroll to top of related products section
		            $('html, body').animate({
		                scrollTop: $('#related_services_container').offset().top - 100
		            }, 300);
		        }
		    });

		    $('#nextBtn').off('click').on('click', function() {
		        if (currentPage < totalPages - 1) {
		            currentPage++;
		            renderServices(currentPage);

		            // Smooth scroll to top of related products section
		            $('html, body').animate({
		                scrollTop: $('#related_services_container').offset().top - 100
		            }, 300);
		        }
		    });

		    // Initial render
		    renderServices(0);

		    // Hide navigation if only one page
		    if (totalPages <= 1) {
		        $('#prevBtn, #nextBtn').hide();
		    } else {
		        $('#prevBtn, #nextBtn').show();
		    }
		}
		updateServiceIcons(data);
		$('.service-detail-container').show();
	}

	function getLastUrlSegment() {
        let url = window.location.href;

        // Remove query string (?foo=bar) and hash (#section)
        url = url.split('?')[0].split('#')[0];

        // Remove trailing slash if exists
        url = url.replace(/\/+$/, "");

        // Get last segment
        return url.substring(url.lastIndexOf('/') + 1);
    }

    function updateServiceIcons(data) {
	    // Favourite (wishlist)
		$("#add_wishlist").attr("data-product-id", data.id);
		if (data.wishlist == true) {
            console.log('Wishlist:', data.wishlist);
            $('.favourite i').addClass('text-danger isax-heart5').removeClass('isax-heart');
        } else {
            $('.favourite i').removeClass('text-danger isax-heart5').addClass('isax-heart');
        }
	    // Featured
	    if (data.is_featured) {
	        $("#featured i").removeClass("text-dark").addClass("text-primary"); // active blue printer
	    } else {
	        $("#featured i").removeClass("text-primary").addClass("text-dark");
	    }

	    // Example for trending (if you add field later like is_trending)
	    if (data.is_trending) {
	        $("#trending i").removeClass("text-dark").addClass("text-success"); // active green share
	    } else {
	        $("#trending i").removeClass("text-success").addClass("text-dark");
	    }
	}

	$(document).ready(function () {
        $("#reviewForm").validate({
            rules: {
                review: {
                    required: true,
                    minlength: 10,
                },
            },
            messages: {
                review: {
                    required: _l("review_required"),
                    minlength: _l("review_minlength"),
                },
            },
            errorPlacement: function (error, element) {
                var errorId = element.attr("id") + "_error";
                if (element.hasClass("select2-hidden-accessible")) {
                    $("#" + errorId).text(error.text());
                } else {
                    $("#" + errorId).text(error.text());
                }
            },
            highlight: function (element) {
                if ($(element).hasClass("select2-hidden-accessible")) {
                    $(element).next(".select2-container").addClass("is-invalid").removeClass("is-valid");
                }
                $(element).addClass("is-invalid").removeClass("is-valid");
            },
            unhighlight: function (element) {
                if ($(element).hasClass("select2-hidden-accessible")) {
                    $(element).next(".select2-container").removeClass("is-invalid").addClass("is-valid");
                }
                $(element).removeClass("is-invalid").addClass("is-valid");
                var errorId = element.id + "_error";
                $("#" + errorId).text("");
            },
            onkeyup: function (element) {
                $(element).valid();
            },
            onchange: function (element) {
                $(element).valid();
            },
            submitHandler: function () {
                let formData = new FormData();
                formData.append("review", $("#review").val());
                formData.append("rating", $(".ratings_stars i.filled").length);
                formData.append("product_id", $("#product_id").val());
                formData.append("type", "service");

                $.ajax({
                    type: "POST",
                    url: "/customer/store-review",
                    data: formData,
                    processData: false,
                    contentType: false,
                    headers: {
                        Accept: "application/json",
                        "X-CSRF-TOKEN": $("meta[name=\"csrf-token\"]").attr("content"),
                    },
                    beforeSend: function () {
                        $(".submit-review").attr("disabled", true).html(`
                            <span class="spinner-border spinner-border-sm align-middle me-1" role="status" aria-hidden="true"></span> ${_l("submitting")}
                        `);
                    },
                    success: function (resp) {
                        $("#reviewForm")[0].reset();
                        $(".error-text").text("");
                        $(".form-control").removeClass("is-invalid is-valid");
                        $(".submit-review").removeAttr("disabled").html(_l("submit"));
                        if (resp.code === 200) {
                            showToast("success", resp.message);
                            $("#leave_review_card").addClass("d-none");
                            listReviews();
                        }
                    },
                    error: function (error) {
                        $(".error-text").text("");
                        $(".form-control").removeClass("is-invalid is-valid");
                        $(".submit-review").removeAttr("disabled").html(_l("submit"));
                        if (error.responseJSON.code === 422) {
                            $.each(
                                error.responseJSON.errors,
                                function (key, val) {
                                    $("#" + key).addClass("is-invalid");
                                    $("#" + key + "_error").text(val[0]);
                                }
                            );
                        } else {
                            showToast("error", error.responseJSON.message);
                        }
                    },
                });
            },
        });

        $("#replyReviewForm").validate({
            rules: {
                reply_message: {
                    required: true,
                    minlength: 10,
                },
            },
            messages: {
                reply_message: {
                    required: _l("reply_message_required"),
                    minlength: _l("reply_message_minlength"),
                },
            },
            errorPlacement: function (error, element) {
                var errorId = element.attr("id") + "_error";
                if (element.hasClass("select2-hidden-accessible")) {
                    $("#" + errorId).text(error.text());
                } else {
                    $("#" + errorId).text(error.text());
                }
            },
            highlight: function (element) {
                if ($(element).hasClass("select2-hidden-accessible")) {
                    $(element)
                        .next(".select2-container")
                        .addClass("is-invalid")
                        .removeClass("is-valid");
                }
                $(element).addClass("is-invalid").removeClass("is-valid");
            },
            unhighlight: function (element) {
                if ($(element).hasClass("select2-hidden-accessible")) {
                    $(element)
                        .next(".select2-container")
                        .removeClass("is-invalid")
                        .addClass("is-valid");
                }
                $(element).removeClass("is-invalid").addClass("is-valid");
                var errorId = element.id + "_error";
                $("#" + errorId).text("");
            },
            onkeyup: function (element) {
                $(element).valid();
            },
            onchange: function (element) {
                $(element).valid();
            },
            submitHandler: function (form) {
                let formData = new FormData(form);
                formData.append("review_id", $("#review_id").val());
                formData.append("product_id", $("#product_id").val());
                formData.append("reply_message", $("#reply_message").val());
                formData.append("type", "service");

                $.ajax({
                    type: "POST",
                    url: "/customer/store-reply-review",
                    data: formData,
                    processData: false,
                    contentType: false,
                    headers: {
                        Accept: "application/json",
                        "X-CSRF-TOKEN": $("meta[name=\"csrf-token\"]").attr(
                            "content"
                        ),
                    },
                    beforeSend: function () {
                        $(".send-reply").attr("disabled", true).html(`
                            <span class="spinner-border spinner-border-sm align-middle me-1" role="status" aria-hidden="true"></span> ${_l("submitting")}
                        `);
                    },
                    success: function (resp) {
                        $(".error-text").text("");
                        $(".form-control").removeClass("is-invalid is-valid");
                        $(".send-reply").removeAttr("disabled").html(_l("submit"));
                        $("#replyReviewForm")[0].reset();

                        if (resp.code === 200) {
                            showToast("success", resp.message);
                            listReviews();
                            $("#reply_review_modal").modal("hide");
                        }
                    },
                    error: function (error) {
                        $(".error-text").text("");
                        $(".form-control").removeClass("is-invalid is-valid");
                        $(".send-reply").removeAttr("disabled").html(_l("submit"));
                        if (error.responseJSON.code === 422) {
                            $.each(error.responseJSON.errors, function (key, val) {
                                $("#" + key).addClass("is-invalid");
                                $("#" + key + "_error").text(val[0]);
                            });
                        } else {
                            showToast("error", error.responseJSON.message);
                        }
                    },
                });
            },
        });

        $("#enquiryForm").validate({
            rules: {
                name: {
                    required: true,
                    minlength: 3,
                },
                email: {
                    required: true,
                    email: true,
                },
                phone_number: {
                    required: true,
                    digits: true,
                    minlength: 8,
                    maxlength: 15,
                },
                message: {
                    required: true,
                    minlength: 10,
                },
            },
            messages: {
                name: {
                    required: _l("name_required"),
                    minlength: _l("name_minlength"),
                },
                email: {
                    required: _l("email_required"),
                    email: _l("email_valid"),
                },
                phone_number: {
                    required: _l("phone_required"),
                    digits: _l("phone_digits"),
                    minlength: _l("phone_minlength"),
                    maxlength: _l("phone_maxlength"),
                },
                message: {
                    required: _l("message_required"),
                    minlength: _l("message_minlength"),
                },
            },
            errorPlacement: function (error, element) {
                var errorId = element.attr("id") + "_error";
                $("#" + errorId).text(error.text());
            },
            highlight: function (element) {
                $(element).addClass("is-invalid").removeClass("is-valid");
            },
            unhighlight: function (element) {
                $(element).removeClass("is-invalid").addClass("is-valid");
                var errorId = element.id + "_error";
                $("#" + errorId).text("");
            },
            onkeyup: function (element) {
                $(element).valid();
            },
            onchange: function (element) {
                $(element).valid();
            },
            submitHandler: function (form) {
                let formData = new FormData(form);

                $.ajax({
                    type: "POST",
                    url: "/customer/store-enquiry", // <-- update endpoint here
                    data: formData,
                    processData: false,
                    contentType: false,
                    headers: {
                        Accept: "application/json",
                        "X-CSRF-TOKEN": $("meta[name='csrf-token']").attr("content"),
                    },
                    beforeSend: function () {
                        $(".add_enquiry_btn")
                            .attr("disabled", true)
                            .html(`
                                <span class="spinner-border spinner-border-sm align-middle me-1" role="status" aria-hidden="true"></span> ${_l("submitting")}
                            `);
                    },
                    success: function (resp) {
                        $(".error-text").text("");
                        $(".form-control").removeClass("is-invalid is-valid");
                        $(".add_enquiry_btn").removeAttr("disabled").html(_l("Save"));
                        $("#enquiryForm")[0].reset();

                        if (resp.code === 200) {
                            showToast("success", resp.message);
                            $("#add_enquiry").modal("hide"); // <-- adjust modal ID if needed
                        }
                    },
                    error: function (error) {
                        $(".error-text").text("");
                        $(".form-control").removeClass("is-invalid is-valid");
                        $(".add_enquiry_btn").removeAttr("disabled").html(_l("Save"));
                        if (error.responseJSON.code === 422) {
                            $.each(error.responseJSON.errors, function (key, val) {
                                $("#" + key).addClass("is-invalid");
                                $("#" + key + "_error").text(val[0]);
                            });
                        } else {
                            showToast("error", error.responseJSON.message);
                        }
                    },
                });
            },
        });

    });

    listReviews();
    function listReviews(page = 1, reset = true) {
        if (reset) {
            $("#review_list_container").empty();
        }

        $.ajax({
            url: "/reviews/list",
            type: "GET",
            data: {
                product_id: $("#product_id").val(),
                page: page,
                type: "product",
            },
            headers: {
                Accept: "application/json",
                "X-CSRF-TOKEN": $("meta[name=\"csrf-token\"]").attr("content"),
            },
            beforeSend: function () {
                $(".load-more-reviews-btn").attr("disabled", true).html(`
                    <span class="spinner-border spinner-border-sm align-middle me-1" role="status" aria-hidden="true"></span> ${_l("loading")}
                `);
            },
            complete: function () {
                $(".load-more-reviews-btn").removeAttr("disabled").html(`${_l("load_more")}`);
            },
            success: function (response) {
                if (response.code === 200 && response.data) {
                    renderReviewsMeta(response.data.reviews_meta);
                    renderReviews(response.data.reviews);
                    if (response.data.next_page) {
                        $(".load-more-reviews-btn").data("page", response.data.next_page).removeClass("d-none");
                    } else {
                        $(".load-more-reviews-btn").addClass("d-none");
                    }
                }
            },
            error: function (res) {
                if (res.responseJSON.code === 500) {
                    showToast("success", res.responseJSON.message);
                }
            },
        });
    }

    function renderReviews(reviews) {
        if (reviews.length > 0) {
            $("#review_list_main_container").removeClass("d-none");
            $.each(reviews, function (index, review) {
                let starsHtml = "";
                let avgRating = review.rating;

                for (let i = 1; i <= 5; i++) {
                    if (avgRating >= i) {
                        starsHtml += '<i class="fas fa-star text-warning"></i>'; // full star
                    } else if (avgRating >= i - 0.5) {
                        starsHtml += '<i class="fas fa-star-half-alt text-warning"></i>'; // half star
                    } else {
                        starsHtml += '<i class="far fa-star text-muted"></i>'; // empty star
                    }
                }

                $("#review_list_container").append(`
					<div class="card review-items mb-3">
						<div class="card-body">
							<div class="d-flex align-center justify-content-between gap-2 flex-wrap">
								<div class="mb-3 d-flex align-items-center gap-2 flex-wrap flex-lg-nowrap">
									<div class="avatar avatar-lg">
										<img src="${review.user.profile_image}" alt="user" class="img-fluid rounded-circle">
									</div>
									<div class="">
										<h6 class="fs-16  mb-1">${review.user.name}</h6>
										<p class="fs-14 mb-0 text-body">${review.review_date}</p>
									</div>
								</div>
								<div class="d-flex align-items-center gap-2 flex-wrap">
									<div class="d-flex align-items-center justify-content-center fs-14">
										${starsHtml}
									</div>
									<p class="fs-14 mb-0 text-body">${avgRating}</p>
								</div>
							</div>
							<p class="mb-0 text-body">${review.review}</p>
							<div class="d-flex align-items-center justify-content-between flex-wrap gap-2 mt-3">
								${ $("#auth_id").val() == ""
									? `<a href="/user/login" class="text-secondary fw-medium review_reply_btn">${_l("Reply")}</a>`
									: `<a href="javascript:void(0);" class="text-secondary fw-medium review_reply_btn" data-review_id="${review.id}">${_l("Reply")}</a>`
								}
							</div>
						</div>
						<div class="review_reply_list ps-4 pe-2" id="review_reply_list_${review.id}">
						</div>
					</div>
                `);
                if (review.replies) {
                    renderReviewReplies(review.id, review.replies);
                }
            });
        } else {
            $("#review_list_main_container").addClass("d-none");
        }
    }

    function renderReviewReplies(review_id, replies) {
        $.each(replies, function (index, reply) {
            $("#review_reply_list_" + review_id).append(`
                <div class="card review-items mb-3">
					<div class="card-body ps-3">
						<div class="d-flex align-center justify-content-between gap-2 flex-wrap">
							<div class="mb-3 d-flex align-items-center gap-2 flex-wrap flex-lg-nowrap">
								<div class="avatar avatar-lg">
									<img src="${reply.user.profile_image}" alt="user" class="img-fluid rounded-circle">
								</div>
								<div class="">
									<h6 class="fs-16  mb-1">${reply.user.name}</h6>
									<p class="fs-14 mb-0 text-body">${reply.reply_date}</p>
								</div>
							</div>
						</div>
						<p class="mb-0 text-body">${reply.review}</p>
					</div>
				</div>
            `);
        });
    }

    function renderReviewsMeta(reviews_meta) {
        let avgRating = reviews_meta.avg_ratings;
        let starRatingCount = reviews_meta.star_ratings_count;
        let starRatingCountPercentage = reviews_meta.star_ratings_percentage;
        $(".total_reviews").text(reviews_meta.total_reviews + " " + (reviews_meta.total_reviews > 1 ? _l("Reviews") : _l("review")));
        $(".total_reviews_count").text(reviews_meta.total_reviews);
        $(".average_ratings").text(reviews_meta.avg_ratings);
        let starsHTML = "";
        for (let i = 1; i <= 5; i++) {
            if (avgRating >= i) {
                starsHTML += '<i class="fas fa-star text-warning"></i>'; // full star
            } else if (avgRating >= i - 0.5) {
                starsHTML += '<i class="fas fa-star-half-alt text-warning"></i>'; // half star
            } else {
                starsHTML += '<i class="far fa-star text-muted"></i>'; // empty star
            }
        }
        $(".star_icons").html(starsHTML);

        $("#1_star_progress").width(starRatingCountPercentage["1_star"] + "%");
        $("#2_star_progress").width(starRatingCountPercentage["2_star"] + "%");
        $("#3_star_progress").width(starRatingCountPercentage["3_star"] + "%");
        $("#4_star_progress").width(starRatingCountPercentage["4_star"] + "%");
        $("#5_star_progress").width(starRatingCountPercentage["5_star"] + "%");

        $("#1_star_count").text(starRatingCount["1_star"]);
        $("#2_star_count").text(starRatingCount["2_star"]);
        $("#3_star_count").text(starRatingCount["3_star"]);
        $("#4_star_count").text(starRatingCount["4_star"]);
        $("#5_star_count").text(starRatingCount["5_star"]);
    }

    $(document).on("click", ".review_reply_btn", function () {
        $("#replyReviewForm")[0].reset();
        $(".error-text").text("");
        $(".form-control").removeClass("is-invalid is-valid");
        if (!$("#review_list_container").data("is_allow_reply")) {
            showToast("error", _l("product_reply_not_allowed"));
        } else {
            $("#review_id").val($(this).data("review_id"));
            $("#reply_review_modal").modal("show");
        }
    });

    $(".load-more-reviews-btn").on("click", function () {
        let page = $(this).data("page");
        listReviews(page, false);
    });

})();