(async function () {
    "use strict";
    await loadTranslationFile();

    listCategories();
    function listCategories(page = 1, reset = true, sortBy = "newest") {
        if (reset) {
            $("#category_list_container").empty();
            $(".content-loader").removeClass('d-none');
        }

        $.ajax({
            url: "/category/get-all-categories",
            type: "GET",
            data: {
                page: page,
                sort_by: sortBy,
                type: "service",
            },
            headers: {
                Accept: "application/json",
                "X-CSRF-TOKEN": $("meta[name=\"csrf-token\"]").attr("content"),
            },
            beforeSend: function () {
                $(".load-more-btn").attr("disabled", true).html(`
                    <span class="spinner-border spinner-border-sm align-middle me-1" role="status" aria-hidden="true"></span> ${_l("loading")}
                `);
                if (reset) {
                    $(".load-more-btn").addClass("d-none");
                }
            },
            complete: function () {
                $(".load-more-btn").removeAttr("disabled").html(`${_l("load_more")}`);
                $(".content-loader").addClass('d-none');
            },
            success: function (response) {
                if (response.code === 200 && response.data) {
                    let categories = response.data.categories;
                    renderCategories(response.data.categories);
                    $(".sub-head").text(
                        `${_l("showing")} 1 – ${(response.data.current_page - 1) * response.data.per_page + categories.length} ${_l("of")} ${response.data.total} ${_l("results")}`
                    );
                    if (response.data.next_page) {
                        $(".load-more-btn").data("page", response.data.next_page).removeClass("d-none");
                    } else {
                        $(".load-more-btn").addClass("d-none");
                    }
                }
            },
            error: function (res) {
                if (res.responseJSON.code === 500) {
                    showToast("success", res.responseJSON.message);
                }
            },
        });
    }

    function renderCategories(categories) {
        if (categories.length > 0) {
            $("#category_list_container").removeClass("d-none");
            $.each(categories, function (index, category) {

                $("#category_list_container").append(`
                    <div class="col-xl-3 col-lg-4 col-md-4 col-sm-6 d-flex">
                        <div class="category-item-two box-hover flex-fill">
                            <a href="/services?category=${category.slug}" class="category-img">
                                <img class="img-fluid" src="${category.image}" alt="catgory">
                            </a>
                            <div class="category-content">
                                <h6 class="mb-1"><a href="/services?category=${category.slug}">${category.name}</a></h6>
                                <p class="fs-14">${category.service_count} ${ category.service_count > 1 ? _l("Services") : _l("Service") }</p>
                            </div>
                            <a href="/services?category=${category.slug}" class="avatar view-icon">
                                <i class="isax isax-arrow-right-1"></i>
                            </a>
                        </div>
                    </div>
                `);
            });
        } else {
            $("#category_list_container").append(`
                <div class="row align-items-center">
                    <h6 class="text-center">${ _l("No categories available.") }</h6>
                </div>
            `);
        }
    }

    $(".load-more-btn").on("click", function () {
        let page = $(this).data("page");
        listCategories(page, false);
    });

    $(document).on("click", ".sort-by", function () {
        let sortBy = $(this).data("value");
        $(".selected-value").text($(this).text());
        listCategories(1, true, sortBy);
    });
})();