/* global $, loadTranslationFile, showToast, _l, localStorage, FormData, window */
(async () => {
  "use strict";

  await loadTranslationFile();

  $(function () {
    const savedEmail = localStorage.getItem("email");
    if (savedEmail) {
      $("#email").val(savedEmail);
    }

    $("#changePasswordForm").validate({
      rules: {
        new_password: {
          required: true,
          minlength: 6
        },
        confirm_password: {
          required: true,
          equalTo: "#new_password"
        }
      },
      messages: {
        new_password: {
          required: _l("password_required"),
          minlength: _l("password_minlength")
        },
        confirm_password: {
          required: _l("confirm_password_required"),
          equalTo: _l("confirm_password_mismatch")
        }
      },
      errorPlacement(error, element) {
        const errorId = `${element.attr("id")}_error`;
        $(`#${errorId}`).text(error.text());
      },
      highlight: function(element) {
          const $input = $(element);
          const $group = $input.closest('.input-group');

          $group.addClass('is-invalid').removeClass('is-valid');
          $input.addClass('is-invalid').removeClass('is-valid'); // optional
      },
      unhighlight: function(element) {
          const $input = $(element);
          const $group = $input.closest('.input-group');

          $group.removeClass('is-invalid').addClass('is-valid');
          $input.removeClass('is-invalid').addClass('is-valid');

          const errorId = element.id + "_error";
          $("#" + errorId).text("");
      },
      submitHandler(form) {
        const formData = new FormData(form);
        const $btn = $("#reset_password");

        $btn.html(
          "<div class=\"spinner-border spinner-border-sm text-light\" role=\"status\"></div>"
        ).prop("disabled", true);


        $.ajax({
          type: "POST",
          url: "/user-update-password",
           data: {
            new_password: $('#new_password').val(),
            confirm_password: $('#confirm_password').val(),
            email_id: localStorage.getItem("email")
          },
          headers: {
            Accept: "application/json",
            "X-CSRF-TOKEN": $("meta[name=\"csrf-token\"]").attr("content")
          },
          success(resp) {
            if (resp.code === 200) {
              showToast("success", resp.message);
              $("#changePasswordForm")[0].reset();
              window.location.href = "/";
              $(".form-control").removeClass("is-valid");
            } else {
              showToast("error", resp.message || _l("something_went_wrong"));
            }
          },
          error(xhr) {
            $(".error-text").text("");
            $(".form-control").removeClass("is-invalid is-valid");

            if (xhr.responseJSON?.errors) {
              $.each(xhr.responseJSON.errors, (key, val) => {
                $(`#${key}`).addClass("is-invalid");
                $(`#${key}_error`).text(val[0]);
              });
            } else {
              showToast("error", xhr.responseJSON?.message || _l("server_error"));
            }
          },
          complete() {
            $btn.html(_l("save_changes")).prop("disabled", false);
          }
        });
      }
    });
  });
})();