/* global loadTranslationFile, setTimeout, document, showToast, _l, setInterval, clearInterval, location, FormData, window, jQuery */
(async () => {
    "use strict";
    await loadTranslationFile();
    $(document).ready(function () {
        let emailExists = false;
        let userRegisterData;

        $("#userRegisterForm").validate({
            rules: {
                name: {
                    required: true,
                    remote: {
                        url: "/api/user/check-unique",
                        type: "post",
                        headers: {
                            Authorization:
                                "Bearer " + localStorage.getItem("admin_token"),
                            Accept: "application/json",
                        },
                        data: {
                            user_name: function () {
                                return $("#name").val();
                            },
                            id: function () {
                                return $("#id").val();
                            },
                        },
                    },
                },
                first_name: {
                    required: true,
                    pattern: /^[a-zA-Z\s]+$/, // Only allows alphabets and spaces
                },
                last_name: {
                    required: true,
                    pattern: /^[a-zA-Z\s]+$/, // Only allows alphabets and spaces
                },
                email: {
                    required: true,
                    email: true,
                    remote: {
                        url: "/api/user/check-unique",
                        type: "post",
                        headers: {
                            Authorization:
                                "Bearer " + localStorage.getItem("admin_token"),
                            Accept: "application/json",
                        },
                        data: {
                            email: function () {
                                return $("#email").val();
                            },
                            id: function () {
                                return $("#id").val();
                            },
                        },
                    },
                },
                password: {
                    required: true,
                    minlength: 6
                },
                confirm_password: {
                    required: true,
                    minlength: 6,
                    equalTo: "[name='password']"
                },
                remember_me: {
                    required: true,
                },
            },
            messages: {
                name: {
                    required: _l("user_name_required"),
                    pattern: _l("name_alphabets"),
                    remote: _l("user_name_exists"),
                },
                first_name: {
                    required: _l("first_name_required"),
                    pattern: _l("alpha_space_allowed")
                },
                last_name: {
                    required: _l("last_name_required"),
                    pattern: _l("alpha_space_allowed")
                },
                email: {
                    required: _l("email_required"),
                    email: _l("valid_email"),
                    remote: _l("email_exists"),
                },
                password: {
                    required: _l("password_required"),
                    minlength: _l("password_minlength")
                },
                confirm_password: {
                    required: _l("confirm_password_required"),
                    minlength: _l("confirm_password_minlength"),
                    equalTo : _l("confirm_password_mismatch"),
                },
                remember_me: {
                    required : _l("remember_me_required"),
                }
            },
            errorPlacement: function (error, element) {
                const errorId = element.attr("id") + "_error";
                $("#" + errorId).text(error.text());
            },
            highlight: function(element) {
                const $input = $(element);
                const $group = $input.closest('.input-group');

                $group.addClass('is-invalid').removeClass('is-valid');
                $input.addClass('is-invalid').removeClass('is-valid'); // optional
            },
            unhighlight: function(element) {
                const $input = $(element);
                const $group = $input.closest('.input-group');

                $group.removeClass('is-invalid').addClass('is-valid');
                $input.removeClass('is-invalid').addClass('is-valid');

                const errorId = element.id + "_error";
                $("#" + errorId).text("");
            },
            onkeyup: function (element) {
                $(element).valid();
            },
            onchange: function (element) {
                $(element).valid();
            },
            submitHandler: function (form) {

                $("#register").attr("disabled", true).html(
                        "<div class=\"spinner-border text-light\" role=\"status\"></div>"
                );
                const formData = new FormData(form);
                formData.append("_token", $("meta[name='csrf-token']").attr("content"));

                $.ajax({
                    type: "POST",
                    url: "/userregister",
                    data: formData,
                    processData: false,
                    contentType: false,
                    headers: {
                        "Accept": "application/json",
                        "X-CSRF-TOKEN": $("meta[name='csrf-token']").attr("content")
                    },
                    success: function (response) {
                        handleRegisterResponse(response);
                    },
                    error: function (error) {
                        handleRegisterError(error);
                    }
                });
            }
        });

         $('#user_type').val($('input[name="radioDefault"]:checked').val());

        $('.user-role-change').click(function(e){
            $('#user_type').val($(this).val());
        });

        function handleRegisterResponse(response) {
            if (response.register_status == 0) {
                resetRegisterForm();
                redirectTo(response.redirect_url);
            } else if (response.register_status === "1") {
                userRegisterData = {
                    name: response.name,
                    email: response.email,
                    password: response.password,
                    first_name: response.name,
                };

                const userName = response.email;


                $("#register").attr("disabled", true).html(_l("register"));
            }

            $(".btn-outline-light").text(_l("signin")).prop("disabled", false);
        }

        function handleRegisterError(error) {
            setTimeout(function () {
                $("#register").text(_l("signup")).prop("disabled", false);
            }, 500);
            $(".error-text").text("");
            $(".form-control").removeClass("is-invalid is-valid");

            if (error.responseJSON && error.responseJSON.code === 422) {
                const errorMessages = [];
                $.each(error.responseJSON.errors, function (key, val) {
                    $("#" + key).addClass("is-invalid");
                    $("#" + key + "_error").text(val[0]);
                    errorMessages.push(val[0]);
                });
                showToast("error", errorMessages.join("<br>"));
            } else {
                const message = error.responseJSON ? error.responseJSON.message : "An error occurred";
                showToast("error", message);
            }
        }

        function resetRegisterForm() {
            $("#userRegisterForm")[0].reset();
            $(".form-control").removeClass("is-invalid is-valid");
        }

        function redirectTo(redirectUrl) {
            const BASE_URL = window.location.origin;
            if (redirectUrl && redirectUrl.startsWith("/") && !redirectUrl.startsWith("//")) {
                window.location.href = BASE_URL + redirectUrl;
            } else {
                window.location.href = BASE_URL + "/";
            }
        }
      });
}) ();
