$(document).ready(function () {
    enquiryList();

    $("#editEnquiryForm").validate({
        rules: {
            status: {
                required: true,
            },
            comments: {
                minlength: 5,
            },
        },
        messages: {
            status: {
                required: _l("status_required"),
            },
            comments: {
                required: _l("comments_required"),
                minlength: _l("comments_minlength"),
            },
        },
        errorPlacement: function (error, element) {
            var errorId = element.attr("id") + "_error";
            $("#" + errorId).text(error.text());
        },
        highlight: function (element) {
            $(element).addClass("is-invalid").removeClass("is-valid");
        },
        unhighlight: function (element) {
            $(element).removeClass("is-invalid").addClass("is-valid");
            var errorId = element.id + "_error";
            $("#" + errorId).text("");
        },
        onkeyup: function (element) {
            $(element).valid();
        },
        onchange: function (element) {
            $(element).valid();
        },
        submitHandler: function (form) {
            let formData = new FormData(form);

            $.ajax({
                type: "POST",
                url: "/provider/enquiry/update-status",
                data: formData,
                processData: false,
                contentType: false,
                headers: {
                    Accept: "application/json",
                    "X-CSRF-TOKEN": $("meta[name='csrf-token']").attr(
                        "content"
                    ),
                },
                beforeSend: function () {
                    $(".edit_enquiry_btn").attr("disabled", true).html(`
                        <span class="spinner-border spinner-border-sm align-middle me-1" role="status" aria-hidden="true"></span> ${_l(
                            "updating"
                        )}
                    `);
                },
                success: function (resp) {
                    $(".error-text").text("");
                    $(".form-control").removeClass("is-invalid is-valid");
                    $(".edit_enquiry_btn")
                        .removeAttr("disabled")
                        .html(_l("Update"));

                    if (resp.code === 200) {
                        showToast("success", resp.message);
                        $("#edit_enquiry_modal").modal("hide");

                        // reload enquiries list
                        enquiryList();
                    }
                },
                error: function (error) {
                    $(".error-text").text("");
                    $(".form-control").removeClass("is-invalid is-valid");
                    $(".edit_enquiry_btn")
                        .removeAttr("disabled")
                        .html(_l("Update"));

                    if (error.responseJSON.code === 422) {
                        $.each(error.responseJSON.errors, function (key, val) {
                            $("#" + key).addClass("is-invalid");
                            $("#" + key + "_error").text(val[0]);
                        });
                    } else {
                        showToast("error", error.responseJSON.message);
                    }
                },
            });
        },
    });

    $("#confirm-delete-btn").on("click", function () {
        let id = $("#delete_enquiry_modal #id").val();

        $.ajax({
            url: "/provider/enquiry/delete",
            type: "POST",
            data: { id: id },
            headers: {
                "X-CSRF-TOKEN": $('meta[name="csrf-token"]').attr("content"),
            }, // for Laravel
            success: function (response) {
                if (response.code === 200) {
                    showToast("success", response.message);
                    $("#delete_enquiry_modal").modal("hide");
                    enquiryList();
                } else {
                    showToast("error", response.message);
                }
            },
            error: function () {
                showToast("error", "Error deleting enquiry");
            },
        });
    });
});
$(document).on("click", ".delete-btn", function () {
    let id = $(this).data("id");
    $("#delete_enquiry_modal #id").val(id);
});

$(document).on("click", ".edit-btn", function () {
    let id = $(this).data("id");
    $("#edit_enquiry_modal #id").val(id);
});

function enquiryList() {
    $.ajax({
        url: "/provider/enquiry/list",
        type: "GET",
        headers: {
            Accept: "application/json",
        },

        success: function (response) {
            if (response.code === 200) {
                let tableBody = $("#enquiryTable tbody");
                let tableRow = "";
                let enquiries = response.data.data ?? response.data; // handle paginator or plain array

                if (enquiries.length === 0) {
                    if ($.fn.DataTable.isDataTable("#enquiryTable")) {
                        $("#enquiryTable").DataTable().destroy();
                    }
                    tableRow += `
                        <tr>
                            <td colspan="6" class="text-center">${
                                $("#enquiryTable").data("empty") ??
                                "No enquiries found"
                            }</td>
                        </tr>`;
                } else {
                    enquiries.forEach((record, index) => {
                        let enquiryPreview = record.enquiry_details.split(' ').slice(0, 7).join(' ');
                        if(record.enquiry_details.split(' ').length > 7){
                            enquiryPreview += '...';
                        }
                        tableRow += `
                            <tr>
                                <td>${index + 1}</td>
                                <td>${record.customer_name.charAt(0).toUpperCase() + record.customer_name.slice(1)}</td>
                                <td>${record.email}</td>
                                <td>${record.phone}</td>
                                <td>${enquiryPreview}</td>
                                <td>${record.enquiry_date}</td>
                                <td><span class="badge bg-info">${
                                    record.status.charAt(0).toUpperCase() +
                                    record.status.slice(1)
                                }</span></td>
                                <td>
                                    <a href="#" data-id="${
                                        record.id
                                    }" data-bs-toggle="modal" data-bs-target="#edit_enquiry_modal" class="btn btn-sm btn-primary edit-btn">View</a>
                                    <a href="#" data-id="${
                                        record.id
                                    }" data-bs-toggle="modal" data-bs-target="#delete_enquiry_modal" class="btn btn-sm btn-danger delete-btn">Delete</a>
                                </td>
                            </tr>
                        `;
                    });
                }

                tableBody.html(tableRow);

                if (
                    enquiries.length !== 0 &&
                    !$.fn.DataTable.isDataTable("#enquiryTable")
                ) {
                    $("#enquiryTable").DataTable({
                        ordering: true,
                        lengthChange: false,
                        searching: false,
                        pageLength: 10,
                    });
                }
            }
        },
        error: function () {
            showToast("error", "Error fetching enquiries");
        },
    });
}
