/* global $, loadTranslationFile, document, FormData, showToast, _l */

(async () => {
    "use strict";

    let maxPrice = $("#product_range_price").data('max_price') ?? 10000;
    let currencySymbol = $('body').data('currency') ?? '$'

    const params = new URLSearchParams(window.location.search);
    let categorySlug = params.get("category");
    let seachKeywords = params.get("keywords");

    if (categorySlug) {
        categorySlug = categorySlug.replace(/['"]+/g, "");
    }

    if (seachKeywords) {
        seachKeywords = seachKeywords.replace(/['"]+/g, "");
    }

    if (categorySlug) {
        $(`input[name='category'][data-slug='${categorySlug}']`).prop("checked", true);
    }

    $("#product_range_price").ionRangeSlider({
        type:"double",
        grid:!0,
        min:0,
        max: maxPrice,
        from:0,
        to: maxPrice,
        prefix: currencySymbol,
        onStart: updatePriceRange,
        onChange: updatePriceRange
    });

    function updatePriceRange(data) {
        $(".price_range_value").text(
            currencySymbol + data.from + " - " + currencySymbol + data.to
        );
    }

    await loadTranslationFile();
    let viewType = "grid";
    let page = 1;
    let pageLength = 6;
    const language_id = $('#language_id').val() || 1;

    // Object to hold all filter values
    let filters = {
        highlighted: [],
        shops: [],
        reviews: [],
        category: [],
        color: '',
        from_price: null,
        to_price: null,
        sort_by: 'new',
    };

    function updateAndFetch() {
        // Reset to page 1 for any new filter application
        page = 1;
        $("html, body").animate({ scrollTop: 0 }, "fast");
        fetchProducts(page);
    }

    // Initial fetch
    fetchProducts(page);

    function fetchProducts(currentPage = 1, reset = true) {

        // --- Collect all filter values right before the AJAX call ---
        filters.sort_by = $("#sort_by li.selected a").data("value") || 'new';

        const price_range = $('.price_range').val();
        if (price_range) {
            const [from, to] = price_range.split(";");
            filters.from_price = from || null;
            filters.to_price = to || null;
        }

        filters.highlighted = $("input[name='highlighted']:checked").map((_, el) => $(el).val()).get();
        filters.shops = $("input[name='shops[]']:checked").map((_, el) => $(el).val()).get();
        filters.category = $("input[name='category']:checked").map((_, el) => $(el).val()).get();
        filters.reviews = $("input[name='reviews']:checked").map((_, el) => $(el).val()).get();
        filters.color = $("input[name='color']:checked").val() || '';

        // Show loader
        if (reset == true) {
            $('.content-loader').removeClass('d-none');
        }

        if (currentPage === 1) {
            $(".productListCard").empty(); // Clear previous results only on new filter/first page
        }

        $.ajax({
            type: "GET",
            url: "/product/list",
            dataType: "json",
            data: {
                page: currentPage,
                paginate: pageLength,
                sort_by: filters.sort_by,
                highlighted: filters.highlighted,
                shops: filters.shops,
                reviews: filters.reviews,
                category: filters.category,
                color: filters.color,
                from_price: filters.from_price,
                to_price: filters.to_price,
                language_id: language_id,
				user_id: $('#user_id').val(),
            },
            beforeSend: function () {
                $("#load-more").attr("disabled", true).html(`
                    <span class="spinner-border spinner-border-sm align-middle me-1" role="status" aria-hidden="true"></span> ${_l("loading")}
                `);
                if (reset) {
                    $("#load-more").addClass("d-none");
                }
            },
            success: function (response) {
                $(".listCardDiv").removeClass().addClass(
                    viewType === "grid"
                        ? "listCardDiv row row-gap-4 productListCard"
                        : "listCardDiv row row-gap-4 productListCard"
                );

                const $productListCard = $(".productListCard");

                if (response.code === 200 && Array.isArray(response.data) && response.data.length > 0) {
                    const html = response.data.map((product) =>
                        viewType === "grid"
                            ? createProductGridCard(product)
                            : createProductListCard(product)
                    ).join("");

                    if (currentPage === 1) {
                        $productListCard.html(html);
                    } else {
                        $productListCard.append(html);
                    }

                    const pagination = response.pagination;
                    if (pagination.current_page < pagination.last_page) {
                        $("#load-more").data("page", pagination.current_page + 1);
                        $("#load-more").removeClass('d-none');
                    } else {
                        $("#load-more").addClass('d-none');
                    }

                    const from = (pagination.current_page - 1) * pagination.per_page + 1;
                    const to = Math.min(from + response.data.length - 1, pagination.total);
                    $("#total_product").text(
                        `${_l("showing")} ${from} - ${to} ${_l("of")} ${pagination.total} ${_l("results")}`
                    );
                } else if (currentPage === 1) {
                    $productListCard.html(`<h6 class="text-center w-100 mt-4">${_l("no_product_found")}</h6>`);
                    $("#load-more").addClass('d-none');
                     $("#total_product").text();
                }
            },
            error: function() {
                // Handle error case
                $(".productListCard").html(`<p class="text-center w-100">${_l("something_went_wrong")}</p>`);
            },
            complete: function () {
                setTimeout(() => {
                    $('.content-loader').addClass('d-none');
                    $("#load-more").removeAttr("disabled").html(`<i class="isax isax-rotate-left"></i> ${_l("load_more")}`);
                    $('#filterbtn').html(_l("apply")).prop("disabled", false);
                    $('.reset-filter').html(_l("reset")).prop("disabled", false);
                }, 100);
            },
        });
    }

    // --- EVENT LISTENERS ---

    // Apply Filter Button
    $(document).on("click", "#filterbtn", function (e) {
        e.preventDefault();

        let $btn = $(this);
        $btn.html('<span class="spinner-border spinner-border-sm me-2"></span>')
            .prop("disabled", true);

        updateAndFetch();
    });

    // Load More Button
    $("#load-more").on("click", function () {
        let nextPage = $(this).data("page");
        fetchProducts(nextPage, false);
    });

    // View Toggles
    $(document).on("click", ".viewType", function () {
        viewType = $(this).data("view");
        $(".viewType").removeClass("active");
        $(this).addClass("active");
        updateAndFetch();
    });

    // Sort Dropdown
    $(document).on("click", "#sort_by li", function () {
        $("#sort_by li").removeClass("selected");
        $(this).addClass("selected");
        $(".selected-value").text($(this).text());
        updateAndFetch();
    });

    // Page Length Dropdown
    $(document).on("change", "#pageLength", function () {
        pageLength = parseInt($(this).val(), 10) || 6;
        updateAndFetch();
    });

    // Reset Filter Button
    $(document).on("click", ".reset-filter, .text-danger.fs-16", function () {
        // Reset filter object
        filters = { highlighted: [], shops: [], reviews: [], category: [], color: '', from_price: null, to_price: null, sort_by: 'new' };

        // Uncheck all inputs and reset slider
        $('input[type="checkbox"]', '.product-sidebar').prop("checked", false);
        $('input[type="radio"]', '.product-sidebar').prop("checked", false);
        $('.price_range').data("ionRangeSlider").reset();

        if ($(this).hasClass("reset-filter")) {
            $(this).html('<span class="spinner-border spinner-border-sm me-2"></span>')
                .prop("disabled", true);
        }

        // Fetch with cleared filters
        updateAndFetch();
    });

   	function ucfirst(str) {
        if (!str) return "";
        return str.charAt(0).toUpperCase() + str.slice(1);
    }

    function createProductGridCard(product) {
    	const productName = ucfirst(product.name ?? "");
    	const productImages = `
					<a href="/productdetail/${product.slug}">
						<img src="${product.image}" class="img-fluid w-100" alt="${productName}">
					</a>
				`;
        const hasMultipleImages = 0;
    	const listingImage = hasMultipleImages
            ? `
            	<div class="product-img position-relative">
                    ${productImages}
                    <div class="product-status">
                    </div>
                    <div class="avatar user-avatar position-absolute bottom-0 left-0">
                        <img src="${product.image}" alt="brand-img-01" class="rounded-circle">
                    </div>
                    <div class="product-layout d-flex flex-column align-items-center justify-content-center gap-2">
                        <a href="javascript:void(0);" class="btn btn1 btn-icon btn-white frontend-list favourite" data-product-id="${product.id}" data-type="products">
                            <i class="isax ${product.wishlist ? 'text-danger isax-heart5' : 'isax-heart'}"></i>
                        </a>
                        <a href="/productdetail/${product.slug}" class="btn btn3 btn-icon btn-white"><i class="isax isax-eye"></i></a>
                    </div>
                </div>
    		`
            : `
            	<div class="product-img position-relative">
                    ${productImages}
                    <div class="product-status">
                        ${product.is_best_seller ?
                            `<span class="badge bg-purple badge-sm rounded d-flex align-items-center justify-content-center gap-1 position-absolute top-0 left-0">
                                <i class="isax isax-status-up"></i> ${_l('best_seller')}
                            </span>`
                            : (product.is_featured ? `
                                <span class="badge bg-info badge-sm rounded d-flex align-items-center justify-content-center gap-1 position-absolute top-0 left-0">
                                    <i class="isax isax-flag-2"></i> ${_l('featured')}
                                </span>
                            ` : '')
                        }
                    </div>
                    <div class="avatar user-avatar position-absolute bottom-0 left-0">
                        <img src="${product.profile_image}" alt="brand-img-01" class="rounded-circle">
                    </div>
                    <div class="product-layout d-flex flex-column align-items-center justify-content-center gap-2">
                        <a href="javascript:void(0);" class="btn btn1 btn-icon btn-white frontend-list favourite" data-product-id="${product.id}" data-type="products">
                            <i class="isax ${product.wishlist ? 'text-danger isax-heart5' : 'isax-heart'}"></i>
                        </a>
                        <a href="/productdetail/${product.slug}" class="btn btn3 btn-icon btn-white"><i class="isax isax-eye"></i></a>
                    </div>
                </div>
    		`;

    	const listingContent = `

    		<div class="product-content card-body">
                <div class="product-info mb-3">
                    ${renderRatingBlock(product)}
                    <h6 class="mb-0"><a href="/productdetail/${product.slug}" class="text-dark">${product.title}</a></h6>
                </div>
                <div class="product-action d-flex align-items-center justify-content-between gap-2 flex-wrap">
                    <h6 class="mb-0">${product.currency}${product.starts_from}</h6>
                    <div class="d-flex align-items-center justify-content-between gap-2 flex-wrap">
                        <a href="javascript:void(0);" class="btn btn-icon btn-dark add-to-cart-item" data-product-id="${product.id}"><i class="isax isax-shopping-cart"></i></a>
                    </div>
                </div>
            </div>
    	`;

       return `
       		<div class=" col-xl-4 col-lg-4 col-md-6 col-sm-6 d-flex">
                <div class="product-item mb-0 flex-fill">
                    ${listingImage}
                    ${listingContent}
                </div>
            </div>
	  	`
    }


    function renderRatingBlock(product) {
      let starsHtml = "";
      const maxStars = 5;

      for (let i = 1; i <= maxStars; i++) {
        if (i <= Math.floor(product.rating)) {
          starsHtml += `<i class="fa-solid fa-star text-warning"></i>`;
        } else if (i === Math.ceil(product.rating) && product.rating % 1 >= 0.5) {
          starsHtml += `<i class="fa-solid fa-star-half-stroke text-warning"></i>`;
        } else {
          starsHtml += `<i class="fa-regular fa-star text-warning"></i>`;
        }
      }

      return `
        <div class="d-flex align-items-center flex-wrap gap-2 mb-2">
          <div class="d-flex align-items-center fs-14">
            ${starsHtml}
          </div>
          <p class="fs-14 text-body mb-0">${product.rating} (${product.review_count} ${ product.review_count > 1 ? _l("Reviews") : _l("review") })</p>
        </div>
      `;
    }

    function createProductListCard(product) {

    	const productName = ucfirst(product.name ?? "");

        const hasMultipleImages = 0;
    	const listingImage = hasMultipleImages
            ? `
            	<div class="product-img product-img-list position-relative overflow-hidden">
                    <a href="/productdetail/${product.slug}">
                        <img src="${product.image}" class="img-fluid w-100" alt="product">
                    </a>
                    <div class="product-status">
                        ${product.is_best_seller ?
                            `<span class="badge bg-purple badge-sm rounded d-flex align-items-center justify-content-center gap-1 position-absolute top-0 left-0">
                                <i class="isax isax-status-up"></i> ${_l('best_seller')}
                            </span>`
                            : (product.is_featured ? `
                                <span class="badge bg-info badge-sm rounded d-flex align-items-center justify-content-center gap-1 position-absolute top-0 left-0">
                                    <i class="isax isax-flag-2"></i> ${_l('featured')}
                                </span>
                            ` : '')
                        }
                    </div>
                    <div class="avatar user-avatar position-absolute bottom-0 left-0">
                        <img src="${product.image}" alt="brand-img-01" class="rounded-circle">
                    </div>
                    <div class="product-layout d-flex flex-column align-items-center justify-content-center gap-2">
                        <a href="javascript:void(0);" class="btn btn1 btn-icon btn-white frontend-list favourite" data-product-id="${product.id}" data-type="products">
                            <i class="isax ${product.wishlist ? 'text-danger isax-heart5' : 'isax-heart'}"></i>
                        </a>
                        <a href="/productdetail/${product.slug}" class="btn btn3 btn-icon btn-white"><i class="isax isax-eye"></i></a>
                    </div>
                </div>
    		`
            : `
            	<div class="product-img product-img-list position-relative overflow-hidden">
                    <a href="/productdetail/${product.slug}">
                        <img src="${product.image}" class="img-fluid w-100" alt="product">
                    </a>
                    <div class="product-status">
                        ${product.is_best_seller ?
                            `<span class="badge bg-purple badge-sm rounded d-flex align-items-center justify-content-center gap-1 position-absolute top-0 left-0">
                                <i class="isax isax-status-up"></i> ${_l('best_seller')}
                            </span>`
                            : (product.is_featured ? `
                                <span class="badge bg-info badge-sm rounded d-flex align-items-center justify-content-center gap-1 position-absolute top-0 left-0">
                                    <i class="isax isax-flag-2"></i> ${_l('featured')}
                                </span>
                            ` : '')
                        }
                    </div>
                    <div class="avatar user-avatar position-absolute bottom-0 left-0">
                        <img src="${product.profile_image}" alt="brand-img-01" class="rounded-circle">
                    </div>
                    <div class="product-layout d-flex flex-column align-items-center justify-content-center gap-2">
                        <a href="javascript:void(0);" class="btn btn1 btn-icon btn-white frontend-list favourite" data-product-id="${product.id}" data-type="products">
                            <i class="isax ${product.wishlist ? 'text-danger isax-heart5' : 'isax-heart'}"></i>
                        </a>
                        <a href="/productdetail/${product.slug}" class="btn btn3 btn-icon btn-white"><i class="isax isax-eye"></i></a>
                    </div>
                </div>
    		`;

    	const listingContent = `
    		<div class="product-content card-body">
                <div class="product-info mb-3 pb-3 border-bottom">
                    <p class="mb-2 fw-medium text-body">${product.category}</p>
                    <h6 class="mb-3"><a href="/productdetail/${product.slug}" class="text-dark">${product.title}</a></h6>
                    ${renderRatingBlock(product)}
                    <p class="mb-0">${product.short_description}</p>
                </div>
                <div class="product-action d-flex align-items-center justify-content-between gap-2 flex-wrap">
                    <h6 class="mb-0 d-flex align-items-center gap-2">${product.currency}${product.starts_from}</h6>
                    <a href="#!" class="btn btn-dark d-flex align-items-center gap-2 add-to-cart-item" data-product-id="${product.id}"><i class="isax isax-shopping-cart"></i> ${_l('add_to_cart')}</a>
                </div>
            </div>
    	`;
       	return `
       		<div class="col-xl-12 col-lg-6 col-md-6 d-flex">
                <div class="product-item mb-0 d-flex flex-xl-row flex-xl-nowrap flex-wrap justify-content-start w-100 flex-fill">
                    ${listingImage}
                    ${listingContent}
                </div>
            </div>
	  	`
    }

})();