(async () => {
    "use strict";

    // Load translations first
    await loadTranslationFile(['download_invoice', 'downloading']);

    // DOM ready
    const invoiceElement = document.getElementById('invoiceContent');

    // Print button
    const printBtn = document.getElementById('printInvoice');
    printBtn.addEventListener('click', function () {
        const printContents = invoiceElement.innerHTML;
        const originalContents = document.body.innerHTML;

        document.body.innerHTML = printContents;
        window.print();
        document.body.innerHTML = originalContents;
        location.reload(); // reload JS
    });

    // Download button(s)
    document.querySelectorAll('.downloadinvoice').forEach(function(btn) {
        btn.addEventListener('click', function(e) {
		    if (btn.dataset.clicked === "true") {
		        e.preventDefault();
		        return;
		    }

		    btn.dataset.clicked = "true";
		    btn.classList.add('disabled');
		    btn.innerHTML = '<i class="isax isax-document-download me-1"></i> ' + _l("downloading");

		    setTimeout(function() {
		        btn.dataset.clicked = "false";
		        btn.classList.remove('disabled');
		        btn.innerHTML = '<i class="isax isax-document-download me-1"></i> ' + _l("download_invoice");
		    }, 5000);
		});

    });

})();
