const csrfToken = $('meta[name="csrf-token"]').attr('content');

// Mark all as read
$('#mark-all-read-btn').on('click', function(e) {
    e.preventDefault();
    $.ajax({
        url: "/provider/notifications/mark-all-read",
        type: 'POST',
        data: { _token: csrfToken },
        success: function(response) {
            if (response.code == '200') {
                showToast('success', response.message);
            } else {
                showToast('error', 'Could not mark notifications as read.');
            }
        },
        error: function() {
            showToast('error', 'An error occurred.');
        }
    });
});

// Clear All Notifications
$('#confirm-clear-all-btn').on('click', function() {
    $.ajax({
        url: "/provider/notifications/clear-all",
        type: 'POST',
        data: { _token: csrfToken },
        success: function(response) {
            if (response.success) {
                $('#clear_all_modal').modal('hide');
                showToast('success', response.message);
                setTimeout(() => window.location.reload(), 1000);
            }
        },
        error: function() {
            showToast('error', 'An error occurred.');
        }
    });
});

// Individual Delete Notification
let notificationToDeleteId = null;
$('#notification-list').on('click', '.delete-notification-btn', function() {
    notificationToDeleteId = $(this).data('id');
});

$('#confirm-delete-btn').on('click', function() {
    if (!notificationToDeleteId) return;

    $.ajax({
        url: `/provider/notifications/${notificationToDeleteId}`,
        type: 'DELETE',
        data: { _token: csrfToken },
        success: function(response) {
            if (response.success) {
                $('#delete_notification_modal').modal('hide');
                // FIX: Corrected typo from 'showtoastr' to 'toastr.success'
                showToast('success', response.message);
                
                // FIX: Manually remove the backdrop and then fade out the element to prevent overlay issue
                $('body').removeClass('modal-open');
                $('.modal-backdrop').remove();
                
                $('#notification-' + notificationToDeleteId).fadeOut(500, function() {
                    $(this).remove();
                    if ($('#notification-list').children().length === 0) {
                            $('#notification-list').html('<div class="card shadow-none booking-list"><div class="card-body d-flex align-items-center justify-content-center"><p class="text-center fw-bold w-100">No notifications found.</p></div></div>');
                    }
                });
            }
        },
        error: function() {
            showToast('error', 'An error occurred.');
        }
    });
});
