(async function () {
    "use strict";
    await loadTranslationFile();

    $(document).on('change', '.notification_status', function (e) {
        let status = $(this).is(':checked') ? 1 : 0;
        let type = $(this).data('notification_type');

        let formData = new FormData();
        formData.append(type, status);

        $.ajax({
            url:"/notification/update-preferences-settings",
            type:"POST",
            data: formData,
            contentType: false,
            processData: false,
            cache: false,
            headers: {
                "Accept": "application/json",
                "X-CSRF-TOKEN": $("meta[name='csrf-token']").attr("content")
            },
            success: function(response) {
                if(response.code == 200){
                    showToast("success", response.message);
                }
            },
            error: function(res) {
                if(res.responseJSON.code == 500){
                    showToast("error", res.responseJSON.message);
                }
            }
        });
    });

})();