(async () => {
    "use strict";
    await loadTranslationFile();

    // Function to fetch & render orders
    function loadOrders(page = 1) {
        $.ajax({
            url: "/customer/myorders/product_order_list",
            type: "GET",
            data: {
                search_value: $('#searchInput').val(),
                date_range: $('.reportrange-picker-field').text(),
                page: page
            },
            beforeSend: function () {
                $('.loader').removeClass('d-none');
                $("#orders-container").addClass('d-none');
            },
            success: function (res) {
                // Clear container
                $("#orders-container").empty();

                if (res.data.length === 0) {
                    $("#orders-container").html(`
                        <h5 class="text-center my-5">${_l('no_order_found')}</h5>
                    `);
                    return;
                }

                // Append each order as a card
                res.data.forEach(row => {
                    let card = `
                            <div class="purchase-item">
								<div class="d-flex align-items-center flex-wrap flex-sm-nowrap gap-3 overflow-hidden">
									<a href="/productdetail/${row.product_slug}" class="avatar avatar-lg flex-shrink-0">
										<img src="${row.image}" alt="${row.product_name}" class="img-fluid">
									</a>
									<div class="flex-grow-1 overflow-hidden">
										<div class="d-flex align-items-center gap-2 flex-wrap item-info mb-1">
											<p class="mb-0"><a href="/customer/products/order-invoice/${row.order_id}" class="link-secondary">${row.order_id}</a></p>
											<p class="mb-0">${row.categories ?? '-'}</p>
										</div>
										<h6 class="fs-16 fw-semibold text-truncate mb-0"><a href="/productdetail/${row.product_slug}">${row.product_name}</a></h6>
									</div>
								</div>
								<div>
									<p class="fs-14 mb-1">Purchased Date</p>
									<h6 class="fs-16 fw-semibold mb-0">${row.booking_date}</h6>
								</div>
								<div>
									<p class="fs-14 mb-1">Amount</p>
									<h6 class="fs-16 fw-semibold mb-0">${row.price}</h6>
								</div>
								<div>
									<span class="badge badge-sm ${row.status_class}">${row.status}</span>
								</div>
                                <div class="d-flex align-items-center justify-content-xl-end gap-2">
                                    <a href="#!"
                                        class="btn btn-sm btn-white d-inline-flex align-items-center view-details"
                                        data-id="${row.id}"
                                        data-bs-toggle="modal"
                                        data-bs-target="#view_details">
                                        <i class="isax isax-eye me-1"></i> ${_l("details")}
                                    </a>
                                    <a href="/customer/myorders/delivery-tracking-detail/${row.id}"
                                        class="btn btn-sm btn-white d-inline-flex align-items-center justify-content-center"
                                        data-id="${row.id}">
                                        <i class="isax isax-location-tick me-1"></i>${_l('track')}
                                    </a>
                                </div>
							</div>
                    `;

                    $("#orders-container").append(card);
                });

                // Pagination (if backend sends `res.links` like Laravel paginator)
                if (res.links) {
                    $("#orders-container").append(`
                        <nav class="mt-3">${res.links}</nav>
                    `);
                }
            },
            error: function () {
                $("#orders-container").html(`
                    <div class="alert alert-danger mb-0">
                        Failed to fetch orders. Please try again.
                    </div>
                `);
            },
            complete: function () {
                $('.loader').addClass('d-none');
                $("#orders-container").removeClass('d-none');
            }
        });
    }

    // Initial load
    loadOrders();

    // Search filter
    $('#searchInput').on('input', function () {
        loadOrders();
    });

    // Date range filter
    $('#reportrange').on('apply.daterangepicker', function (ev, picker) {
        $('.reportrange-picker-field').text(
            picker.startDate.format('D MMM YY') + ' - ' + picker.endDate.format('D MMM YY')
        );
        loadOrders();
    });

    // View details modal
    $(document).on('click', '.view-details', function () {
        let orderId = $(this).data('id');

        $('#view_details .modal-body').html(`
            <div class="text-center py-5">
                <div class="spinner-border text-primary" role="status">
                    <span class="visually-hidden">${_l('loading')}</span>
                </div>
                <p class="mt-2">Fetching order details...</p>
            </div>
        `);

        $.ajax({
            url: '/customer/products/get-order-details',
            type: 'GET',
            data: { id: orderId },
            success: function (res) {
                $('#order_id').html(res.order_id);
                $('#view_details .modal-body').html(res.html);
            },
            error: function () {
                $('#view_details .modal-body').html(`
                    <div class="alert alert-danger mb-0">
                        Failed to fetch details. Please try again.
                    </div>
                `);
            }
        });
    });

})();
