(async () => {
    "use strict";
    await loadTranslationFile();

    let table;
	let sortBy = 'newest'; // default newest
    let type = 'service';

    function loadInvoice() {
        table = $('#invoiceTable').DataTable({
            processing: false,
            serverSide: true,
            destroy: true,
            pageLength: 10,
            lengthChange: false,  // 🔹 removes "10 / 25 / 50 entries" dropdown
            searching: false,
            sorting: false,
            ordering: false,
            ajax: {
                url: "/customer/invoice_detail_list",
                data: function (d) {
                    // Add extra parameters to the request
                    d.sortBy = sortBy; // your input
                    d.date_range = $('.reportrange-picker-field').text();
                    d.type = type;
                },
                beforeSend: function () {
                    $('.real-table').addClass('d-none');
                    $('.spinner-loader').removeClass('d-none');
                },
            },
            initComplete: function () {
                $('.real-table').removeClass('d-none');
                $('.spinner-loader').addClass('d-none');
            },
            columns: [
                {
                    data: 'invoice_id',
                    name: 'invoice_id',
                    render: function (data, type, row) {
                        return `
                        	<a href="/customer/products/order-invoice/${row.order_id}">${row.order_id}</a>
                        `;
                    }
                },
                {
                    data: 'invoice_date',
                    name: 'invoice_date',
                    render: function (d) {
                        return `<td>${d}</td>`;
                    }
                },
                {
                    data: 'description',
                    name: 'description',
                    render: function (d) {
                        return `<td class="fw-medium">${d}</td>`;
                    }
                },
                {
                    data: 'amount',
                    name: 'amount',
                    render: function (d, type, row) {
                        return `<td>${d}</td>`;
                    }
                },
                {
                    data: 'due_date',
                    name: 'due_date',
                    render: function (d) {
                        return `<td>${d}</td>`;
                    }
                },
                {
                    data: 'payment_status_label',
                    name: 'payment_status_label',
                    render: function (d, type, row) {
                        let statusClass = "badge-soft-warning";
                        if (row.payment_status == 1) {
                            statusClass = "badge-soft-warning";
                        } else if(row.payment_status == 2) {
                            statusClass = "badge-soft-success";
                        } else {
                            statusClass = "badge-soft-danger";
                        }
                        return `<td><span class="badge badge-sm ${statusClass}">${d}</span></td>`;
                    }
                },
                {
                    data: 'id',
                    render: function (id, type, row, meta) {
                        const status = parseInt(row.product_status); // force number
                        if (status !== 5 && status !== 6) {
                            return `
                            	<a href="/customer/products/order-invoice/${row.order_id}" class="btn btn-sm btn-light border p-2 d-inline-flex align-items-center justify-content-center rounded-circle">
                            		<i class="isax isax-eye fs-14"></i>
                            	</a>`;
                        } else {
                            return `-`;
                        }
                    }
                }

            ]
        });
    }

    // Initial load
    loadInvoice();

    $(document).on('click', '.sort-option', function () {
	    sortBy = $(this).data('value'); // get selected value
        loadInvoice();
	});

    $(document).on('click', '.invoice_tab', function () {
        type = $(this).data('type');
        loadInvoice();
    });

    // For date range picker
    $('#reportrange').on('apply.daterangepicker', function (ev, picker) {
        $('.reportrange-picker-field').text(
            picker.startDate.format('D MMM YY') + ' - ' + picker.endDate.format('D MMM YY')
        );
        loadInvoice();
    });

})();