(async function () {
    "use strict";

    $(".select2").select2({
        minimumResultsForSearch: 0,
        width: '100%',
    });

    $(document).on("click", "#bookServiceButton", function () {
        const productSlug = $(this).data("product_slug");
        $(".book-btn").text("Please Wait...").prop("disabled", true);
        $.ajax({
            url: "/check-product-user",
            type: "GET",
            data: { product_slug: productSlug },
            success: function (response) {
                if (response.exists === "yes") {
                    window.location.href = `/user/booking/service-booking/${productSlug}`;
                } else {
                    window.location.href = `/user/booking/${productSlug}`;
                }
            },
            complete: function () {
                $(".book-btn").text("Book Service").prop("disabled", false);
            },
        });
    });

    $("#bannerSearchForm").on("submit", function (e) {
        e.preventDefault();

        let selectedOption = $("#home_category option:selected");
        let categorySlug = selectedOption.data("slug") ?? "all";
        let keywords = $("#keyword").val();

        let formData = new URLSearchParams({
            category: categorySlug,
            keywords: keywords
        });
        window.location.href = `/services?${formData}`;
    });
})();