(async () => {
    "use strict";
    await loadTranslationFile();
    $(document).ready(function() {
        // Event delegation for cancel button click
        $(document).on('click', '.cancel-booking-btn', function() {
            var bookingId = $(this).data('booking-id');
            $('#booking_id_to_cancel').val(bookingId);
            $('#cancel_booking').modal('show');
        });

        // Handle the cancellation form submission
        $('#cancelBookingForm').on('submit', function(e) {
            e.preventDefault();
            var form = $(this);
            var formData = form.serialize();
            var submitButton = form.find('button[type="submit"]');

            submitButton.prop('disabled', true).text(_l("cancelling"));

            $.ajax({
                url: "/customer/order/cancel",
                type: 'POST',
                data: formData,
                dataType: 'json',
                success: function(response) {
                    $('#cancel_booking').modal('hide');
                    showToast("success", response.message || _l("cancel_restrict"));
                    window.location.reload();
                },
                error: function(xhr) {
                    if (xhr.responseJSON && xhr.responseJSON.message) {
                        errorMessage = xhr.responseJSON.message;
                    }
                    showToast("error", response.message || _l("cancel_restrict"));
                },
                complete: function() {
                    submitButton.prop('disabled', false).text(_l("Yes, Cancel"));
                    form[0].reset();
                }
            });
        });
        $('#refund_initiate').on('submit', function(e) {
            e.preventDefault();
            var form = $(this);
            var formData = form.serialize();
            var submitButton = form.find('button[type="submit"]');

            submitButton.prop('disabled', true).text(_l("refund_initiated"));

            $.ajax({
                url: "/customer/order/refund_initiate",
                type: 'POST',
                data: { id : $('#refund_amount').val()},
                dataType: 'json',
                 headers: {
                    "X-CSRF-TOKEN": $("meta[name='csrf-token']").attr("content")
                },
                success: function(response) {
                    $('#refund_initiate').modal('hide');
                    showToast("success", response.message || _l("something_went_wrong"));
                    window.location.reload();
                },
                error: function(xhr) {
                    let errorMessage = _l("something_went_wrong"); // default

                    if (xhr.responseJSON && xhr.responseJSON.message) {
                        errorMessage = xhr.responseJSON.message;
                    }

                    showToast("error", errorMessage);
                },
                complete: function() {
                    submitButton.prop('disabled', false).text(_l("Yes"));
                    form[0].reset();
                }
            });
        });

        $(document).on('click', '.refund-booking-btn', function() {
            var bookingId = $(this).data('booking-id');
            $('#refund_booking_id').val(bookingId);
            $('#refund_initiate').modal('show');
        });

    });
})();