(async function () {
    "use strict";
    await loadTranslationFile();

    $(document).ready(function () {
        $("#deleteAccountForm").validate({
            rules: {
                password: {
                    required: true,
                },
            },
            messages: {
                password: {
                    required: _l("password_required"),
                },
            },
            errorPlacement: function (error, element) {
                var errorId = element.attr("id") + "_error";
                $("#" + errorId).text(error.text());
            },
            highlight: function (element) {
                $(element).addClass("is-invalid").removeClass("is-valid");
            },
            unhighlight: function (element) {
                $(element).removeClass("is-invalid").addClass("is-valid");
                var errorId = element.id + "_error";
                $("#" + errorId).text("");
            },
            onkeyup: function (element) {
                $(element).valid();
            },
            onchange: function (element) {
                $(element).valid();
            },
            submitHandler: function (form) {
                $.ajax({
                    url: "/user/delete-account",
                    type: "POST",
                    headers: {
                        "X-CSRF-TOKEN": $('meta[name="csrf-token"]').attr("content"),
                    },
                    data: {
                        id: $("#deleteAccountBtn").data("id"),
                        password: $("#password").val(),
                    },
                    dataType: "json",
                    beforeSend: function () {
                        $("#deleteAccountBtn")
                            .attr("disabled", true)
                            .html(
                                '<span class="spinner-border spinner-border-sm align-middle" role="status" aria-hidden="true"></span>'
                            );
                    },
                    success: function (response) {
                        $(".error-text").text("");
                        $("#deleteAccountBtn")
                            .removeAttr("disabled")
                            .html(_l('Delete Account'));
                        $(".form-control").removeClass("is-invalid is-valid");
                        $("#del-account").modal("hide");
                        if (response.code === 200) {
                            var homePageUrl = window.location.origin + "/";
                            window.location.href = homePageUrl;
                            showToast("success", response.message);
                        }
                    },
                    error: function (error) {
                        $(".error-text").text("");
                        $("#deleteAccountBtn")
                            .removeAttr("disabled")
                            .html(_l('Delete Account'));
                        $(".form-control").removeClass("is-invalid is-valid");
                        if (error.responseJSON.code === 422) {
                            $.each(error.responseJSON.errors, function (key, val) {
                                $("#" + key + "_del").addClass("is-invalid");
                                $("#" + key + "_del_error").text(val[0]);
                            });
                        } else {
                            showToast('error', error.responseJSON.message);
                        }
                    },
                });
            },
        });
    });

    $(document).on("click", "#del_account_btn", function () {
        $(".error-text").text("");
        $(".form-control").removeClass("is-invalid is-valid");
        $("#password").val("");
    });
})();