(async () => {
    "use strict";
    await loadTranslationFile();
    $(document).ready(function() {
	    function loadDashboardStats() {
	        const container = $('#booking-list-container');
			$('.spinner-loader').removeClass('d-none'); // show loader
			container.html(''); // clear previous content
	        $("#dashboardStats").html("");
	        $.ajax({
	            url: "/customer/dashboard/transaction-report",
	            method: "POST",
	            headers: {
                    Accept: "application/json",
                    "X-CSRF-TOKEN": $('meta[name="csrf-token"]').attr("content")
                },
	            data: {
	                selected_date: $('.reportrange-picker-field').text(),
	            },
	            success: function(response) {
	                $("#dashboardStats").html(response.html);
	            },
	            error: function() {
	                alert("Failed to load stats");
	            },
	            complete: function() {
	            	$(".spinner-loader").addClass('d-none');
	            },
	        });
	    }

	    // Load initially
	    loadDashboardStats();

		// For date range picker
		$('#reportrange').on('apply.daterangepicker', function (ev, picker) {
			$('.reportrange-picker-field').text(
				picker.startDate.format('D MMM YY') + ' - ' + picker.endDate.format('D MMM YY')
			);
			loadDashboardStats();
		});
	});

})();
