(async function () {
    "use strict";
    await loadTranslationFile();

        $(document).ready(function() {

        // Setup CSRF token for all AJAX requests
        $.ajaxSetup({
            headers: {
                'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
            }
        });

        // Function to load upcoming bookings
        function loadBookings() {
            const container = $('#booking-list-container');
            container.html('<div class="spinner-loader"></div>'); // Show loader

            $.ajax({
                url: "/customer-booking-cancelled-list",
                type: 'POST',
                dataType: 'json',
                success: function(response) {
                    container.empty(); // Clear loader
                    if (response.data && response.data.length > 0) {
                        $.each(response.data, function(index, booking) {

                            // --- MODIFICATION START ---
                            var actionHtml = '';

                            // Check the booking status with the new condition
                            if (booking.booking_status == 4) {
                                // If status is 4, show "Refund Initiated"
                                actionHtml = `<span class="badge bg-soft-info text-info d-inline-flex align-items-center">${_l('refund_initiated')}</span>`;
                            } else if (booking.booking_status == 7) {
                                // ✅ If status is 7, show "Refund Completed"
                                if (booking.refund_payment_proof) {
                                    // Show "Refund Completed" + "View Proof"
                                    actionHtml = `
                                            <span class="badge bg-soft-success text-success d-inline-flex align-items-center">${_l('refund_completed')}</span>
                                            <a href="${booking.refund_payment_proof}" target="_blank" class="btn btn-sm btn-white d-inline-flex align-items-center">
                                                <i class="isax isax-eye me-1"></i> ${_l('view_proof')}
                                            </a>`;
                                } else {
                                    // No proof, just show refund completed
                                    actionHtml = `<span class="badge bg-soft-success text-success d-inline-flex align-items-center">${_l('refund_completed')}</span>`;
                                }
                            } else {
                                // Otherwise, show the "Request Refund" button
                                actionHtml = `
                                <a href="javascript:void(0);" class="btn btn-sm btn-primary d-inline-flex align-items-center refund-booking-btn" data-booking-id="${booking.booking_id}">
                                    <i class="isax isax-money-recive me-1"></i> ${_l('request_refund')}
                                </a>`;
                            }
                            // --- MODIFICATION END ---

                            var bookingHtml = `
                            <div class="booking-item">
                                <div class="row row-gap-3 align-items-center">
                                    <div class="col-xl-8">
                                        <div class="d-flex align-items-center flex-wrap flex-sm-nowrap gap-2 overflow-hidden">
                                            <a href="#" class="avatar avatar-xxl flex-shrink-0">
                                                <img src="${booking.image_url}" alt="service" class="img-fluid">
                                            </a>
                                            <div class="flex-grow-1 overflow-hidden">
                                                <a href="javascript:void(0);" class="d-block text-secondary fs-14 mb-1">#${booking.order_id}</a>
                                                <h6 class="fs-16 fw-semibold text-truncate mb-1"><a href="#">${booking.source_name}</a></h6>
                                                <div class="d-flex align-items-center gap-2 flex-wrap item-info">
                                                    <p class="d-inline-flex align-items-center mb-0"><i class="isax isax-category-2 me-1"></i>Category : ${booking.source_subcategory || 'N/A'}</p>
                                                    <p class="d-inline-flex align-items-center mb-0"><i class="isax isax-calendar-tick me-1"></i>Date : ${booking.booking_date_formatted}</p>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="col-xl-4">
                                       <div class="d-flex align-items-center justify-content-xl-end gap-2">
                                            ${actionHtml}  </div>
                                    </div>
                                </div>
                            </div>
                            `;
                            container.append(bookingHtml);
                        });
                    } else {
                        container.html(`<h5 class="text-center my-5">${_l('no_cancelled_bookings')}</h5>`);
                    }
                },
                error: function(xhr, status, error) {
                    container.html('<div class="alert alert-danger">Failed to load bookings. Please try again later.</div>');
                }
            });
        }


        // Initial load of bookings
        loadBookings();

        // The rest of your script (modal handlers, form submission) remains the same

        $(document).on('click', '.refund-booking-btn', function() {
            var bookingId = $(this).data('booking-id');
            $('#booking_id_to_refund').val(bookingId);
            $('#refund_booking').modal('show');
        });

        // Handle the cancellation form submission
        $('#cancelBookingForm').on('submit', function(e) {
            e.preventDefault();
            var form = $(this);
            var formData = form.serialize();
            var submitButton = form.find('button[type="submit"]');

            submitButton.prop('disabled', true).text(_('submitting'));

            $.ajax({
                url: "/customer-booking-upcoming-refund",
                type: 'POST',
                data: formData,
                dataType: 'json',
                success: function(response) {
                    $('#refund_booking').modal('hide');
                    showToast("success", response.message);
                    loadBookings();
                },
                error: function(xhr) {
                    var errorMessage = 'An error occurred. Please try again.';
                    if (xhr.responseJSON && xhr.responseJSON.message) {
                        errorMessage = xhr.responseJSON.message;
                    }
                    showToast("error", errorMessage);
                },
                complete: function() {
                    submitButton.prop('disabled', false).text('Yes');
                    form[0].reset();
                }
            });
        });
    });

})();