/* global $, document, showToast, setTimeout, moment, FormData, window, bootstrap, flatpickr, DOMParser, location*/

(async function () {
    "use strict";

    window.showToast = function(toastType, message) {
         let toastId = '';
        if (toastType === 'success') {
            toastId = 'successToast';
        } else if (toastType === 'error') {
            toastId = 'dangerToast';
        } else if (toastType === 'warning') {
            toastId = 'warningToast';
        } else if (toastType === 'info') {
            toastId = 'infoToast';
        } else if (toastType === 'secondary') {
            toastId = 'secondaryToast';
        } else {
            toastId = 'primaryToast';
        }

        var toastElement = document.getElementById(toastId);
        if (toastElement) {
            toastElement.querySelector(".toast-body").innerText = message;

            var toast = new bootstrap.Toast(toastElement, {
                animation: true,
                autohide: true,
                delay: 2000,
            });
            toast.show();
        }
    }

    $("#newsletterForm").validate({
        rules: {
            subscriber_email: {
                required: true,
                email: true,
            }
        },
        messages:{
            subscriber_email: {
                required: $("#subscriber_email_error").data("required"),
                email: $("#subscriber_email_error").data("valid"),
            }
        },
        errorPlacement: function (error, element) {
            const errorId = element.attr("id") + "_error";
            $("#" + errorId).text(error.text());
        },
        highlight: function (element) {
            if ($(element).hasClass("select2-hidden-accessible")) {
                $(element).next(".select2-container").addClass("is-invalid").removeClass('is-valid');
            }
            $(element).addClass("is-invalid").removeClass("is-valid");
        },
        unhighlight: function (element) {
            if ($(element).hasClass("select2-hidden-accessible")) {
                $(element).next(".select2-container").removeClass("is-invalid").addClass('is-valid');
            }
            $(element).removeClass("is-invalid").addClass("is-valid");
            var errorId = element.id + "_error";
            $("#" + errorId).text("");
        },
        onkeyup: function(element) {
            $(element).valid();
        },
        onchange: function(element) {
            $(element).valid();
        },
        submitHandler: function(form) {
            let formData = new FormData(form);
            let theme = $('body').attr('data-theme');
            $.ajax({
                type:"POST",
                url:"/user/save-newsletter-subscriber",
                data: formData,
                processData: false,
                contentType: false,
                global: true,
                headers: {
                    'Accept': 'application/json',
                    'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                },
                beforeSend: function () {
                     $(".submitbtn").attr("disabled", true).html(
                        "<div class=\"spinner-border text-light\" role=\"status\"></div>"
                    );
                },
                success:function(resp){
                    $(".error-text").text("");
                    $(".form-control").removeClass("is-invalid is-valid");
                    $(".submitbtn").removeAttr("disabled").html($(".submitbtn").data("subscribe"));
                    if (resp.code === 200) {
                        showToast('success', resp.message);
                        $('#newsletterForm')[0].reset();
                    }
                },
                error:function(error){
                    $(".error-text").text("");
                    $(".form-control").removeClass("is-invalid is-valid");
                    $(".submitbtn").removeAttr("disabled").html($(".submitbtn").data("subscribe"));
                    if (error.responseJSON.code === 422) {
                        $.each(error.responseJSON.errors, function(key, val) {
                            $("#" + key).addClass("is-invalid");
                            $("#" + key + "_error").text(val[0]);
                        });
                    } else {
                        showToast('error', error.responseJSON.message);
                    }
                },
                complete: function() {
                    // Ensure button is re-enabled and loader is properly managed
                    $(".submitbtn").removeAttr("disabled").html($(".submitbtn").data("subscribe"));
                }
            });
        }
    });

    $(document).on("click",".change-user-language", function () {
        let languageCode = $(this).data("language_code");
        let language_id = $(this).data("id");
        $.ajax({
            type:"GET",
            url:"/languagedefault/"+language_id,
            global: true,
            success: function (response) {
                if (response.success === true) {
                    location.reload();
                }
            },
            error: function(xhr, status, error) {
                // Show error toast if needed
                if (xhr.responseJSON && xhr.responseJSON.message) {
                    showToast('error', xhr.responseJSON.message);
                }
            }
        });

    });
    // Initialize loader when DOM is ready
    $(document).ready(function() {
        // initializeLoader();
    });

    // Improved AJAX loader management
    let ajaxCount = 0;


    // Force hide loader function for emergency use
    window.forceHideLoader = function() {
        ajaxCount = 0;
        const loader = document.getElementById("");
        if (loader) {
            loader.classList.add("hidden");
        }
    };

    // Safety timeout to prevent loader from getting stuck
    setInterval(function() {
        if (ajaxCount > 0) {
            console.warn("Loader safety check: ajaxCount > 0 for too long, forcing reset");
            // Only force hide if it's been stuck for more than 30 seconds
            if (ajaxCount > 0) {
                window.forceHideLoader();
            }
        }
    }, 30000); // Check every 30 seconds

    function loadWishlist(type, page, load = '') {
        $('#loader').show();
        $.ajax({
            url: "/customer/wishlist/load",
            method: "GET",
            data: { type, page, previous_ids: $('#all_ids').val() },
            success: function (response) {
                if (load === '') $('#wishlist-content-' + type).empty();

                $("#all_ids").attr("data-type", type);
                $("#all_ids").val(response.serviceIds);

                let html = '';
                if (response.html === '') {
                    html = '<p>'+_l("no_record_found")+'</p>';
                    $('#' + type + '-load-more').addClass('d-none');
                } else {
                    html = response.html;
                    if (response.hasMore) {
                        $('#' + type + '-load-more').removeClass('d-none')
                        .attr('data-page', response.next_page);
                    } else {
                        $('#' + type + '-load-more').addClass('d-none');
                    }
                }

                $('#wishlist-content-' + type).append(html);
                $('#loader').hide();
            },
            error: function () {
                $('#loader').hide();
            }
        });
    }

    // Wishlist toggle (products)
    $(document).on('click', '.favourite', function () {
        const $btn = $(this);
        const productId = $btn.data('product-id');
        if (!productId) return;
        const type = $btn.data('type');
        if (!type) return;
        const authid = $('body').data('authid');

        if (!authid) {
            showToast('warning', 'Please login to continue.');
            setTimeout(() => {
                window.location.href = '/user/login';
            }, 100);
            return;
        }

        $.ajax({
            type: 'POST',
            url: '/wishlist/toggle',
            data: {
                product_id: productId,
                _token: $('meta[name="csrf-token"]').attr('content'),
                type : type,
            },
            beforeSend: function () {
                $btn.addClass('disabled');
            },
            complete: function () {
                $btn.removeClass('disabled');
            },
            success: function (resp) {
                if (resp.code === 200) {
                    if (resp.in_wishlist) {
                        $btn.find('i').addClass('text-danger isax-heart5').removeClass('isax-heart');
                    } else {
                        $btn.find('i').removeClass('text-danger isax-heart5').addClass('isax-heart');
                    }
                    showToast('success', resp.message);
                    loadWishlist(type, 1, '');
                } else if (resp.code == 401) {
                    showToast('warning', 'Please login to continue.');
                    window.location.href = '/user/login';
                } else {
                    showToast('warning', resp.message || 'Unable to update wishlist');
                }
            },
            error: function (xhr) {
                if (xhr.status == 401) {
                    showToast('warning', 'Please login to continue.');
                    window.location.href = '/user/login';
                    return;
                } else {
                    showToast('error', 'Unable to update wishlist');
                }
            }
        });
    });

    // Reusable "Show More/Less" Toggle for Multiple Sections
    let showMoreText = $("body").data("show_more") || "Show More";
    let showLessText = $("body").data("show_less") || "Show Less";
	for (let i = 0; i <= 6; i++) {
		const moreMenu = $(`.more-menu-item${i || ''}`);
		const viewAllBtn = $(`.view-all-item${i || ''}-button`);

		if (moreMenu.length > 0) {
			moreMenu.hide();
			viewAllBtn.on("click", function () {
				const isLess = $(this).text() == showLessText || $(this).text() === "Show Less";
				$(this).text(isLess ? showMoreText : showLessText);
				moreMenu.slideToggle(900);
			});
		}
	}
    var pageValue = $("body").data("provider");
    if (pageValue === "contact-us") {
        var langCode = $("body").data("lang");

        let currentLang = langCode;

        const validationMessages = {
            en: {
                name: {
                    required: "Name is required.",
                    maxlength: "Name cannot be exceed 100 characters.",
                    pattern: "Name must contain only alphabets and spaces.",
                },
                email: {
                    required: "Email is required.",
                    email: "Please enter a valid email.",
                },
                phone_number: {
                    required: "Phone number is required.",
                    digits: "Phone number must be a number.",
                    minlength: "Phone number must be between 10 to 12 digits.",
                    maxlength: "Phone number must be between 10 to 12 digits.",
                },
                message: {
                    required: "Message is required.",
                },
            },
            ar: {
                name: {
                    required: "الاسم مطلوب.",
                    maxlength: "لا يمكن أن يتجاوز الإسم 100 حرف.",
                    pattern: "يجب أن يحتوي الاسم على الحروف الأبجدية فقط.",
                },
                email: {
                    required: "البريد الإلكتروني مطلوب.",
                    email: "الرجاء إدخال بريد إلكتروني صالح.",
                },
                phone_number: {
                    required: "رقم الهاتف مطلوب.",
                    digits: "رقم الهاتف يجب أن يكون رقماً.",
                    minlength: "يجب أن يكون رقم الهاتف بين 10 إلى 12 رقمًا.",
                    maxlength: "يجب أن يكون رقم الهاتف بين 10 إلى 12 رقمًا.",
                },
                message: {
                    required: "الرسالة مطلوبة.",
                },
            },
        };

        $("#contactForm").validate({
            rules: {
                name: {
                    required: true,
                    maxlength: 100,
                    pattern: /^[A-Za-z\s]+$/,
                },
                email: {
                    required: true,
                    email: true,
                },
                phone_number: {
                    required: true,
                    digits: true,
                    minlength: 10,
                    maxlength: 12,
                },
                message: {
                    required: true,
                },
            },
            messages: validationMessages[currentLang],
            errorPlacement: function (error, element) {
                var errorId = element.attr("id") + "_error";
                $("#" + errorId).text(error.text());
            },
            highlight: function (element) {
                $(element).addClass("is-invalid").removeClass("is-valid");
            },
            unhighlight: function (element) {
                $(element).removeClass("is-invalid").addClass("is-valid");
                var errorId = element.id + "_error";
                $("#" + errorId).text("");
            },
            onkeyup: function (element) {
                $(element).valid();
            },
            onchange: function (element) {
                $(element).valid();
            },
            submitHandler: function (form) {
                var formData = {
                    name: $("#contact_name").val(),
                    email: $("#contact_email").val(),
                    phone_number: $("#contact_phone_number").val(),
                    message: $("#message").val(),
                };
                $.ajax({
                    url: "/api/save-contact-details",
                    type: "POST",
                    data: formData,
                    dataType: "json",
                    beforeSend: function () {
                        $("#contactSaveBtn")
                            .attr("disabled", true)
                            .html(
                                '<span class="spinner-border spinner-border-sm align-middle" role="status" aria-hidden="true"></span> Sending...'
                            );
                    },
                    success: function (response) {
                        $(".error-text").text("");
                        $(".form-control").removeClass("is-invalid is-valid");
                        $("#contactSaveBtn")
                            .removeAttr("disabled")
                            .html(
                                'Send Message<i class="feather-arrow-right-circle ms-2"></i>'
                            );
                        if (response.code === 200) {
                            toastr.success(response.message);
                            $("#contactForm").trigger("reset");
                        }
                    },
                    error: function (error) {
                        $(".error-text").text("");
                        $(".form-control").removeClass("is-invalid is-valid");
                        $("#contactSaveBtn")
                            .removeAttr("disabled")
                            .html(
                                'Send Message<i class="feather-arrow-right-circle ms-2"></i>'
                            );
                        if (error.responseJSON.code === 422) {
                            $.each(error.responseJSON.errors, function (key, val) {
                                $("#" + key).addClass("is-invalid");
                                $("#" + key + "_error").text(val[0]);
                            });
                        } else {
                            toastr.error(error.responseJSON.message);
                        }
                    },
                });
            },
        });
    }

    $(document).on('click', '.add-to-cart-item', function () {
        let productId = $(this).data("product-id");

        console.log(productId);

        $.ajax({
            url: "/user/cart/add",
            method: "POST",
            data: {
                _token: $('meta[name="csrf-token"]').attr("content"),
                product_id: productId,
            },
            beforeSend: function () {
                // button.prop("disabled", true).html(`
                //     <div class="spinner-border spinner-border-sm align-middle me-1" role="status" aria-hidden="true"></div>
                // `);
            },
            success: function (response) {
                if (response.success) {
                    $(".cart-item-count").text(response.cartCount);
                    window.location.href = "/user/cart";
                }
            },
            error: function () {

            }
        });
    });
document.addEventListener("DOMContentLoaded", function () {
    const cookieConsentBanner = document.querySelector(".cookie-consent");
    const cookieConsentAgreeButton = document.querySelector(".cookie-consent__agree");
    const cookieConsentDeclineButton = document.querySelector(".cookie-consent__decline");

    if (!cookieConsentBanner) return; // Exit if no banner on page

    // Check if consent is already given
    const cookieConsentValue = document.cookie
        .split("; ")
        .find((row) => row.startsWith("cookie_consent="))
        ?.split("=")[1];

    if (cookieConsentValue === "1" || cookieConsentValue === "0") {
        cookieConsentBanner.style.display = "none";
    } else {
        // Show banner after 2s delay
        setTimeout(() => {
            cookieConsentBanner.style.display = "block"; // make it visible
            cookieConsentBanner.classList.add("visible"); // optional, for animation
            cookieConsentBanner.classList.remove("hidden");
        }, 2000);
    }

    // Accept button
    if (cookieConsentAgreeButton) {
        cookieConsentAgreeButton.addEventListener("click", function () {
            document.cookie = "cookie_consent=1; path=/; max-age=" + 60 * 60 * 24 * 30;
            cookieConsentBanner.style.display = "none";
        });
    }

    // Decline button
    if (cookieConsentDeclineButton) {
        cookieConsentDeclineButton.addEventListener("click", function () {
            document.cookie = "cookie_consent=0; path=/; max-age=" + 60 * 60 * 24 * 30;
            cookieConsentBanner.style.display = "none";
        });
    }
});


})();