(async function () {
    "use strict";
    await loadTranslationFile();

    $(document).ready(function () {
        $("#changePasswordForm").validate({
            rules: {
                current_password: {
                    required: true,
                    minlength: 8,
                    remote: {
                        url: "/api/admin/check-password",
                        type: "post",
                        headers: {
                            Authorization:
                                "Bearer " + localStorage.getItem("admin_token"),
                            Accept: "application/json",
                        },
                        data: {
                            current_password: function () {
                                return $("#current_password").val();
                            },
                            id: function () {
                                return $("#id").val();
                            },
                        },
                    },
                },
                new_password: {
                    required: true,
                    minlength: 8,
                    notEqualTo: "#current_password",
                },
                confirm_password: {
                    required: true,
                    equalTo: "#new_password",
                },
            },
            messages: {
                current_password: {
                    required: _l("current_password_required"),
                    minlength: _l("current_password_minlength"),
                    remote: _l("incorrect_password"),
                },
                new_password: {
                    required: _l("new_password_required"),
                    minlength: _l("new_password_minlength"),
                    notEqualTo: _l("new_password_notEqualTo"),
                },
                confirm_password: {
                    required: _l("confirm_password_required"),
                    equalTo: _l("confirm_password_equalTo"),
                },
            },
            errorPlacement: function (error, element) {
                var errorId = element.attr("id") + "_error";
                $("#" + errorId).text(error.text());
            },
            highlight: function (element) {
                $(element).addClass("is-invalid").removeClass("is-valid");
            },
            unhighlight: function (element) {
                $(element).removeClass("is-invalid").addClass("is-valid");
                var errorId = element.id + "_error";
                $("#" + errorId).text("");
            },
            onkeyup: function (element) {
                $(element).valid();
            },
            onchange: function (element) {
                $(element).valid();
            },
            submitHandler: function (form) {
                let url = "admin/change-password";
                let btnId = "#change_password";
                let data = new FormData(form);
                data.append("id", $("#id").val());

                saveAdminDetails(data, url, btnId);
            },
        });

        function saveAdminDetails(data, url, btnId) {
            $.ajax({
                url: "/api/" + url,
                type: "POST",
                data: data,
                enctype: "multipart/form-data",
                contentType: false,
                processData: false,
                cache: false,
                beforeSend: function () {
                    $(btnId)
                        .attr("disabled", true)
                        .html(
                            `<span class="spinner-border spinner-border-sm align-middle" role="status" aria-hidden="true"></span> ${_l("saving")}`
                        );
                },
                success: function (response) {
                    $(".error-text").text("");
                    $(btnId).removeAttr("disabled").html(_l("save_changes"));
                    $(".form-control").removeClass("is-invalid is-valid");
                    if (response.code === 200) {
                        $("#change-password").modal("hide");
                        showToast('success', response.message);
                    }
                    if ((btnId = "#change_password")) {
                        $("#current_password").val("");
                        $("#new_password").val("");
                        $("#confirm_password").val("");
                        $(".pass-group").find("span").removeClass("me-3");
                    }
                },
                error: function (error) {
                    $(".error-text").text("");
                    $(btnId).removeAttr("disabled").html(_l("save_changes"));
                    $(".form-control").removeClass("is-invalid is-valid");
                    if (error.responseJSON.code === 422) {
                        $.each(error.responseJSON.errors, function (key, val) {
                            $("#" + key).addClass("is-invalid");
                            $("#" + key + "_error").text(val[0]);
                        });
                    } else {
                        showToast('error', error.responseJSON.message);
                    }
                },
            });
        }
    });
    
})();