(async function () {
    "use strict";
    await loadTranslationFile();

    $("#paypalForm").validate({
        rules: {
            paypal_id: {
                required: true
            }
        },
        messages: {
            paypal_id: {
                required: _l("paypal_id_required")
            }
        },
        errorPlacement: function (error, element) {
            var errorId = element.attr("id") + "_error";
            if (element.hasClass("select2-hidden-accessible")) {
                $("#" + errorId).text(error.text());
            } else {
                $("#" + errorId).text(error.text());
            }
        },
        highlight: function (element) {
            if ($(element).hasClass("select2-hidden-accessible")) {
                $(element).next(".select2-container").addClass("is-invalid").removeClass("is-valid");
            }
            $(element).addClass("is-invalid").removeClass("is-valid");
            $("#" + element.id).siblings("span").addClass("me-3");
        },
        unhighlight: function (element) {
            if ($(element).hasClass("select2-hidden-accessible")) {
                $(element).next(".select2-container").removeClass("is-invalid").addClass("is-valid");
            }
            $(element).removeClass("is-invalid").addClass("is-valid");
            $("#" + element.id).siblings("span").addClass("me-3");
            var errorId = element.id + "_error";
            $("#" + errorId).text("");
        },
        onkeyup: function(element) {
            $(element).valid();
            $("#" + element.id).siblings("span").removeClass("me-3");
        },
        onchange: function(element) {
            $(element).valid();
            $("#" + element.id).siblings("span").removeClass("me-3");
        },
        submitHandler: function(form) {
            let formData = new FormData(form);
            let savebtn = $(".paypal_savebtn");

            saveAccountSettings(formData, savebtn);
        }
    });

    $("#stripeForm").validate({
        rules: {
            stripe_id: {
                required: true
            }
        },
        messages: {
            stripe_id: {
                required: _l("stripe_id_required")
            }
        },
        errorPlacement: function (error, element) {
            var errorId = element.attr("id") + "_error";
            if (element.hasClass("select2-hidden-accessible")) {
                $("#" + errorId).text(error.text());
            } else {
                $("#" + errorId).text(error.text());
            }
        },
        highlight: function (element) {
            if ($(element).hasClass("select2-hidden-accessible")) {
                $(element).next(".select2-container").addClass("is-invalid").removeClass("is-valid");
            }
            $(element).addClass("is-invalid").removeClass("is-valid");
            $("#" + element.id).siblings("span").addClass("me-3");
        },
        unhighlight: function (element) {
            if ($(element).hasClass("select2-hidden-accessible")) {
                $(element).next(".select2-container").removeClass("is-invalid").addClass("is-valid");
            }
            $(element).removeClass("is-invalid").addClass("is-valid");
            $("#" + element.id).siblings("span").addClass("me-3");
            var errorId = element.id + "_error";
            $("#" + errorId).text("");
        },
        onkeyup: function(element) {
            $(element).valid();
            $("#" + element.id).siblings("span").removeClass("me-3");
        },
        onchange: function(element) {
            $(element).valid();
            $("#" + element.id).siblings("span").removeClass("me-3");
        },
        submitHandler: function(form) {
            let formData = new FormData(form);
            let savebtn = $(".stripe_savebtn");

            saveAccountSettings(formData, savebtn);

        }
    });

    $("#bankForm").validate({
        rules: {
            account_holder_name: {
                required: true,
                maxlength: 50,
                pattern: /^[A-Za-z\s]+$/,
            },
            bank_name: {
                required: true,
                maxlength: 100,
            },
            ifsc_code: {
                required: true,
                maxlength: 100,
            },
            account_number: {
                required: true,
                maxlength: 100,
            },
        },
        messages:{
            account_holder_name: {
                required: _l("account_holder_name_required"),
                maxlength: _l("account_holder_name_maxlength"),
                pattern: _l("alpha_space_allowed"),
            },
            bank_name: {
                required: _l("bank_name_required"),
                maxlength: _l("bank_name_maxlength"),
            },
            ifsc_code: {
                required: _l("ifsc_required"),
                maxlength: _l("ifsc_code_maxlength"),
            },
            account_number: {
                required: _l("account_number_required"),
                maxlength: _l("account_number_maxlength"),
            },
        },
        errorPlacement: function (error, element) {
            var errorId = element.attr("id") + "_error";
            if (element.hasClass("select2-hidden-accessible")) {
                $("#" + errorId).text(error.text());
            } else {
                $("#" + errorId).text(error.text());
            }
        },
        highlight: function (element) {
            if ($(element).hasClass("select2-hidden-accessible")) {
                $(element).next(".select2-container").addClass("is-invalid").removeClass("is-valid");
            }
            $(element).addClass("is-invalid").removeClass("is-valid");
            $("#" + element.id).siblings("span").addClass("me-3");
        },
        unhighlight: function (element) {
            if ($(element).hasClass("select2-hidden-accessible")) {
                $(element).next(".select2-container").removeClass("is-invalid").addClass("is-valid");
            }
            $(element).removeClass("is-invalid").addClass("is-valid");
            $("#" + element.id).siblings("span").addClass("me-3");
            var errorId = element.id + "_error";
            $("#" + errorId).text("");
        },
        onkeyup: function(element) {
            $(element).valid();
            $("#" + element.id).siblings("span").removeClass("me-3");
        },
        onchange: function(element) {
            $(element).valid();
            $("#" + element.id).siblings("span").removeClass("me-3");
        },
        submitHandler: function(form) {
            let formData = new FormData(form);
            let savebtn = $(".bank_savebtn");

            saveAccountSettings(formData, savebtn);
        }
    });

    $("#ifsc_code").on("input", function () {
        $(this).val($(this).val().replace(/[^0-9A-Za-z]/g, ""));
    });

    $("#account_number").on("input", function () {
        $(this).val($(this).val().replace(/[^0-9]/g, "").slice(0, 100));
    });

    $("#account_holder_name").on("input", function () {
        $(this).val($(this).val().replace(/[^A-Za-z\s]/g, "").slice(0, 50));
    });

    $("#bank_name").on("input", function () {
        $(this).val($(this).val().replace(/[^A-Za-z\s]/g, "").slice(0, 100));
    });

    $(document).on("click", ".default_status", function () {
        let type = $(this).data("type");
        $(".default_status").prop("checked", false).prop("disabled", false);
        $(this).prop("checked", true).prop("disabled", true);

        $.ajax({
            type:"POST",
            url:"/customer/account-settings-default-status",
            data: {
                default_type: type
            },
            dataType: "json",
            headers: {
                "Accept": "application/json",
                "X-CSRF-TOKEN": $("meta[name='csrf-token']").attr("content")
            },
            success:function(resp){
                if (resp.code === 200) {
                    showToast("success", resp.message);
                }
            },
            error:function(error){
                showToast("error", error.responseJSON.message || "An error occurred while updating.");
            }
        });
    });

    function saveAccountSettings(formData, savebtn) {
        $.ajax({
            type:"POST",
            url:"/customer/save-account-settings",
            data: formData,
            enctype: "multipart/form-data",
            processData: false,
            contentType: false,
            headers: {
                "Accept": "application/json",
                "X-CSRF-TOKEN": $("meta[name='csrf-token']").attr("content")
            },
            beforeSend: function () {
                $(savebtn).attr("disabled", true).html(`
                    <span class="spinner-border spinner-border-sm align-middle me-1" role="status" aria-hidden="true"></span> ${_l("saving")}
                `);
            },
            complete: function () {
                $(savebtn).attr("disabled", false).html(_l("save_changes"));
            },
            success:function(resp){
                $(".error-text").text("");
                $(".form-control, .select2-container").removeClass("is-invalid is-valid");
                if (resp.code === 200) {
                    showToast("success", resp.message);
                }
            },
            error:function(error){
                $(".error-text").text("");
                $(".form-control, .select2-container").removeClass("is-invalid is-valid");
                if (error.responseJSON.code === 422) {
                    $.each(error.responseJSON.errors, function(key, val) {
                        $("#" + key).addClass("is-invalid");
                        $("#" + key + "_error").text(val[0]);
                    });
                } else {
                    showToast("error", error.responseJSON.message);
                }
            }
        });
    }
})();