window.__USE_SEPARATE_STAFF_JS__ = true;
if (window.__STAFF_JS_LOADED__ === true) {
    console.warn('staff.js already loaded');
}
window.__STAFF_JS_LOADED__ = true;

if (typeof toastr !== 'undefined') toastr.options = {
    debug: false,
    newestOnTop: false,
    progressBar: true,
    positionClass: "toast-top-right",
    preventDuplicates: true,
    onclick: null,
    showDuration: "30000",
    hideDuration: "10000",
    timeOut: "4000",
    extendedTimeOut: "10000",
    showEasing: "swing",
    hideEasing: "linear",
    showMethod: "fadeIn",
    hideMethod: "fadeOut",
};
    let cachedCountries = [];
    let cachedStates = [];
    let cachedCities = [];

    $(document).ready(function () {
        $(".selects").select2();
        const currentRoute = $('body').data('provider');
        loadLocationData();
        if (currentRoute !== "provider.edit_staffs") {
            getStaffList();
            getShopList();
        }
        getRoles();

        // Initialize new design functionality
        initializeNewDesign();

        $("#country").on("change", function () {
            const selectedCountry = $(this).val();
            clearDropdown($(".state"));
            clearDropdown($(".city"));
            if (selectedCountry) {
                getStates(selectedCountry);
            }
        });

        $("#state").on("change", function () {
            const selectedState = $(this).val();
            clearDropdown($(".city"));
            if (selectedState) {
                getCities(selectedState);
            }
        });

        $("#edit_country").on("change", function () {
            const selectedCountry = $(this).val();
            clearDropdown($(".state"));
            clearDropdown($(".city"));
            if (selectedCountry) {
                getStates(selectedCountry);
            }
        });

        $("#edit_state").on("change", function () {
            const selectedState = $(this).val();
            clearDropdown($(".city"));
            if (selectedState) {
                getCities(selectedState);
            }
        });
    });

    async function loadLocationData() {
        try {
            const [countriesResponse, statesResponse, citiesResponse] =
                await Promise.all([
                    $.getJSON("/countries.json"),
                    $.getJSON("/states.json"),
                    $.getJSON("/cities.json"),
                ]);

            cachedCountries = countriesResponse.countries;
            cachedStates = statesResponse.states;
            cachedCities = citiesResponse.cities;

            getCountries();
        } catch (error) {}
    }

    function clearDropdown(dropdown) {
        dropdown.empty().append(
            $("<option>", {
                value: "",
                text: "Select",
                disabled: true,
                selected: true,
            })
        );
    }

    function getCountries(selectedCountry = null) {
        const countrySelect = $(".country");
        clearDropdown(countrySelect);

        $.each(cachedCountries, function (index, country) {
            countrySelect.append(
                $("<option>", {
                    value: country.id,
                    text: country.name,
                    selected: country.id == selectedCountry,
                })
            );
        });
        countrySelect.select2();
        if (selectedCountry) {
            getStates(selectedCountry);
        }
    }

    function getStates(selectedCountry, selectedState = null) {
        const stateSelect = $(".state");
        clearDropdown(stateSelect);

        const states = cachedStates.filter(
            (state) => state.country_id == selectedCountry
        );
        if (states.length === 1) {
            stateSelect.append(
                $("<option>", {
                    value: states[0].id,
                    text: states[0].name,
                    selected: true,
                })
            );
            getCities(states[0].id);
        } else {
            $.each(states, function (index, state) {
                stateSelect.append(
                    $("<option>", {
                        value: state.id,
                        text: state.name,
                        selected: state.id == selectedState,
                    })
                );
            });

            if (selectedState) {
                getCities(selectedState);
            }
        }
    }

    function getCities(selectedState, selectedCity = null) {
        const citySelect = $(".city");
        clearDropdown(citySelect);

        const cities = cachedCities.filter(
            (city) => city.state_id == selectedState
        );
        if (cities.length === 1) {
            citySelect.append(
                $("<option>", {
                    value: cities[0].id,
                    text: cities[0].name,
                    selected: true,
                })
            );
        } else {
            $.each(cities, function (index, city) {
                citySelect.append(
                    $("<option>", {
                        value: city.id,
                        text: city.name,
                        selected: city.id == selectedCity,
                    })
                );
            });
        }
    }

    $("#add_staff_btn").on("click", function () {
        const countrySelect = $(".country");
        clearDropdown(countrySelect);
        const stateSelect = $(".state");
        clearDropdown(stateSelect);
        const citySelect = $(".city");
        clearDropdown(citySelect);
        getCountries();
        $("#gender").val("").trigger("change");
        $("#category").val("").trigger("change");
        $("#role_id").val("").trigger("change");
        $(".subcategory-list").find("option:not(:first)").remove();
        $("#imagePreview").attr("src", $("#imagePreview").data("image"));
        $(".form-control").removeClass("is-invalid is-valid");
        $(".select2-container").removeClass("is-invalid is-valid");
        $(".error-text").text("");
        $("#staffForm").trigger("reset");
        $("#id").val("");
        $("#branch_id").val([]).trigger("change");

        $.ajax({
            url: "/provider/staff/check-limit",
            type: "POST",
            headers: {
                Accept: "application/json",
                "X-CSRF-TOKEN": $('meta[name="csrf-token"]').attr("content"),
            },
            beforeSend: function () {
                $("#add_staff_btn")
                    .attr("disabled", true)
                    .html(
                        '<span class="spinner-border spinner-border-sm align-middle" role="status" aria-hidden="true"></span>'
                    );
            },
            success: function (response) {
                $("#add_staff_btn")
                    .removeAttr("disabled")
                    .html(
                        '<i class="ti ti-circle-plus me-2"></i>' +
                            $("#add_staff_btn").data("add_text")
                    );
                if (response.code === 200) {
                    if (response.no_package === true) {
                        $("#no_sub").modal("show");
                    } else if (response.sub_count_end === true) {
                        $("#sub_count_end").modal("show");
                    } else if (response.sub_end === true) {
                        $("#sub_end").modal("show");
                    } else {
                        $("#add_staff_modal").modal("show");
                    }
                }
            },
            error: function (error) {
                $("#add_staff_btn")
                    .removeAttr("disabled")
                    .html(
                        '<i class="ti ti-circle-plus me-2"></i>' +
                            $("#add_staff_btn").data("add_text")
                    );
                if (response.code === 500) {
                    toastr.error(error.responseJSON.message);
                } else {
                    toastr.error("An error occured!");
                }
            },
        });
    });

    $(document).ready(function () {
        $("#phone_number").on("input", function () {
            $(this).val(
                $(this)
                    .val()
                    .replace(/[^0-9]/g, "")
            );
            if ($(this).val().length > 12) {
                $(this).val($(this).val().slice(0, 12));
            }
        });

        $("#postal_code").on("input", function () {
            if ($(this).val().length > 6) {
                $(this).val($(this).val().slice(0, 6));
            }
        });

        var langCode = $("body").data("lang");

        let currentLang = langCode;

        const validationMessages = {
            en: {
                first_name: {
                    required: "First name is required.",
                    maxlength: "First name cannot exceed 100 characters.",
                    pattern: "Only alphabets are allowed.",
                },
                last_name: {
                    required: "Last name is required.",
                    maxlength: "Last name cannot exceed 100 characters.",
                    pattern: "Only alphabets are allowed.",
                },
                user_name: {
                    required: "Username is required.",
                    maxlength: "Username cannot exceed 100 characters.",
                    remote: "Username already exists.",
                },
                email: {
                    required: "Email is required.",
                    email: "Please enter a valid email address.",
                    remote: "Email already exists.",
                },
                phone_number: {
                    required: "Phone number is required.",
                    digits: "Only digits are allowed.",
                    minlength: "Phone number must be between 10 and 12 digits.",
                    maxlength: "Phone number must be between 10 and 12 digits.",
                },
                gender: {
                    required: "Gender is required.",
                },
                dob: {
                    required: "Date of birth is required.",
                    date: "Please enter a valid date.",
                },
                address: {
                    required: "Address is required.",
                    maxlength: "Address cannot exceed 100 characters.",
                },
                country: {
                    required: "Country is required.",
                },
                state: {
                    required: "State is required.",
                },
                city: {
                    required: "City is required.",
                },
                postal_code: {
                    required: "Postal code is required.",
                    maxlength: "Postal code must be at most 6 characters.",
                    pattern:
                        "Postal code can only contain letters and numbers.",
                },
                currency_code: {
                    required: "Currency code is required.",
                },
                profile_image: {
                    extension: "Please upload a valid image file.",
                    filesize: "Image size must be less than 2 MB.",
                },
                language: {
                    required: "Language is required.",
                },
                company_image: {
                    extension: "Please upload a valid image file.",
                    filesize: "Image size must be less than 2 MB.",
                },
                company_name: {
                    required: "Company name is required.",
                    maxlength: "Company name cannot exceed 100 characters.",
                },
                company_website: {
                    required: "Company website is required.",
                    url: "Please enter a valid URL.",
                },
                company_address: {
                    required: "Company address is required.",
                    maxlength: "Company address cannot exceed 255 characters.",
                },
                category: {
                    required: "Category is required.",
                },
                role_id: {
                    required: "Role is required.",
                },
            },
            ar: {
                first_name: {
                    required: "الاسم الأول مطلوب.",
                    maxlength: "يجب ألا يتجاوز الاسم الأول 100 حرفًا.",
                    pattern: "يسمح بالأحرف فقط.",
                },
                last_name: {
                    required: "الاسم الأخير مطلوب.",
                    maxlength: "يجب ألا يتجاوز الاسم الأخير 100 حرفًا.",
                    pattern: "يسمح بالأحرف فقط.",
                },
                user_name: {
                    required: "اسم المستخدم مطلوب.",
                    maxlength: "يجب ألا يتجاوز اسم المستخدم 100 حرفًا.",
                    remote: "اسم المستخدم موجود بالفعل.",
                },
                email: {
                    required: "البريد الإلكتروني مطلوب.",
                    email: "يرجى إدخال عنوان بريد إلكتروني صالح.",
                    remote: "البريد الإلكتروني موجود بالفعل.",
                },
                phone_number: {
                    required: "رقم الهاتف مطلوب.",
                    digits: "يسمح بالأرقام فقط.",
                    minlength: "يجب أن يكون رقم الهاتف بين 10 و 12 رقمًا.",
                    maxlength: "يجب أن يكون رقم الهاتف بين 10 و 12 رقمًا.",
                },
                gender: {
                    required: "الجنس مطلوب.",
                },
                dob: {
                    required: "تاريخ الميلاد مطلوب.",
                    date: "يرجى إدخال تاريخ صالح.",
                },
                address: {
                    required: "العنوان مطلوب.",
                    maxlength: "يجب ألا يتجاوز العنوان 100 حرفًا.",
                },
                country: {
                    required: "الدولة مطلوبة.",
                },
                state: {
                    required: "الولاية مطلوبة.",
                },
                city: {
                    required: "المدينة مطلوبة.",
                },
                postal_code: {
                    required: "الرمز البريدي مطلوب.",
                    maxlength: "يجب ألا يتجاوز الرمز البريدي 6 أحرف.",
                    pattern: "يمكن أن يحتوي الرمز البريدي على أحرف وأرقام فقط.",
                },
                currency_code: {
                    required: "رمز العملة مطلوب.",
                },
                profile_image: {
                    extension: "يرجى تحميل ملف صورة صالح.",
                    filesize: "يجب أن يكون حجم الصورة أقل من 2 ميغابايت.",
                },
                language: {
                    required: "اللغة مطلوبة.",
                },
                company_image: {
                    extension: "يرجى تحميل ملف صورة صالح.",
                    filesize: "يجب أن يكون حجم الصورة أقل من 2 ميغابايت.",
                },
                company_name: {
                    required: "اسم الشركة مطلوب.",
                    maxlength: "يجب ألا يتجاوز اسم الشركة 100 حرف.",
                },
                company_website: {
                    required: "موقع الشركة مطلوب.",
                    url: "يرجى إدخال رابط صالح.",
                },
                company_address: {
                    required: "عنوان الشركة مطلوب.",
                    maxlength: "يجب ألا يتجاوز عنوان الشركة 255 حرفًا.",
                },
                category: {
                    required: "الفئة مطلوبة.",
                },
                role_id: {
                    required: "الدور مطلوب.",
                },
            },
        };

        $("#staffForm").validate({
            rules: {
                first_name: {
                    required: true,
                    maxlength: 100,
                    pattern: /^[a-zA-Z]+$/,
                },
                last_name: {
                    required: true,
                    maxlength: 100,
                    pattern: /^[a-zA-Z]+$/,
                },
                user_name: {
                    required: true,
                    maxlength: 100,
                    remote: {
                        url: "/api/user/check-unique",
                        type: "post",
                        headers: {
                            Authorization:
                                "Bearer " + localStorage.getItem("admin_token"),
                            Accept: "application/json",
                        },
                        data: {
                            user_name: function () {
                                return $("#user_name").val();
                            },
                            id: function () {
                                return $("#id").val();
                            },
                        },
                    },
                },
                email: {
                    required: true,
                    email: true,
                    remote: {
                        url: "/api/user/check-unique",
                        type: "post",
                        headers: {
                            Authorization:
                                "Bearer " + localStorage.getItem("admin_token"),
                            Accept: "application/json",
                        },
                        data: {
                            email: function () {
                                return $("#email").val();
                            },
                            id: function () {
                                return $("#id").val();
                            },
                        },
                    },
                },
                phone_number: {
                    required: true,
                    minlength: 10,
                    maxlength: 12,
                },
                gender: {
                    required: true,
                },
                dob: {
                    required: false,
                },
                address: {
                    required: true,
                    maxlength: 150,
                },
                country: {
                    required: true,
                },
                state: {
                    required: true,
                },
                city: {
                    required: true,
                },
                postal_code: {
                    required: true,
                    maxlength: 6,
                    pattern: /^[a-zA-Z0-9]*$/,
                },
                profile_image: {
                    extension: "jpeg|jpg|png",
                    filesize: 2048,
                },
                category: {
                    required: true,
                },
                role_id: {
                    required: true,
                },
            },
            messages: validationMessages[currentLang],
            errorPlacement: function (error, element) {
                if (element.hasClass("select2-hidden-accessible")) {
                    var errorId = element.attr("id") + "_error";
                    $("#" + errorId).text(error.text());
                } else {
                    var errorId = element.attr("id") + "_error";
                    $("#" + errorId).text(error.text());
                }
            },
            highlight: function (element) {
                if ($(element).hasClass("select2-hidden-accessible")) {
                    $(element)
                        .next(".select2-container")
                        .addClass("is-invalid")
                        .removeClass("is-valid");
                }
                $(element).addClass("is-invalid").removeClass("is-valid");
            },
            unhighlight: function (element) {
                if ($(element).hasClass("select2-hidden-accessible")) {
                    $(element)
                        .next(".select2-container")
                        .removeClass("is-invalid")
                        .addClass("is-valid");
                }
                $(element).removeClass("is-invalid").addClass("is-valid");
                var errorId = element.id + "_error";
                $("#" + errorId).text("");
            },
            onkeyup: function (element) {
                $(element).valid();
            },
            onchange: function (element) {
                $(element).valid();
            },
            submitHandler: function (form) {
                var formData = new FormData(form);
                $.ajax({
                    url: "/api/save-profile-details",
                    type: "POST",
                    data: formData,
                    enctype: "multipart/form-data",
                    contentType: false,
                    processData: false,
                    cache: false,
                    beforeSend: function () {
                        $("#staff_save_btn")
                            .attr("disabled", true)
                            .html(
                                '<span class="spinner-border spinner-border-sm align-middle" role="status" aria-hidden="true"></span>'
                            );
                    },
                    success: function (response) {
                        if ($.fn.DataTable.isDataTable("#staffTable")) {
                            $("#staffTable").DataTable().destroy();
                        }
                        $(".error-text").text("");
                        $("#staff_save_btn")
                            .removeAttr("disabled")
                            .html(lg_save);
                        $(".form-control").removeClass("is-invalid is-valid");
                        $(".select2-container").removeClass(
                            "is-invalid is-valid"
                        );
                        if (response.code === 200) {
                            toastr.success(response.message);
                            $("#add_staff_modal").modal("hide");
                            getStaffList();
                        }
                    },
                    error: function (error) {
                        $(".error-text").text("");
                        $("#staff_save_btn")
                            .removeAttr("disabled")
                            .html(lg_save);
                        $(".form-control").removeClass("is-invalid is-valid");
                        $(".select2-container").removeClass(
                            "is-invalid is-valid"
                        );
                        if (error.responseJSON.code === 422) {
                            $.each(
                                error.responseJSON.errors,
                                function (key, val) {
                                    $("#" + key).addClass("is-invalid");
                                    $("#" + key + "_error").text(val[0]);
                                }
                            );
                        } else {
                            toastr.error(error.responseJSON.message);
                        }
                    },
                });
            },
        });

        $("#editStaffForm").validate({
            rules: {
                first_name: {
                    required: true,
                    maxlength: 100,
                    pattern: /^[a-zA-Z]+$/,
                },
                last_name: {
                    required: true,
                    maxlength: 100,
                    pattern: /^[a-zA-Z]+$/,
                },
                user_name: {
                    required: true,
                    maxlength: 100,
                },
                email: {
                    required: true,
                    email: true,
                },
                phone_number: {
                    required: true,
                    minlength: 10,
                    maxlength: 12,
                },
                gender: {
                    required: true,
                },
                dob: {
                    required: false,
                },
                address: {
                    required: false,
                    maxlength: 150,
                },
                country: {
                    required: false,
                },
                state: {
                    required: false,
                },
                city: {
                    required: false,
                },
                postal_code: {
                    required: false,
                    maxlength: 6,
                    pattern: /^[a-zA-Z0-9]*$/,
                },
                profile_image: {
                    extension: "jpeg|jpg|png",
                    filesize: 2048,
                },
                category: {
                    required: true,
                },
                role_id: {
                    required: true,
                },
            },
            messages: validationMessages[currentLang],
            errorPlacement: function (error, element) {
                if (element.hasClass("select2-hidden-accessible")) {
                    var errorId = element.attr("id") + "_error";
                    $("#" + errorId).text(error.text());
                } else {
                    var errorId = element.attr("id") + "_error";
                    $("#" + errorId).text(error.text());
                }
            },
            highlight: function (element) {
                if ($(element).hasClass("select2-hidden-accessible")) {
                    $(element)
                        .next(".select2-container")
                        .addClass("is-invalid")
                        .removeClass("is-valid");
                }
                $(element).addClass("is-invalid").removeClass("is-valid");
            },
            unhighlight: function (element) {
                if ($(element).hasClass("select2-hidden-accessible")) {
                    $(element)
                        .next(".select2-container")
                        .removeClass("is-invalid")
                        .addClass("is-valid");
                }
                $(element).removeClass("is-invalid").addClass("is-valid");
                var errorId = element.id + "_error";
                $("#" + errorId).text("");
            },
            onkeyup: function (element) {
                $(element).valid();
            },
            onchange: function (element) {
                $(element).valid();
            },
            submitHandler: function (form) {
                var formData = new FormData(form);
                $.ajax({
                    url: "/api/save-profile-details",
                    type: "POST",
                    data: formData,
                    enctype: "multipart/form-data",
                    contentType: false,
                    processData: false,
                    cache: false,
                    beforeSend: function () {
                        $("#staff_edit_btn")
                            .attr("disabled", true)
                            .html(
                                '<span class="spinner-border spinner-border-sm align-middle" role="status" aria-hidden="true"></span>'
                            );
                    },
                    success: function (response) {
                        if ($.fn.DataTable.isDataTable("#staffTable")) {
                            $("#staffTable").DataTable().destroy();
                        }
                        $(".error-text").text("");
                        $("#staff_edit_btn")
                            .removeAttr("disabled")
                            .html(lg_save);
                        $(".form-control").removeClass("is-invalid is-valid");
                        $(".select2-container").removeClass(
                            "is-invalid is-valid"
                        );
                        if (response.code === 200) {
                            toastr.success(response.message);
                            $("#edit_staff_modal").modal("hide");
                            getStaffList();
                        }
                    },
                    error: function (error) {
                        $(".error-text").text("");
                        $("#staff_edit_btn")
                            .removeAttr("disabled")
                            .html(lg_save);
                        $(".form-control").removeClass("is-invalid is-valid");
                        $(".select2-container").removeClass(
                            "is-invalid is-valid"
                        );
                        if (error.responseJSON.code === 422) {
                            $.each(
                                error.responseJSON.errors,
                                function (key, val) {
                                    $("#" + key).addClass("is-invalid");
                                    $("#" + key + "_error").text(val[0]);
                                }
                            );
                        } else {
                            toastr.error(error.responseJSON.message);
                        }
                    },
                });
            },
        });

        $.validator.addMethod(
            "date",
            function (value, element) {
                return (
                    this.optional(element) || /^\d{2}-\d{2}-\d{4}$/.test(value)
                );
            },
            "Please enter a valid date in DD-MM-YYYY format."
        );

        $.validator.addMethod(
            "filesize",
            function (value, element, param) {
                if (element.files.length === 0) return true;
                return element.files[0].size <= param * 1024;
            },
            "File size must be less than {0} KB."
        );
    });

    $("#gender").on("change", function () {
        $(this).valid();
    });
    $("#category").on("change", function () {
        $(this).valid();
    });
    $("#country").on("change", function () {
        $(this).valid();
    });
    $("#state").on("change", function () {
        $(this).valid();
    });
    $("#city").on("change", function () {
        $(this).valid();
    });

    $("#profile_image").on("change", function (event) {
        if ($(this).val() !== "") {
            $(this).valid();
        }
        let reader = new FileReader();
        reader.onload = function (e) {
            $("#imagePreview").attr("src", e.target.result).show();
        };
        reader.readAsDataURL(event.target.files[0]);
    });

    $("#edit_profile_image").on("change", function (event) {
        if ($(this).val() !== "") {
            $(this).valid();
        }
        let reader = new FileReader();
        reader.onload = function (e) {
            $("#editImagePreview").attr("src", e.target.result).show();
        };
        reader.readAsDataURL(event.target.files[0]);
    });

    $("#category").on("change", function () {
        var categoryId = $(this).val();
        if (categoryId) {
            listSubcategory(categoryId);
        }
    });

    $("#edit_category").on("change", function () {
        var categoryId = $(this).val();
        if (categoryId) {
            listSubcategory(categoryId);
        }
    });

    function getBranch() {
        $.ajax({
            url: "/provider/get-branch-list",
            type: "POST",
            data: {
                id: $("#parent_id").val(),
            },
            headers: {
                "X-CSRF-TOKEN": $('meta[name="csrf-token"]').attr("content"),
            },
            dataType: "json",
            success: function (response) {
                if (response && response.data && response.data.length > 0) {
                    const branchDropdown = $(".branch-lists");
                    response.data.forEach((branch) => {
                        branchDropdown.append(
                            `<option value="${branch.id}">${branch.branch_name}</option>`
                        );
                    });
                }
            },
            error: function (error) {
                toastr.error(error.responseJSON.message);
            },
        });
    }

    function getShopList() {
    const parentId = $("#parent_id").val();
    const shopDropdown = $(".shop-list");

    // Reset dropdown
    shopDropdown.empty().append('<option value="">Select Shop</option>');

    $.ajax({
        url: "/provider/get-shop-list",
        type: "POST",
        data: {
            parent_id: parentId
        },
        headers: {
            "X-CSRF-TOKEN": $('meta[name="csrf-token"]').attr("content")
        },
        dataType: "json",
        success: function(response) {
            if (response.success && response.data.length > 0) {
                const shopDropdown = $("#shop_id");
                    response.data.forEach((shop) => {
                        shopDropdown.append(
                            `<option value="${shop.id}">${shop.shop_name}</option>`
                        );
                    });
            } else {
                shopDropdown.append('<option value="">No shops found</option>');
            }
        },
        error: function(error) {
            toastr.error(error.responseJSON?.message || "Something went wrong!");
        }
    });
}



    // Removed getShops() function - using loadShopsFromBranches() instead

    function loadShopsFromBranches() {
        $.ajax({
            url: "/provider/get-branch-list",
            type: "POST",
            data: {
                id: $("#parent_id").val(),
            },
            headers: {
                "X-CSRF-TOKEN": $('meta[name="csrf-token"]').attr("content"),
            },
            dataType: "json",
            success: function (response) {
                console.log(response);
                if (response && response.data && response.data.length > 0) {
                    const shopDropdown = $("#shop_id");
                    response.data.forEach((branch) => {
                        shopDropdown.append(
                            `<option value="${branch.id}">${branch.branch_name}</option>`
                        );
                    });
                }
            },
            error: function (error) {
                console.error("Error loading branches as shops:", error);
            },
        });
    }

    function getRoles() {
        $.ajax({
            url: "/role/list",
            type: "POST",
            data: {
                user_id: $("#parent_id").val(),
                status: 1,
            },
            headers: {
                "X-CSRF-TOKEN": $('meta[name="csrf-token"]').attr("content"),
            },
            dataType: "json",
            success: function (response) {
                if (response && response.data && response.data.length > 0) {
                    response.data.forEach((role) => {
                        $(".role-list").append(
                            `<option value="${role.id}">${role.role_name}</option>`
                        );
                        // Also populate new design role dropdown
                        $("#role_id").append(
                            `<option value="${role.id}">${role.role_name}</option>`
                        );
                    });
                }
            },
            error: function (error) {
                toastr.error(error.responseJSON.message);
            },
        });
    }

    function listSubcategory(categoryId, selectedSubcategory = "") {
        $.ajax({
            url: "/api/get-subcategories",
            type: "POST",
            dataType: "json",
            data: {
                category_id: categoryId,
                language_id: languageId,
            },
            headers: {
                Accept: "application/json",
                "X-CSRF-TOKEN": $('meta[name="csrf-token"]').attr("content"),
            },
            success: function (response) {
                $(".subcategory-list").find("option:not(:first)").remove();
                if (response.length != 0) {
                    response.forEach((item) => {
                        $(".subcategory-list").append(
                            `<option value="${item.id}" }>${item.name}</option>`
                        );
                    });
                }
            },
            error: function (error) {
                $(".subcategory-list").find("option:not(:first)").remove();
                if (error.responseJSON && error.responseJSON.code === 500) {
                    toastr.error(error.responseJSON.message);
                }
            },
        });
    }

    function getStaffList() {
        var id = $("#parent_id").val();
        $.ajax({
            url: "/api/provider/get-staff-list",
            type: "POST",
            dataType: "json",
            data: {
                order_by: "desc",
                sort_by: "id",
                id: id,
            },
            headers: {
                Authorization: "Bearer " + localStorage.getItem("admin_token"),
                Accept: "application/json",
            },
            success: function (response) {
                if (response.code === 200) {
                    let staffs = response.data;
                    const $cardsRow = $("#staffCardsRow");
                    if ($cardsRow.length) {
                        let cardsHtml = "";
                        if (staffs.length === 0) {
                            cardsHtml = `<div class="col-12"><p class="text-center">${$("#staffTable").data("empty") || "No staff members found."}</p></div>`;
                        } else {
                            staffs.forEach((staff) => {
                                const statusBadge = staff.status == "1" ? "badge-soft-success" : "badge-soft-danger";
                                const editUrl = `/provider/staff/${staff.id}/edit`;
                                cardsHtml += `
                                <div class="col-md-6 col-lg-6">
                                  <div class="card mb-0">
                                    <div class="card-body">
                                      <div class="d-flex align-items-center justify-content-between flex-wrap gap-3">
                                        <div class="d-flex align-items-center">
                                          <a href="${editUrl}"><img src="${staff.profile_image}" alt="staff" class="avatar avatar-lg rounded-md me-2"></a>
                                          <div>
                                            <span class="badge badge-sm ${statusBadge} d-inline-flex align-items-center fs-10 mb-1">${staff.status == "1" ? "Active" : "Inactive"}</span>
                                            <a href="${editUrl}" class="fw-semibold d-block">
                                                ${staff.first_name.charAt(0).toUpperCase() + staff.first_name.slice(1)}
                                                ${staff.last_name.charAt(0).toUpperCase() + staff.last_name.slice(1)}
                                            </a>
                                            <span class="fs-12">${staff.email}</span>
                                          </div>
                                        </div>
                                        <div class="d-flex align-items-center">
                                          <a href="${editUrl}" class="btn btn-sm btn-light rounded-circle p-2 d-inline-flex align-items-center justify-content-center me-2 edit_staff_btn"><i class="isax isax-edit fs-16"></i></a>
                                          <a href="javascript:void(0);" class="btn btn-sm btn-light rounded-circle p-2 d-inline-flex align-items-center justify-content-center delete_staff_btn" data-id="${staff.id}" data-bs-toggle="modal" data-bs-target="#del-staff"><i class="isax isax-trash fs-16"></i></a>
                                        </div>
                                      </div>
                                    </div>
                                  </div>
                                </div>`;
                            });
                        }
                        $cardsRow.html(cardsHtml);
                        $("#loader-table").hide();
                    } else {
                        let tableBody = "";
                        if (staffs.length === 0) {
                            if ($.fn.DataTable && $.fn.DataTable.isDataTable && $.fn.DataTable.isDataTable("#staffTable")) {
                                $("#staffTable").DataTable().destroy();
                            }
                            tableBody += `<tr><td colspan="7" class="text-center">${$("#staffTable").data("empty")}</td></tr>`;
                        } else {
                            staffs.forEach((staff, index) => {
                                tableBody += `
                                <tr>
                                  <td>${index + 1}</td>
                                  <td>
                                    <div class="d-flex align-items-center">
                                      <a href="#" class="avatar avatar-lg me-2">
                                        <img src="${staff.profile_image}" class="rounded-circle" alt="user">
                                      </a>
                                      <div>
                                        <h6 class="fs-14 fw-medium"><a href="#">${staff.first_name} ${staff.last_name}</a></h6>
                                        <span class="fs-12">${staff.email}</span>
                                      </div>
                                    </div>
                                  </td>
                                  <td>${staff.created_at}</td>
                                  <td>
                                    <div class="d-flex align-items-center">
                                      <span class="badge ${staff.status == "1" ? "badge-soft-success" : "badge-soft-danger"} d-flex align-items-center"><i class="ti ti-point-filled"></i>${staff.status == "1" ? "Active" : "Inactive"}</span>
                                    </div>
                                  </td>
                                  <td>
                                    <div class="user-icon d-inline-flex">
                                      ${$("#has_permission").data("delete") == 1 ? `<a href="javascript:void(0);" class="delete_staff_btn" data-id="${staff.id}" data-bs-toggle="modal" data-bs-target="#del-staff"><i class="ti ti-trash"></i></a>` : ""}
                                    </div>
                                  </td>
                                </tr>`;
                            });
                            $("#tabelSkeletonLoader").hide();
                            $("#loader-table").hide();
                            $(".label-loader, .input-loader").hide();
                            $(".real-label, .real-input").removeClass("d-none");
                        }
                        $("#staffTable tbody").html(tableBody);
                        if (staffs.length != 0 && $.fn.DataTable && !$.fn.DataTable.isDataTable("#staffTable")) {
                            $("#staffTable").DataTable({ ordering: true, language: datatableLang });
                        }
                    }
                }
                $("#tabelSkeletonLoader").hide();
                $("#loader-table").hide();
                $(".label-loader, .input-loader").hide();
                $(".real-label, .real-input").removeClass("d-none");
            },
            error: function (error) {
                var showError = function (msg) {
                    if (typeof toastr !== 'undefined') { toastr.error(msg); } else { console.error(msg); }
                };
                if (error.status === 422) {
                    var errors = error.responseJSON && error.responseJSON.errors;
                    if (errors) {
                        $.each(errors, function (key, messages) {
                            showError(messages[0]);
                        });
                    } else {
                        showError("An error occurred while fetching.");
                    }
                } else {
                    showError("An error occurred while fetching.");
                }
            },
        });
    }

    let initialPhoneNumber = null;

    $(document).on("click", ".edit_staff_dbtn", function () {
        console.log('tested');
        $(".form-control").removeClass("is-invalid is-valid");
        $(".select2-container").removeClass("is-invalid is-valid");
        $(".error-text").text("");
        $("#staffForm").trigger("reset");

        const id = $(this).data("id");
        const user_name = $(this).data("user_name");
        const first_name = $(this).data("first_name");
        const last_name = $(this).data("last_name");
        const email = $(this).data("email");
        const phone_number = $(this).data("phone_number");
        const profile_image = $(this).data("profile_image");
        const gender = $(this).data("gender");
        const dob = $(this).data("dob");
        const bio = $(this).data("bio");
        const address = $(this).data("address");
        const country_id = $(this).data("country_id");
        const state_id = $(this).data("state_id");
        const city_id = $(this).data("city_id");
        const postal_code = $(this).data("postal_code");
        const category_id = $(this).data("category_id");
        const subcategory_id = $(this).data("subcategory_id");
        const branch_id = $(this).data("branch_id");
        if (typeof branch_id === "string" && branch_id.includes(",")) {
            branchIdArray = branch_id.split(",");
            $("#edit_branch_id").val(branchIdArray).trigger("change");
        } else {
            branchIdArray = branch_id;
            $("#edit_branch_id").val(branchIdArray).trigger("change");
        }
        const role = $(this).data("role");
        const status = $(this).data("status");

        const countrySelect = $(".country");
        clearDropdown(countrySelect);
        const stateSelect = $(".state");
        clearDropdown(stateSelect);
        const citySelect = $(".city");
        clearDropdown(citySelect);

        async function loadData() {
            await loadLocationData();
            getCountries(country_id);
            getStates(country_id, state_id);
            getCities(state_id, city_id);
        }
        loadData();

        $("#id").val(id);
        $("#edit_user_name").val(user_name);
        $("#edit_first_name").val(first_name);
        $("#edit_last_name").val(last_name);
        $("#edit_email").val(email);
        if (profile_image) {
            $("#editImagePreview").attr("src", profile_image);
        } else {
            $("#editImagePreview").attr(
                "src",
                $("#editImagePreview").data("image")
            );
        }
        $("#edit_gender").val(gender).trigger("change");
        $("#edit_address").val(address);
        $("#edit_dob").val(dob);
        $("#edit_bio").text(bio);
        $("#edit_postal_code").val(postal_code);
        $("#edit_category").val(category_id).trigger("change");
        $("#edit_subcategory_id").val(subcategory_id).trigger("change");
        $("#edit_status").val(status).trigger("change");
        $("#edit_role").val(role).trigger("change");

        const phoneNumber = phone_number.trim();
        const phoneInput = document.querySelector(".edit_staff_phone_number");
        const hiddenInput = document.querySelector("#edit_staff_phone_number");

        if ($(phoneInput).data("itiInstance")) {
            $(phoneInput).data("itiInstance").destroy();
        }
        const iti = intlTelInput(phoneInput, {
            utilsScript:
                window.location.origin +
                "/assets/plugins/intltelinput/js/utils.js",
            separateDialCode: true,
        });
        $(phoneInput).data("itiInstance", iti);

        if (phoneNumber) {
            iti.setNumber(phoneNumber);
            hiddenInput.value = iti.getNumber();
            initialPhoneNumber = phoneNumber;
        }

        phoneInput.addEventListener("countrychange", function () {
            const currentPhoneNumber = iti.getNumber();
            if (currentPhoneNumber !== initialPhoneNumber) {
                hiddenInput.value = currentPhoneNumber;
            }
        });

        if (!hiddenInput.value) {
            hiddenInput.value = initialPhoneNumber;
        }
    });

    // New Design Functions
    function initializeNewDesign() {
        // Check if we're on the add staff page
        if (document.body.getAttribute('data-provider') === 'provider.staff.add') {
            initializeAddStaffForm();
        }
    }

    function initializeAddStaffForm() {
        // Image preview functionality
        $('#upload-profile1').on('change', function(e) {
            const file = e.target.files[0];
            if (file) {
                const reader = new FileReader();
                reader.onload = function(e) {
                    $('#profilePreview').attr('src', e.target.result);
                };
                reader.readAsDataURL(file);
            }
        });

        $('.next-btn').on('click', function(e) {
            e.preventDefault(); // stop default button action

            if (validateInformationForm()) {
                switchToAvailabilityTab();
            } else {
                return false; // prevent moving to next tab
            }
        });

        $('.prev-btn').on('click', function() {
            switchToInformationTab();
        });

        // Form submission
        $('#providerAddStaffForm').on('submit', function(e) {
            e.preventDefault();
            if (validateAvailabilityForm()) {
                submitStaffForm();
            }
        });

         $('#providerEditStaffForm').on('submit', function(e) {
            console.log('submit');
            e.preventDefault();
            if (validateAvailabilityForm()) {
                submitStaffForm();
            }
        });

        // Initialize phone input (wait for IntlTelInput to be available)
        if ($('.staff_phone_number').length) {
            // Wait for IntlTelInput to be available
            const initPhoneInput = () => {
                if (typeof $.fn.intlTelInput !== 'undefined') {
                    $('.staff_phone_number').intlTelInput({
                        initialCountry: "us",
                        separateDialCode: true,
                        utilsScript: "https://cdnjs.cloudflare.com/ajax/libs/intl-tel-input/17.0.8/js/utils.js"
                    });

                    $('.staff_phone_number').on('blur', function() {
                        const phoneNumber = $('.staff_phone_number').intlTelInput('getNumber');
                        $('#intl_phone_number').val(phoneNumber);
                    });
                } else {
                    // Retry after a short delay
                    setTimeout(initPhoneInput, 100);
                }
            };

            // Start initialization
            initPhoneInput();

            // Fallback: simple phone input without IntlTelInput
            $('.staff_phone_number').on('blur', function() {
                const phoneNumber = $(this).val();
                $('#intl_phone_number').val(phoneNumber);
            });
        }
    }

    function validateInformationForm() {
        let isValid = true;
        const requiredFields = [
            'user_name', 'first_name', 'last_name', 'email',
            'phone_number', 'dob', 'role_id', 'shop_id',
            'address', 'country', 'state', 'city', 'postal_code'
        ];

        // Clear previous errors
        $('.is-invalid').removeClass('is-invalid');
        $('.error-message').remove();

        requiredFields.forEach(function (fieldId) {
            const field = $('#' + fieldId);

            if (!field.val() || field.val().trim() === '') {
                field.addClass('is-invalid');

                // Remove any old error
                field.closest('.form-group, .mb-3, .col').find('.error-message').remove();

                if (field.is('select')) {
                    // For select2
                    if (field.next('.select2').length) {
                        field.next('.select2').after('<div class="error-message text-danger small mt-1">This field is required</div>');
                    }
                    // For bootstrap-select
                    else if (field.next('.bootstrap-select').length) {
                        field.next('.bootstrap-select').after('<div class="error-message text-danger small mt-1">This field is required</div>');
                    }
                    // For choices.js
                    else if (field.next('.choices').length) {
                        field.next('.choices').after('<div class="error-message text-danger small mt-1">This field is required</div>');
                    }
                    // Fallback (normal select without plugin)
                    else {
                        field.after('<div class="error-message text-danger small mt-1">This field is required</div>');
                    }
                } else {
                    // Normal input
                    field.after('<div class="error-message text-danger small mt-1">This field is required</div>');
                }

                isValid = false;
            }
        });


        // Email validation
        const email = $('#email').val();
        if (email && !isValidEmail(email)) {
            const emailField = $('#email');
            emailField.addClass('is-invalid');

            const parent = emailField.closest('.form-group, .mb-3, .col');
            if (parent.length > 0) {
                parent.append('<div class="error-message text-danger small mt-1">Please enter a valid email</div>');
            } else {
                emailField.after('<div class="error-message text-danger small mt-1">Please enter a valid email</div>');
            }

            isValid = false;
        }

        // Final check: if ANY required field is empty or invalid, block moving forward
        if (!isValid) {
            if (typeof toastr !== 'undefined') {
                toastr.error('Please fill all required fields before proceeding');
            }
        }

        return isValid;
    }


    function validateAvailabilityForm() {
        let hasValidDay = false;
        const days = ['monday', 'tuesday', 'wednesday', 'thursday', 'friday', 'saturday', 'sunday'];

        days.forEach(function(day) {
            const checkbox = $(`input[data-day="${day}"]`);
            if (checkbox.is(':checked')) {
                const startTime = $(`#${day}_start`).val();
                const endTime = $(`#${day}_end`).val();
                if (startTime && endTime) {
                    hasValidDay = true;
                }
            }
        });

        if (!hasValidDay) {
            return false;
        }

        return true;
    }

    function switchToAvailabilityTab() {
        $('#info-tab').removeClass('active');
        $('#avail-tab').addClass('active');
        $('#info-content').removeClass('active');
        $('#avail-content').addClass('active');
    }

    function switchToInformationTab() {
        $('#avail-tab').removeClass('active');
        $('#info-tab').addClass('active');
        $('#avail-content').removeClass('active');
        $('#info-content').addClass('active');
    }

    function submitStaffForm() {
       const form = $('#providerAddStaffForm, #providerEditStaffForm')[0];
        const formData = new FormData(form);

        // Add working days data
        const workingDays = getWorkingDaysData();
        formData.append('working_days', JSON.stringify(workingDays));

        // Add parent_id for staff creation
        formData.append('parent_id', $('#parent_id').val() || '');
        formData.append('user_type', '4'); // Staff type
        formData.append('status', '1'); // Active status

        $.ajax({
            url: '/api/save-profile-details',
            type: 'POST',
            data: formData,
            enctype: 'multipart/form-data',
            contentType: false,
            processData: false,
            cache: false,
            headers: {
                'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content'),
                'Accept': 'application/json'
            },
            beforeSend: function() {
                $('button[type="submit"]').prop('disabled', true).text('Saving...');
            },
            success: function(response) {
                if (response && response.code === 200) {
                    if (typeof toastr !== 'undefined') {
                        toastr.success(response.message || 'Staff saved successfully');
                    }
                    setTimeout(function() {
                        window.location.href = '/provider/staff-list';
                    }, 1500);
                } else {
                    if (typeof toastr !== 'undefined') {
                        toastr.error(response.message || 'Error saving staff');
                    }
                }
            },
            error: function(error) {
                if (error.responseJSON && error.responseJSON.code === 422) {
                    const errors = error.responseJSON.errors || {};
                    Object.keys(errors).forEach(function(key) {
                        const field = $('#' + key);
                        if (field.length) {
                            field.addClass('is-invalid');
                            field.after('<div class="error-message text-danger small mt-1">' + errors[key][0] + '</div>');
                        }
                    });
                } else {
                    if (typeof toastr !== 'undefined') {
                        toastr.error((error.responseJSON && error.responseJSON.message) || 'An error occurred');
                    }
                }
            },
            complete: function() {
                $('button[type="submit"]').prop('disabled', false).text('Add Staff');
            }
        });
    }

    function getWorkingDaysData() {
        const workingDays = {};
        const days = ['monday', 'tuesday', 'wednesday', 'thursday', 'friday', 'saturday', 'sunday'];

        days.forEach(function(day) {
            const checkbox = $(`input[data-day="${day}"]`);
            if (checkbox.is(':checked')) {
                const startTime = $(`#${day}_start`).val();
                const endTime = $(`#${day}_end`).val();
                if (startTime && endTime) {
                    workingDays[day] = {
                        start: startTime,
                        end: endTime
                    };
                }
            }
        });

        return workingDays;
    }

    function isValidEmail(email) {
        const emailRegex = /^[^\s@]+@[^\s@]+\.[^\s@]+$/;
        return emailRegex.test(email);
    }

    $(document).on("click", ".delete_staff_btn", function () {
        var id = $(this).data("id");
        $("#confirm_staff_delete").data("id", id);
    });

    $(document).on("click", "#confirm_staff_delete", function (event) {
        event.preventDefault();

        var id = $(this).data("id");

        $.ajax({
            url: "/api/provider/delete-staff",
            type: "POST",
            data: {
                id: id,
            },
            dataType: "json",
            success: function (response) {
                if (response.code === 200) {
                    toastr.success(response.message);
                    $("#del-staff").modal("hide");
                    getStaffList();
                }
            },
            error: function (error) {
                toastr.error(error.responseJSON.message);
            },
        });
    });

