document.addEventListener('DOMContentLoaded', function () {
    function handleFormSubmit(form) {
        const formData = new FormData(form);
        const action = form.getAttribute('action');
        
        fetch(action, {
            method: 'POST',
            headers: {
                'X-CSRF-TOKEN': document.querySelector('meta[name="csrf-token"]').getAttribute('content'),
                'X-Requested-With': 'XMLHttpRequest',
                // FIX: Explicitly tell the server we want a JSON response
                'Accept': 'application/json',
            },
            body: formData
        })
        .then(response => {
            // FIX: Add a check to ensure the response is actually JSON before parsing
            if (!response.ok && response.headers.get('content-type')?.indexOf('application/json') === -1) {
                 // If it's not JSON and there's an error, throw a generic error
                 throw new Error('An unexpected server error occurred.');
            }
            return response.json();
        })
        .then(data => {
            if (data.success) {
                toastr.success(data.message);
                setTimeout(() => window.location.reload(), 1500);
            } else {
                toastr.error(data.message || 'An unknown error occurred.');
            }
        })
        .catch(error => {
            toastr.error('An error occurred while submitting the form.');
            console.error('Error:', error);
        });
    }

    // Attach event listeners to all modal forms
    document.querySelectorAll('.status-form, .delete-form').forEach(form => {
        form.addEventListener('submit', function (event) {
            event.preventDefault();
            handleFormSubmit(this);
        });
    });
});

   