$(document).ready(function () {

    const apiHeaders = {
        Authorization: "Bearer " + localStorage.getItem("provider_token"),
        Accept: "application/json",
        "X-CSRF-TOKEN": $('meta[name="csrf-token"]').attr("content"),
    };

    var currentUserId = $('body').data('authid');

    // --- FETCH DASHBOARD SUMMARY DATA ---
    $.ajax({
        url: "/api/provider/dashboard/summary",
        type: "GET",
        data: {
            user_id: currentUserId // send it to the API
        },
        success: function (response) {
            if (response?.data?.completed_bookings) {
                const summary = response.data;
                const currency = summary.currency || '$';
                // Completed Bookings
                const bookingsCount = summary.completed_bookings.count || 0;
                const bookingsPercentage = Math.round(summary.completed_bookings.percentage || 0);
                $('#completed-bookings-count').text(bookingsCount);
                const bookingsBadge = $('#completed-bookings-percentage');
                bookingsBadge.text(Math.abs(bookingsPercentage) + '%');
                if (bookingsPercentage < 0) { bookingsBadge.removeClass('badge-soft-success').addClass('badge-soft-danger').find('i').removeClass('isax-trend-up').addClass('isax-trend-down'); }
                // Total Sales
                const salesCount = summary.total_sales.count || 0;
                const salesPercentage = Math.round(summary.total_sales.percentage || 0);
                $('#total-sales-count').text(salesCount);
                const salesBadge = $('#total-sales-percentage');
                salesBadge.text(Math.abs(salesPercentage) + '%');
                if (salesPercentage < 0) { salesBadge.removeClass('badge-soft-success').addClass('badge-soft-danger').find('i').removeClass('isax-trend-up').addClass('isax-trend-down'); }
                // Total Earnings
                const earningsAmount = parseFloat(summary.total_earnings.amount || 0).toFixed(2);
                const earningsPercentage = Math.round(summary.total_earnings.percentage || 0);
                $('#total-earnings-amount').text(currency + earningsAmount);
                const earningsBadge = $('#total-earnings-percentage');
                earningsBadge.text(Math.abs(earningsPercentage) + '%');
                if (earningsPercentage < 0) { earningsBadge.removeClass('badge-soft-success').addClass('badge-soft-danger').find('i').removeClass('isax-trend-up').addClass('isax-trend-down'); }
            } else {
                console.error("Could not fetch dashboard summary:", response);
                $('#completed-bookings-count, #total-sales-count').text('0');
                $('#total-earnings-amount').text('$0.00');
            }
             $('.summary-loader').remove();
             $('.dashboard-item .d-flex').css('visibility', 'visible');
        },
        error: function (xhr, status, error) {
            console.error("Error fetching dashboard summary:", error);
            $('.summary-loader').remove();
            $('.dashboard-item .d-flex').css('visibility', 'visible');
        },
    });

    // --- FETCH RECENTLY SOLD PRODUCTS ---
    $.ajax({
        url: "/api/provider/dashboard/recently-sold",
        type: "GET",
        data: {
            user_id: currentUserId // send it to the API
        },
        success: function (response) {
            const container = $('#recently-selled-products');
            if (response?.data?.length > 0) {
                let html = response.data.map(p => `
                    <div class="d-flex align-items-center justify-content-between gap-2 mb-3">
                        <div class="d-flex align-items-center overflow-hidden">
                            <a href="#" class="avatar avatar-lg flex-shrink-0 me-2"><img src="${p.image_url}" alt="product" class="img-fluid"></a>
                            <div class="flex-grow-1 overflow-hidden">
                                <h6 class="fs-14 fw-semibold text-truncate mb-1"><a href="#">${p.source_name}</a></h6>
                                <p class="fs-13 text-truncate mb-0">${p.category_name || 'Uncategorized'}</p>
                            </div>
                        </div>
                        <div>
                            <h6 class="fs-16 fw-semibold mb-0">${p.formatted_price}</h6>
                            <p class="fs-13 mb-0">Price</p>
                        </div>
                    </div>`).join('');
                container.html(html);
            } else {
                container.html('<p class="text-center text-muted py-5">No recently sold products found.</p>');
            }
        },
        error: (xhr, status, error) => $('#recently-selled-products').html('<p class="text-center text-danger py-3">Could not load products.</p>'),
    });

    // --- FETCH RECENTLY BOOKED SERVICES ---
    $.ajax({
        url: "/api/provider/dashboard/recently-booked-services",
        type: "GET",
        data: {
            user_id: currentUserId // send it to the API
        },
        success: function (response) {
            const container = $('#recently-booked-services');
            if (response?.data?.length > 0) {
                let html = response.data.map(s => `
                    <div class="d-flex align-items-center justify-content-between gap-2 mb-3">
                        <div class="d-flex align-items-center overflow-hidden">
                            <a href="#" class="avatar avatar-lg flex-shrink-0 me-2"><img src="${s.image_url}" alt="service" class="img-fluid"></a>
                            <div class="flex-grow-1 overflow-hidden">
                                <h6 class="fs-14 fw-semibold text-truncate mb-1"><a href="#">${s.service_name}</a></h6>
                                <div class="d-flex align-items-center gap-2 flex-wrap item-info mb-1">
                                    <p class="fs-13 mb-0"><a href="#" class="link-body">${s.booking_code}</a></p>
                                    <p class="fs-13 mb-0">${s.customer_name}</p>
                                </div>
                            </div>
                        </div>
                        <div class="text-sm-end">
                            <h6 class="fs-14 fw-semibold mb-1">${s.formatted_date}</h6>
                            <p class="fs-13 mb-0">Date</p>
                        </div>
                    </div>`).join('');
                container.html(html);
            } else {
                container.html('<p class="text-center text-muted py-5">No recent service bookings found.</p>');
            }
        },
        error: (xhr, status, error) => $('#recently-booked-services').html('<p class="text-center text-danger py-3">Could not load services.</p>'),
    });

    // --- FETCH HIGHLY BOOKED CATEGORIES ---
    $.ajax({
        url: "/api/provider/dashboard/highly-booked-categories",
        type: "GET",
        data: {
            user_id: currentUserId // send it to the API
        },
        success: function (response) {
            const container = $('#highly-booked-categories');
            if (response?.data?.length > 0) {
                let html = response.data.map(c => `
                    <div class="mb-3">
                        <div class="d-flex align-items-center justify-content-between flex-wrap gap-2 mb-1">
                            <h6 class="fs-14 fw-semibold mb-0">${c.name}</h6>
                            <p class="fs-14 mb-0">${c.booking_count} Bookings</p>
                        </div>
                        <div class="progress progress-sm"><div class="progress-bar" role="progressbar" style="width: ${c.percentage}%"></div></div>
                    </div>`).join('');
                container.html(html);
            } else {
                container.html('<p class="text-center text-muted py-5">No category data available.</p>');
            }
        },
        error: (xhr, status, error) => $('#highly-booked-categories').html('<p class="text-center text-danger py-3">Could not load categories.</p>'),
    });

    // --- FETCH BOOKING CHART DATA ---
    $.ajax({
        url: "/api/provider/dashboard/booking-chart-data",
        type: "GET",
         data: {
            user_id: currentUserId // send it to the API
        },
        success: function (response) {
             if (response?.data?.labels) {
                var options = {
                    series: [{ name: 'Bookings', data: response.data.data }],
                    chart: { height: 350, type: 'area', toolbar: { show: false }},
                    dataLabels: { enabled: false }, stroke: { curve: 'smooth' },
                    xaxis: { categories: response.data.labels }, tooltip: { x: { format: 'MMM' }},
                };
                var chart = new ApexCharts(document.querySelector("#booking-chart"), options);
                chart.render();
            } else {
                $('#booking-chart').html('<p class="text-center text-muted py-3">No chart data available.</p>');
            }
        },
        error: (xhr, status, error) => $('#booking-chart').html('<p class="text-center text-danger py-3">Could not load chart.</p>'),
    });

    // --- FETCH RECENT TRANSACTIONS ---
    $.ajax({
        url: "/api/provider/dashboard/recent-transactions",
        type: "GET",
        data: {
            user_id: currentUserId // send it to the API
        },
        success: function (response) {
            const tbody = $('#transactions-table-body');
            const defaultprofileImage =
                            "/assets/img/profile-default.png";
            if (response?.data?.length > 0) {
                let html = response.data.map(trx => `
                    <tr>
                        <td><a href="#">${trx.invoice_id}</a></td>
                        <td>
                            <div class="d-flex align-items-center">
                                <div><p class="fs-14 mb-0"><a href="#">${trx.customer_name}</a></p></div>
                            </div>
                        </td>
                        <td>${trx.description || 'N/A'}</td>
                        <td>${trx.formatted_amount}</td>
                        <td>${trx.payment_method}</td>
                        <td>${trx.formatted_date}</td>
                    </tr>`).join('');
                tbody.html(html);
            } else {
                tbody.html('<tr><td colspan="6" class="text-center text-muted py-3">No recent transactions found.</td></tr>');
            }
        },
        error: (xhr, status, error) => $('#transactions-table-body').html('<tr><td colspan="6" class="text-center text-danger py-3">Could not load transactions.</td></tr>'),
    });
});

