(async () => {
    "use strict";
    await loadTranslationFile();
    $(document).ready(function() {
        let currentStatus = 'active'; // Default tab
        let currentShopId = ''; // Default filter
        const authId = $("#auth_id").val();
        const storageBaseUrl = "{{ asset('storage') }}";

        $(document).on("click", "#providerAddService", function (e) {
            e.preventDefault();
            const authId = $("#auth_id").val();
            $.ajax({
                url: "/provider/subscription/detail",
                type: "POST",
                data: {
                    id: authId,
                    type: "product",
                },
                headers: {
                    Authorization: "Bearer " + localStorage.getItem("admin_token"),
                    Accept: "application/json",
                    "X-CSRF-TOKEN": $('meta[name="csrf-token"]').attr("content"),
                },
                beforeSend: function () {
                    $(".add_service").attr("disabled", true);
                    $(".add_service").html(
                        '<div class="spinner-border text-light" role="status"></div>'
                    );
                },
            })
                .done((response, statusText, xhr) => {
                    $(".error-text").text("");
                    $(".form-control").removeClass("is-invalid");
                    if (response.code === 200) {
                        if (response.no_package === true) {
                            $("#no_sub").modal("show");
                            $(".add_service").removeAttr("disabled");
                            $(".add_service").html("Add Service");
                        }
                        // Check for 'sub_end' in the response
                        else if (response.sub_count_end === true) {
                            $("#sub_count_end").modal("show");
                            $(".add_service").removeAttr("disabled");
                            $(".add_service").html("Add Service");
                        } else if (response.sub_end === true) {
                            $("#sub_end").modal("show");
                            $(".add_service").removeAttr("disabled");
                            $(".add_service").html("Add Service");
                        }
                        // Check for 'redirect_url' in the response
                        else if (response.redirect_url) {
                            setTimeout(function () {
                                window.location.href = response.redirect_url;
                            });
                        }
                        // Handle unexpected cases (optional)
                        else {
                            toastr.error("Unexpected response from server.");
                        }
                    }
                })
                .fail((error) => {
                    $(".error-text").text(""); // Clear all previous error messages
                    $(".form-control").removeClass("is-invalid"); // Remove invalid classes
                    $(".add_service").removeAttr("disabled"); // Re-enable the button
                    $(".add_service").html("Add Service");

                    if (error.status == 422) {
                        // Loop through validation errors and display them
                        $.each(error.responseJSON.errors, function (key, val) {
                            $("#" + key).addClass("is-invalid"); // Highlight invalid field
                            $("#" + key + "_error").text(val[0]); // Set error text
                        });
                        $("#error_login_message").text(
                            error.responseJSON.error ||
                                "An unexpected error occurred."
                        );
                    } else {
                        $("#error_login_message").text(
                            error.responseJSON.error ||
                                "An unexpected error occurred."
                        );
                    }
                });
        });

        function fetchProducts(status, shopId) {
            const listContainer = $(`#${status}-product-list`);
            const loader = $(`#${status}-loader`);
            listContainer.html('').append(loader.show()); // Clear list and show loader

            $.ajax({
                url: "/api/provider/service-list", // Your existing API endpoint
                type: "POST",
                data: {
                    auth_id: authId,
                    type: "product",
                    status: status, // Pass the status to the API
                    shop_id: shopId, // Pass the shop ID to the API
                },
                headers: {
                    // Assuming you still use this auth method for API
                    Authorization: "Bearer " + localStorage.getItem("admin_token"),
                    Accept: "application/json",
                },
                success: function(response) {
                    if (response.code === "200" && response.data.length > 0) {
                        populateProducts(response.data, listContainer);
                    } else {
                        listContainer.html(`<div class="col-12 text-center p-5"><p class="text-muted">${_l("no_products_found")}</p></div>`);
                    }
                },
                error: function() {
                    listContainer.html(`<div class="col-12 text-center p-5"><p class="text-danger">${_l("failed_load_products")}</p></div>`);
                }
            });
        }

        function populateProducts(products, container) {
            container.empty(); // Clear loader/previous content
            products.forEach(product => {
                // Determine primary image, stock and price
                const firstImage = product.product_image && product.product_image.length > 0 ? product.product_image[0] : '{{ asset("path/to/default-image.jpg") }}';
                const stock = product.source_stock || 'N/A';
                const price = product.source_price ? `$${parseFloat(product.source_price).toFixed(2)}` : 'N/A';
                const editUrl = `/provider/product/edit/${product.id}`;
                const statusText = product.status == 1 ? _l('active') : _l('inactive');

                const productCard = `
                <div class="col-xl-4 col-md-6 col-sm-12 d-flex" data-product-id="${product.id}">
                    <div class="product-item mb-0 flex-fill">
                        <div class="product-img position-relative">
                            <a href="#">
                                <img src="${firstImage}" class="img-fluid w-100" alt="${product.source_name}" style="height: 250px; object-fit: cover;">
                            </a>
                            <div class="product-layout d-flex flex-column align-items-center justify-content-center gap-2 action-visible">
                                <a href="${editUrl}" class="btn btn2 btn-icon btn-white"><i class="isax isax-edit"></i></a>
                                <a href="javascript:void(0);" class="btn btn3 btn-icon btn-white delete-product" data-id="${product.id}" data-bs-toggle="modal" data-bs-target="#delete-modal"><i class="isax isax-trash"></i></a>
                            </div>
                        </div>
                        <div class="product-content">
                            <div class="d-flex align-items-center justify-content-between gap-2 flex-wrap mb-3">
                                <span class="badge badge-sm bg-light text-dark">
                                    ${product.source_category || _l('uncategorized')}
                                </span>
                                <span class="badge badge-sm badge-soft-info">
                                    ${_l('quantity')}: ${stock}
                                </span>
                            </div>
                            <h6 class="text-truncate mb-3"><a href="#" title="${product.source_name}">${product.source_name.length > 20 ? product.source_name.substring(0, 20) + '...' : product.source_name}</a></h6>
                            <div class="d-flex align-items-center justify-content-between gap-1 flex-wrap">
                                <h6 class="mb-0">${price}</h6>
                                <div class="d-flex align-items-center gap-2 offer-action">
                                    <a href="javascript:void(0);" class="d-inline-flex align-items-center fs-14 toggle-status" data-id="${product.id}">
                                        <i class="isax isax-info-circle me-1"></i>${statusText}
                                    </a>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            `;
                container.append(productCard);
            });
        }

        // Handle Tab Clicks
        $('.wishlist-tab a[data-bs-toggle="tab"]').on('shown.bs.tab', function(e) {
            currentStatus = $(e.target).data('status');
            fetchProducts(currentStatus, currentShopId);
        });

        // Handle Shop Filter Change
        $('#shop-filter').on('change', function() {
            currentShopId = $(this).val();
            // Refetch data for the currently active tab
            fetchProducts(currentStatus, currentShopId);
        });

        // Handle Status Toggle Click
        $(document).on('click', '.toggle-status', function(e) {
            e.preventDefault();
            const productId = $(this).data('id');
            $.ajax({
                url: "/api/provider/service/status", // Your existing status update endpoint
                type: "POST",
                data: {
                    id: productId
                },
                headers: {
                    Authorization: "Bearer " + localStorage.getItem("admin_token"),
                    Accept: "application/json"
                },
                success: function(response) {
                    if (response.success) {
                         showToast('success', _l('status_updated_success'));
                        fetchProducts(currentStatus, currentShopId);
                    } else {
                         showToast('success', _l('status_updated_success'));
                    }
                },
                error: () =>  showToast('error', _l('error_occurred_try_again'))
            });
        });

        // Handle Delete Button Click (to set modal data)
        $(document).on('click', '.delete-product', function() {
            const deleteId = $(this).data('id');
            $("#confirmDelete").data('id', deleteId);
        });

        // Handle Confirmation of Delete
        $("#confirmDelete").on("click", function(e) {
            e.preventDefault();
            const deleteId = $(this).data("id");
            const button = $(this);

            $.ajax({
                url: "/api/provider/service/delete", // Your existing delete endpoint
                type: "POST",
                data: {
                    id: deleteId
                },
                headers: {
                    Authorization: "Bearer " + localStorage.getItem("admin_token"),
                    Accept: "application/json"
                },
                beforeSend: () => button.prop('disabled', true).html(`<span class="spinner-border spinner-border-sm"></span>`),
                success: function(response) {
                    if (response.success) {
                         showToast('success', _l('product_deleted_success'));
                        $(`[data-product-id="${deleteId}"]`).remove(); // Remove card from view
                        $('#delete-modal').modal('hide');
                    } else {
                        showToast('error', response.message || _l('failed_delete_product'));
                    }
                },
                error: () => showToast('error', _l('error_occurred')),
                complete: () => button.prop('disabled', false).text(_l('yes_delete'))
            });
        });

        // Subscription Check on "Add Product" button
        $("#providerAddService").on("click", function(e) {
            e.preventDefault();
            const authId = $("#auth_id").val();
            $.ajax({
                    url: "/provider/subscription/detail",
                    type: "POST",
                    data: {
                        id: authId,
                        type: "product",
                    },
                    headers: {
                        Authorization: "Bearer " + localStorage.getItem("admin_token"),
                        Accept: "application/json",
                        "X-CSRF-TOKEN": $('meta[name="csrf-token"]').attr("content"),
                    },
                    beforeSend: function() {
                        $(".add_service").attr("disabled", true);
                        $(".add_service").html(
                            '<div class="spinner-border text-light" role="status"></div>'
                        );
                    },
                })
                .done((response, statusText, xhr) => {
                    $(".error-text").text("");
                    $(".form-control").removeClass("is-invalid");
                    if (response.code === 200) {
                        if (response.no_package === true) {
                            $("#no_sub").modal("show");
                            $(".add_service").removeAttr("disabled");
                            $(".add_service").html(_l("add_service"));
                        }
                        // Check for 'sub_end' in the response
                        else if (response.sub_count_end === true) {
                            $("#sub_count_end").modal("show");
                            $(".add_service").removeAttr("disabled");
                            $(".add_service").html(_l("add_service"));
                        } else if (response.sub_end === true) {
                            $("#sub_end").modal("show");
                            $(".add_service").removeAttr("disabled");
                            $(".add_service").html(_l("add_service"));
                        }
                        // Check for 'redirect_url' in the response
                        else if (response.redirect_url) {
                            setTimeout(function() {
                                window.location.href = response.redirect_url;
                            });
                        }
                        // Handle unexpected cases (optional)
                        else {
                            toastr.error(_l("unexpected_response"));
                        }
                    }
                })
                .fail((error) => {
                    $(".error-text").text(""); // Clear all previous error messages
                    $(".form-control").removeClass("is-invalid"); // Remove invalid classes
                    $(".add_service").removeAttr("disabled"); // Re-enable the button
                    $(".add_service").html(_l("add_service"));

                    if (error.status == 422) {
                        // Loop through validation errors and display them
                        $.each(error.responseJSON.errors, function(key, val) {
                            $("#" + key).addClass("is-invalid"); // Highlight invalid field
                            $("#" + key + "_error").text(val[0]); // Set error text
                        });
                        $("#error_login_message").text(
                            error.responseJSON.error ||
                            _l("unexpected_error_occurred")
                        );
                    } else {
                        $("#error_login_message").text(
                            error.responseJSON.error ||
                            _l("unexpected_error_occurred")
                        );
                    }
                });
        });

        fetchProducts(currentStatus, currentShopId);
    });
})();