(async () => {
    "use strict";
    await loadTranslationFile();
$(document).ready(function () {
    $(".searchable-select").select2({
        placeholder: _l("please_select_option"),
        allowClear: true,
    });

    function validateForm() {
        let isValid = true;
        $(".invalid-feedback").text(""); // Clear previous errors

        const showError = (id, message) => {
            $("#" + id + "_error").text(message);
            isValid = false;
        };

        if (!$("#product_name").val())
            showError("product_name", _l("product_name_required"));
        if (!$("#product_code").val())
            showError("product_code", _l("product_code_required"));
        if (!$("#category_id").val())
            showError("category_id", _l("category_required"));
        if (!$("#sub_category_id").val())
            showError("sub_category_id", _l("sub_category_required"));
        if (!$("#shop_id").val()) showError("shop_id", _l("shop_required"));
        if (!$("#shot_description").val())
            showError("shot_description", _l("short_description_required"));
        if (!$("#description").val())
            showError("description", _l("full_description_required"));
        if ($("#multi-image-upload")[0].files.length === 0)
            showError(
                "product_images",
                _l("gallery_image_required")
            );

        if ($('input[name="product_type"]:checked').val() === "single") {
            if (!$("#price").val())
                showError("price", _l("base_price_required"));
            if (!$("#stock").val())
                showError("stock", _l("base_stock_required"));
        } else {
            if ($(".variation-card").length === 0) {
                showToast(
                    "error",
                    _l("add_variation_required")
                );
                isValid = false;
            }
            $(".variation-card").each(function () {
                const card = $(this);
                if (card.data("files").length === 0) {
                    card.find(".variation-image-input").after(
                        `<span class="invalid-feedback d-block">${_l("variation_image_required")}</span>`
                    );
                    isValid = false;
                }
                card.find(".size-price-row").each(function () {
                    const row = $(this);
                    if (!row.find('input[name$="[sizes][]"]').val()) {
                        row.find('input[name$="[sizes][]"]').after(
                            `<span class="invalid-feedback d-block">${_l("size_required")}</span>`
                        );
                        isValid = false;
                    }
                    if (!row.find('input[name$="[prices][]"]').val()) {
                        row.find('input[name$="[prices][]"]').after(
                            `<span class="invalid-feedback d-block">${_l("price_required")}</span>`
                        );
                        isValid = false;
                    }
                    if (!row.find('input[name$="[stocks][]"]').val()) {
                        row.find('input[name$="[stocks][]"]').after(
                            `<span class="invalid-feedback d-block">${_l("stock_required")}</span>`
                        );
                        isValid = false;
                    }
                });
            });
        }

        return isValid;
    }

    // Helper for toastr
    function showToast(type, message) {
        toastr[type](message); // success, error, info, warning
    }

    // ===================================================================
    // === CORE FORM SUBMISSION LOGIC (AJAX) ============================
    // ===================================================================
    $("#product-form").on("submit", function (event) {
        event.preventDefault();

        if (!validateForm()) {
            return;
        }

        $(".variation-card").each(function () {
            const card = $(this);
            const fileInput = card.find(".variation-image-input")[0];
            const files = card.data("files");
            const dataTransfer = new DataTransfer();
            files.forEach((file) => dataTransfer.items.add(file));
            fileInput.files = dataTransfer.files;
        });

        const form = this;
        const formData = new FormData(form);

        $.ajax({
            url: "/provider/product/store",
            method: "POST",
            data: formData,
            processData: false,
            contentType: false,
            headers: {
                Accept: "application/json",
                "X-CSRF-TOKEN": $('meta[name="csrf-token"]').attr(
                    "content"
                ),
            },
            beforeSend: function () {
                $("#submit-btn")
                    .prop("disabled", true)
                    .html(
                        `<span class="spinner-border spinner-border-sm"></span> ${_l("saving")}`
                    );
            },
            success: function (response) {
                showToast("success", response.message);
                if (response.redirectUrl) {
                    window.location.href = response.redirectUrl;
                }
            },
            error: function (jqXHR) {
                let errorMessage = _l("unexpected_error_try_again");
                if (jqXHR.status === 422) {
                    const errors = jqXHR.responseJSON.errors;
                    $.each(errors, function (key, value) {
                        const sanitizedKey = key
                            .replace(/\./g, "_")
                            .replace(/\[/g, "_")
                            .replace(/\]/g, "");
                        $("#" + sanitizedKey + "_error").text(value[0]);
                    });
                    errorMessage = _l("correct_form_errors");
                }
                showToast("error", errorMessage);
            },
            complete: function () {
                $("#submit-btn")
                    .prop("disabled", false)
                    .text(_l("save_product"));
            },
        });
    });

    // ===================================================================
    // === DYNAMIC PRODUCT VARIATIONS LOGIC =============================
    // ===================================================================
    const variationsContainer = $("#variations-container");
    let variationIndex = 0;

    $("#add-variation-btn").on("click", function () {
        variationIndex++;
        const template = `
            <div class="variation-card card card-body mb-3 position-relative" id="variation-${variationIndex}">
                <button type="button" class="btn-close remove-variation-btn position-absolute top-0 end-0 mt-2 me-2" aria-label="${_l("close")}"></button>
                <div class="row g-3">
                    <div class="col-12">
                        <label class="form-label mb-2">${_l("variation_images")} <span class="text-danger">*</span></label>
                        <div class="image-preview-container d-flex flex-wrap gap-2 p-2 border rounded bg-light w-100" style="min-height: 96px;">
                            <span class="placeholder-text text-muted small align-self-center ms-2">${_l("image_previews_here")}</span>
                        </div>
                        <div class="mt-2">
                            <input type="file" name="variations[${variationIndex}][images][]" class="variation-image-input form-control form-control-sm" multiple accept="image/*"/>
                        </div>
                    </div>
                    <div class="col-md-6">
                        <label class="form-label mb-2">${_l("color")} <span class="text-danger">*</span></label>
                        <input type="color" name="variations[${variationIndex}][color]" value="#${Math.floor(
                Math.random() * 16777215
            ).toString(
                16
            )}" class="form-control form-control-color" style="height: 38px; width: 100px;">
                    </div>
                </div>
                <hr class="my-3">
                <div>
                    <h6 class="fw-semibold mb-3">${_l("sizes_prices_stock")} <span class="text-danger">*</span></h6>
                    <div class="size-price-container"></div>
                    <button type="button" class="add-size-btn btn btn-sm btn-link p-0 mt-2">+ ${_l("add_size")}</button>
                </div>
            </div>`;
        const newVariation = $(template);
        newVariation.data("files", []);
        newVariation
            .appendTo(variationsContainer)
            .find(".add-size-btn")
            .click();
    });

    variationsContainer.on("click", ".remove-variation-btn", function () {
        $(this).closest(".variation-card").remove();
    });
    variationsContainer.on("click", ".remove-size-btn", function () {
        $(this).closest(".size-price-row").remove();
    });

    variationsContainer.on("click", ".add-size-btn", function () {
        const container = $(this).prev(".size-price-container");
        const vIndex = $(this)
            .closest(".variation-card")
            .attr("id")
            .split("-")[1];
        const sizeTemplate = `
            <div class="size-price-row row g-2 align-items-center mb-2">
                <div class="col-sm-3"><input type="text" name="variations[${vIndex}][sizes][]" class="form-control form-control-sm" placeholder="${_l("size_placeholder")}"></div>
                <div class="col-sm-3"><input type="number" name="variations[${vIndex}][prices][]" class="form-control form-control-sm" placeholder="${_l("price_placeholder")}"></div>
                <div class="col-sm-3"><input type="number" name="variations[${vIndex}][stocks][]" class="form-control form-control-sm" placeholder="${_l("stock_placeholder")}"></div>
                <div class="col-sm-3 text-end"><button type="button" class="btn-close remove-size-btn"></button></div>
            </div>`;
        container.append(sizeTemplate);
    });

    function renderVariationPreviews(card) {
        const previewContainer = card
            .find(".image-preview-container")
            .empty();
        const files = card.data("files");
        if (files.length === 0) {
            previewContainer.html(
                `<span class="placeholder-text text-muted small align-self-center ms-2">${_l("image_previews_here")}</span>`
            );
        } else {
            files.forEach((file, index) => {
                const reader = new FileReader();
                reader.onload = (e) => {
                    const previewWrapper = $(`
                            <div class="position-relative">
                                <img src="${e.target.result}" class="rounded border" style="height: 80px; width: 80px; object-fit: cover;">
                                <button type="button" class="btn-close bg-white rounded-circle position-absolute top-0 end-0 m-1 border delete-var-img" style="font-size: 0.6rem;"></button>
                            </div>
                        `);
                    previewWrapper.data("index", index);
                    previewContainer.append(previewWrapper);
                };
                reader.readAsDataURL(file);
            });
        }
    }

    variationsContainer.on("change", ".variation-image-input", function () {
        const card = $(this).closest(".variation-card");
        let existingFiles = card.data("files");
        let newFiles = Array.from(this.files);
        card.data("files", existingFiles.concat(newFiles));
        renderVariationPreviews(card);
        $(this).val("");
    });

    variationsContainer.on("click", ".delete-var-img", function () {
        const card = $(this).closest(".variation-card");
        let files = card.data("files");
        const indexToRemove = $(this).parent().data("index");
        files.splice(indexToRemove, 1);
        card.data("files", files);
        renderVariationPreviews(card);
    });

    // ===================================================================
    // === OTHER HELPERS ================================================
    // ===================================================================
    $("#product_name").on("input", function () {
        const slug = $(this)
            .val()
            .toLowerCase()
            .trim()
            .replace(/\s+/g, "-")
            .replace(/[^\w\-]+/g, "")
            .replace(/\-\-+/g, "-");
        $("#slug").val(slug);
    });

    $('input[name="product_type"]').on("change", function () {
        $("#variable-product-content").toggle(this.value === "variable");
        $("#single-product-content").toggle(this.value === "single");
    });

    $("#multi-image-upload").on("change", function () {
        const previewContainer = $(
            "#multi-image-preview-container"
        ).empty();
        if (this.files) {
            $.each(this.files, (i, file) => {
                previewContainer.append(
                    $("<img>", {
                        src: URL.createObjectURL(file),
                        class: "rounded border",
                        style: "height: 96px; width: 96px; object-fit: cover;",
                    })
                );
            });
        }
    });

    $("#category_id").on("change", function () {
        const categoryId = $(this).val();
        const subcategoriesDropdown = $(".subcategories");
        subcategoriesDropdown
            .html(`<option value="">${_l("select_sub_category")}</option>`)
            .prop("disabled", true);
        if (categoryId) {
            $.ajax({
                url: "/api/get-register-subcategories",
                type: "POST",
                data: { category_id: categoryId },
                headers: {
                    "X-CSRF-TOKEN": $('meta[name="csrf-token"]').attr(
                        "content"
                    ),
                },
                success: function (data) {
                    let subcategoriesHtml = `<option value="">${_l("select_sub_category")}</option>`;
                    data.forEach((subcategory) => {
                        subcategoriesHtml += `<option value="${subcategory.id}">${subcategory.name}</option>`;
                    });
                    subcategoriesDropdown
                        .html(subcategoriesHtml)
                        .prop("disabled", false);
                },
                error: function () {
                    showToast("error", _l("failed_fetch_subcategories"));
                },
            });
        }
    });

    $("#add-specification").on("click", function () {
        let html = `
            <div class="col-md-3 mb-3 spec-row"><label class="form-label">${_l("label")}</label><input type="text" name="specification_label[]" class="form-control" placeholder="${_l("label_placeholder")}"></div>
            <div class="col-md-8 mb-3 spec-row"><label class="form-label">${_l("description")}</label><input type="text" name="specification_description[]" class="form-control" placeholder="${_l("description_placeholder")}"></div>
            <div class="col-md-1 mb-3 spec-row d-flex align-items-end"><button type="button" class="btn btn-danger remove-spec-btn"><i class="fa-solid fa-trash"></i></button></div>`;
        $("#specification-wrapper").append(html);
    });

    $("#specification-wrapper").on(
        "click",
        ".remove-spec-btn",
        function () {
            const parent = $(this).closest(".spec-row");
            parent.prev().prev().remove();
            parent.prev().remove();
            parent.remove();
        }
    );
});
})();
