
     toastr.options = {
    debug: false,
    newestOnTop: false,
    progressBar: true,
    positionClass: "toast-top-right",
    preventDuplicates: true,
    onclick: null,
    showDuration: "30000",
    hideDuration: "10000",
    timeOut: "4000",
    extendedTimeOut: "10000",
    showEasing: "swing",
    hideEasing: "linear",
    showMethod: "fadeIn",
    hideMethod: "fadeOut",
};

    const csrfToken = $('meta[name="csrf-token"]').attr('content');

    // Mark all as read
    $('#mark-all-read-btn').on('click', function(e) {
        e.preventDefault();
        $.ajax({
            url: "/provider/notifications/mark-all-read",
            type: 'POST',
            data: { _token: csrfToken },
            success: function(response) {
                if (response.code == '200') {
                    toastr.success(response.message);
                } else {
                    toastr.error('Could not mark notifications as read.');
                }
            },
            error: function() {
                toastr.error('An error occurred.');
            }
        });
    });

    // Clear All Notifications
    $('#confirm-clear-all-btn').on('click', function() {
        $.ajax({
            url: "/provider/notifications/clear-all",
            type: 'POST',
            data: { _token: csrfToken },
            success: function(response) {
                if (response.success) {
                    $('#clear_all_modal').modal('hide');
                    toastr.success(response.message);
                    setTimeout(() => window.location.reload(), 1000);
                }
            },
            error: function() {
                toastr.error('An error occurred.');
            }
        });
    });

    // Individual Delete Notification
    let notificationToDeleteId = null;
    $('#notification-list').on('click', '.delete-notification-btn', function() {
        notificationToDeleteId = $(this).data('id');
    });

    $('#confirm-delete-btn').on('click', function() {
        if (!notificationToDeleteId) return;

        $.ajax({
            url: `/provider/notifications/${notificationToDeleteId}`,
            type: 'DELETE',
            data: { _token: csrfToken },
            success: function(response) {
                if (response.success) {
                    $('#delete_notification_modal').modal('hide');
                    // FIX: Corrected typo from 'showtoastr' to 'toastr.success'
                    toastr.success(response.message);
                    
                    // FIX: Manually remove the backdrop and then fade out the element to prevent overlay issue
                    $('body').removeClass('modal-open');
                    $('.modal-backdrop').remove();
                    
                    $('#notification-' + notificationToDeleteId).fadeOut(500, function() {
                        $(this).remove();
                        if ($('#notification-list').children().length === 0) {
                             $('#notification-list').html('<div class="card shadow-none booking-list"><div class="card-body d-flex align-items-center justify-content-center"><p class="text-center fw-bold w-100">No notifications found.</p></div></div>');
                        }
                    });
                }
            },
            error: function() {
                toastr.error('An error occurred.');
            }
        });
    });
