<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('booking_products', function (Blueprint $table) {
            $table->id();
            $table->unsignedBigInteger('booking_id'); // Foreign key to the bookings table
            $table->unsignedBigInteger('product_id'); // The ID of the product
            $table->string('product_name'); // Store the name at the time of purchase
            $table->integer('quantity');
            $table->decimal('price', 10, 2); // The price per item
            $table->decimal('subtotal', 10, 2); // The total for this line item (price * quantity)
            $table->timestamps();

        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('booking_products');
    }
};