<?php

namespace App\Repositories\Eloquent;

use App\Repositories\Contracts\TranslationRepositoryInterface;
use Illuminate\Support\Facades\App;
use Illuminate\Support\Facades\Cache;

class TranslationRepository implements TranslationRepositoryInterface
{
    /**
     * @return array <string, mixed>
     */
    public function getFileTranslations(array $keys = []): array
    {
        $locale = App::getLocale();

        // Cache the full translation file for this locale
        $jsonContent = Cache::rememberForever("translations_{$locale}", function () use ($locale) {
            $jsonPath = resource_path("lang/{$locale}.json");
            if (!file_exists($jsonPath)) {
                return [];
            }
            return json_decode(file_get_contents($jsonPath), true) ?? [];
        });

        // If no keys requested → return all
        if (empty($keys)) {
            return $jsonContent;
        }

        // Filter only requested keys
        $filtered = [];
        foreach ($keys as $key) {
            $filtered[$key] = $jsonContent[$key] ?? $key; // fallback to key itself
        }

        return $filtered;
    }
}
