<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Modules\Shops\app\Models\Shops;
use Modules\Product\app\Models\Product;

class Wishlist extends Model
{
    use HasFactory;

    protected $fillable = [
        'user_id',
        'service_id',
        'type'
    ];

    public function shop()
    {
        return $this->belongsTo(Shops::class, 'service_id');
    }

    public function product()
    {
        return $this->belongsTo(Product::class, 'service_id');
    }

    public function service()
    {
        return $this->belongsTo(Product::class, 'service_id');
    }
}


