<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class TaxRate extends Model
{
    use SoftDeletes;

    protected $table = 'tax_rates';

    protected $fillable = [
        'tax_name',
        'tax_rate',
        'status',
        'source_type',
    ];

    protected $casts = [
        'tax_rate' => 'decimal:2',
        'status'   => 'boolean',
    ];
}
