<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;
use Modules\Product\app\Models\Product;
use Modules\Service\app\Models\Service;

class ProductVariation extends Model
{
    use HasFactory;

    protected $table = 'product_variations';

    /**
     * The attributes that are mass assignable.
     *
     * @var array<int, string>
     */
    protected $fillable = [
        'product_id',
        'color',
        'data',
        'images', // This will store the JSON array of image paths
    ];

    /**
     * The attributes that should be cast.
     *
     * This automatically converts the 'images' JSON column from the database
     * into a PHP array and back when saving.
     *
     * @var array<string, string>
     */
    protected $casts = [
        'data'   => 'array',
        'images' => 'array',
    ];

    /**
     * Get the product that this variation belongs to.
     */
    public function product()
    {
        return $this->belongsTo(Service::class, 'product_id', 'id');
    }
}
