<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Enquiry extends Model
{
    use HasFactory;

    protected $table = 'enquiries';

    /**
     * The attributes that are mass assignable.
     */
    protected $fillable = [
        'provider_id',
        'customer_name',
        'email',
        'phone',
        'enquiry_date',
        'enquiry_details',
        'status',
        'comments',
    ];

    /**
     * Casts
     */
    protected $casts = [
        'enquiry_date' => 'date:Y-m-d',
    ];

    /**
     * Example relation (if you have Provider model)
     */
    public function provider()
    {
        return $this->belongsTo(\App\Models\User::class, 'provider_id');
    }
}
