<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;
use Illuminate\Support\Facades\Storage;
use App\Models\User;
use Modules\Product\app\Models\Product;
use Modules\Service\app\Models\Service;

/**
 * @property int $id
 * @property int|null $service_amount
 *  @property int|null $type
 * @property string|null $source_name
 * @property string|null $user_name
 *  @property string|null $provider_name
 * @property string|null $provideremail
 * @property string|null $user_email
 * @property string|null $user_address
 * @property string|null $booking_status_label
 * @property string|null $booking_status
 * @property int|null $refundid
 * @property string|null $paymenttype
 * @property \Carbon\Carbon|null $trxdate
 * @property \Carbon\Carbon|null $bookingdate
 * @property \Carbon\Carbon|null $booking_date
 * @property \Carbon\Carbon|null $fromtime
 * @property \Carbon\Carbon|null $totime
 * @property \Carbon\Carbon|null $refunddate
 */

class Bookings extends Model
{
    use SoftDeletes;

    protected $table = 'bookings';

    protected $fillable = ['id', 'order_id', 'product_id', 'branch_id', 'staff_id', 'slot_id', 'type', 'amount_tax', 'tax_details',  'coupon_details', 'total_coupon_discount_amount', 'from_time', 'to_time', 'booking_date', 'booking_status', 'payment_type', 'user_id', 'provider_id', 'service_amount', 'service_qty', 'notes', 'first_name', 'last_name', 'user_email', 'user_phone', 'user_city', 'user_state', 'user_postal', 'user_address', 'address_type', 'tranaction', 'total_amount', 'payment_status', 'payment_proof_path', 'created_at', 'created_by', 'updated_at', 'updated_by', 'deleted_at', 'deleted_by', 'notes', 'additional_services', 'bank_transfer_proof'];
    protected $casts = [
        'service_amount' => 'float',
        // Add other necessary casts here
    ];
    /**
     * Define a relationship to the Product model.
     *
     * @return \Illuminate\Database\Eloquent\Relations\BelongsTo
     */
    public function product()
    {
        return $this->belongsTo(Product::class, 'product_id');
    }

    public function productss()
    {
        return $this->belongsTo(Service::class, 'product_id');
    }
    /**
     * Define a relationship to the User model.
     *
     * @return \Illuminate\Database\Eloquent\Relations\BelongsTo
     */
    public function user()
    {
        return $this->belongsTo(User::class, 'user_id');
    }

    // In app/Models/Bookings.php
    public function bookingProducts()
    {
        return $this->hasMany(BookingProduct::class, 'booking_id');
    }

    public function products()
    {
        return $this->hasMany(BookingProduct::class, 'booking_id');
    }

    public function invoice_product()
    {
        return $this->belongsTo(Product::class, 'product_id','id');
    }

     public function invoice_bookingProducts()
    {
        return $this->hasMany(BookingProduct::class, 'booking_id','id');
    }
    public function provider()
    {
        return $this->belongsTo(User::class, 'id');
    }
    public function staff()
    {
        return $this->belongsTo(User::class, 'staff_id', 'id')
            ->where('user_type', 4);
    }
    public function service()
    {
        return $this->belongsTo(Service::class, 'product_id', 'id');
    }

    public function vendorInfo()
    {
        return $this->hasMany(User::class, 'id');
    }
}
