<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Modules\Product\app\Models\Productmeta;
use Modules\Product\app\Models\Product;

class BookingProduct extends Model
{
    use HasFactory;

    protected $fillable = [
        'user_id',
        'provider_id',
        'shop_id',
        'booking_id',
        'product_id',
        'product_name',
        'quantity',
        'variant',
        'color',
        'price',
        'subtotal',
        'coupon_discount_amount',
        'tax_amount',
        'gross_total',
        'cancellation_reason',
        'product_status',
        'cod_payment_status'
    ];

    /**
     * Get the parent booking that this product belongs to.
     */
    public function booking()
    {
        return $this->belongsTo(Bookings::class, 'booking_id');
    }

    // ✅ FIX: Direct relation to product
    public function product()
    {
        return $this->belongsTo(Product::class, 'product_id');
    }

    public function meta()
    {
        return $this->hasMany(Productmeta::class, 'product_id', 'product_id');
    }

    public function categories()
    {
        return $this->belongsToMany(
            Categories::class,
            'product_category',   // 👈 use pivot table if you have it
            'product_id',
            'category_id'
        );
    }

    public function vendorInfo()
    {
        return $this->hasMany(User::class, 'id');
    }

    public function user()
    {
        return $this->belongsTo(User::class, 'user_id');
    }

    public function provider()
    {
        return $this->belongsTo(User::class, 'provider_id');
    }
    public function productDetails()
    {
        return $this->belongsTo(Product::class, 'product_id');
    }
}
