<?php

namespace App\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;
use Illuminate\Contracts\Validation\Validator;
use Illuminate\Http\Exceptions\HttpResponseException;

class StoreEnquiryRequest extends FormRequest
{
    public function authorize()
    {
        // change to true or implement auth check
        return true;
    }

    public function rules()
    {
        return [
            'provider_id'    => 'nullable|integer|exists:providers,id',
            'customer_name'  => 'required|string|max:255',
            'email'          => 'nullable|email|max:255',
            'phone'          => 'nullable|string|max:50',
            'enquiry_date'   => 'nullable|date',
            'enquiry_details'=> 'nullable|string',
            'status'         => 'nullable|string|in:pending,seen,closed', // adjust values as needed
        ];
    }

    public function messages()
    {
        return [
            'customer_name.required' => 'Customer name is required.',
            'email.email'            => 'Please provide a valid email.',
            // add more custom messages if needed
        ];
    }

    /**
     * Customize validation failure response to include `code: 422` so frontend handles it
     */
    protected function failedValidation(Validator $validator)
    {
        $errors = $validator->errors()->toArray();
        $response = response()->json([
            'code'    => 422,
            'message' => 'Validation errors',
            'errors'  => $errors,
        ], 422);

        throw new HttpResponseException($response);
    }
}
