<?php

namespace App\Http\Middleware;

use Closure;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Session;
use Modules\GlobalSetting\app\Models\Language;
use Symfony\Component\HttpFoundation\Response;

class SetLocale
{
    /**
     * Handle an incoming request.
     *
     * @param  \Closure(\Illuminate\Http\Request): (\Symfony\Component\HttpFoundation\Response)  $next
     */
    public function handle(Request $request, Closure $next): Response
    {
        $languageId = '';
        if ($user = Auth::user()) {
            $languageId = $user->user_language_id;
        }
        
        if ($languageId) {
            $language = Language::where('id', $languageId)->first();
            $languageCode = $language->code ?? 'en';
            app()->setLocale($languageCode);
        } elseif (Session::has('app_locale')) {
            app()->setLocale(Session::get('app_locale'));
        } else {
            $language = Language::select('code')
                ->where(['is_default' => 1, 'status' => 1])
                ->first();

            $languageCode = $language->code ?? 'en';

            Session::put('app_locale', $languageCode);
            app()->setLocale($languageCode);
        }

        return $next($request);
    }
}
