<?php

namespace App\Http\Controllers;

use App\Repositories\Contracts\TranslationRepositoryInterface;
use Illuminate\Http\JsonResponse;
use Illuminate\Http\Request;

class TranslationController extends Controller
{
    protected TranslationRepositoryInterface $translationRepository;

    public function __construct(TranslationRepositoryInterface $translationRepository)
    {
        $this->translationRepository = $translationRepository;
    }

    public function getFileTranslations(Request $request): JsonResponse
    {
        $keys = $request->input('keys', []);
        $translations = $this->translationRepository->getFileTranslations($keys);

        return response()->json($translations);
    }
}
