<?php

namespace App\Http\Controllers;

use App\Repositories\Eloquent\ReviewRepository;
use Illuminate\Http\JsonResponse;
use Illuminate\Http\Request;
use Illuminate\Support\Js;
use Illuminate\View\View;

class ReviewController extends Controller
{
    protected ReviewRepository $reviewRepository;

    public function __construct()
    {
        $this->reviewRepository = new ReviewRepository();
    }

    public function getProviderProductRatings(Request $request): JsonResponse
    {
        return $this->reviewRepository->getProviderProductRatings($request);
    }

    public function addProviderProductRatingReply(Request $request): JsonResponse
    {
        return $this->reviewRepository->addProviderProductRatingReply($request);
    }

    public function deleteProviderProductRating(int $ratingId): JsonResponse
    {
        return $this->reviewRepository->deleteProviderProductRating($ratingId);
    }

    public function storeCustomerReview(Request $request): JsonResponse
    {
        return $this->reviewRepository->storeCustomerReview($request);
    }

    public function storeCustomerReply(Request $request): JsonResponse
    {
        return $this->reviewRepository->storeCustomerReply($request);
    }

    public function frontendReviewsList(Request $request): JsonResponse
    {
        return $this->reviewRepository->frontendReviewsList($request);
    }

    public function reviews(): View
    {
        return view('frontend.pages.customer.review');
    }

    public function customerReviewsList(Request $request): JsonResponse
    {
        return $this->reviewRepository->cutomerReviewsList($request);
    }

    public function deleteReview(Request $request): JsonResponse
    {
        return $this->reviewRepository->deleteReview($request);
    }
}
