<?php

namespace App\Http\Controllers;
use App\Repositories\Contracts\ProviderRepositoryInterface;
use Modules\GlobalSetting\Entities\GlobalSetting;
use App\Models\PayoutHistory;
use App\Models\User;
use App\Models\Bookings;
use Modules\GlobalSetting\app\Models\Language;
use Illuminate\Support\Facades\Cookie;
use Illuminate\Support\Facades\Auth;
use Illuminate\Http\Request;
use Illuminate\View\View;

class ProviderController extends Controller
{
    protected ProviderRepositoryInterface $providerRepository;

    public function __construct(ProviderRepositoryInterface $providerRepository)
    {
        $this->providerRepository = $providerRepository;
    }

    public function index()
    {
        $response = $this->providerRepository->index();
        return view('people.list', $response);
    }

    function calculateProviderBalance(int $providerId): float
    {
        $commissionRate = 0;
        $commissionSetting = GlobalSetting::where('key', 'commission_rate_percentage')->first();
        if ($commissionSetting) {
            $commissionRate = (float) $commissionSetting->value;
        }

        $totalEarnings = Bookings::where('provider_id', $providerId)
            ->whereIn('booking_status', [5, 6])
            ->sum('total_amount');

        $totalPaidOut = PayoutHistory::where('user_id', $providerId)
            ->where('status', 1)
            ->sum('amount');

        $commissionAmount = ($totalEarnings * $commissionRate) / 100;
        $netEarnings = $totalEarnings - $commissionAmount;
        $currentBalance = $netEarnings - $totalPaidOut;

        return $currentBalance > 0 ? $currentBalance : 0;
    }


    public function dashboard(): View
    {
        $data = [
            'menu' => '<a href="' . url('/') . '">Home</a>',
            'submenu' => 'Dashboard',
            'header' => 'Dashboard'
        ];
        return view('provider.dashboard', compact('data'));
    }

    public function getDashboardSummary(Request $request)
    {
        $data = $this->providerRepository->getDashboardSummary($request);
        return response()->json(['data' => $data]);
    }

    public function getRecentlySoldProducts(Request $request)
    {
        $data = $this->providerRepository->getRecentlySoldProducts($request);
        return response()->json(['data' => $data]);
    }

    public function getTotalBookingsChartData(Request $request)
    {
        $data = $this->providerRepository->getTotalBookingsChartData($request);
        return response()->json(['data' => $data]);
    }

    public function getRecentlyBookedServices(Request $request)
    {
        $data = $this->providerRepository->getRecentlyBookedServices($request);
        return response()->json(['data' => $data]);
    }

    public function getHighlyBookedCategories(Request $request)
    {
        $data = $this->providerRepository->getHighlyBookedCategories($request);
        return response()->json(['data' => $data]);
    }

    public function getRecentTransactions(Request $request)
    {
        $data = $this->providerRepository->getRecentTransactions($request);
        return response()->json(['data' => $data]);
    }
}
