<?php

namespace App\Http\Controllers;

use App\Repositories\Contracts\BillingAddressRepositoryInterface;
use Illuminate\Http\JsonResponse;
use Illuminate\Http\Request;
use Illuminate\View\View;

class BillingAddressController extends Controller
{
    protected $billingAddressRepository;

    public function __construct(BillingAddressRepositoryInterface $billingAddressRepository)
    {
        $this->billingAddressRepository = $billingAddressRepository;
    }

    public function index(): View
    {
        $data = $this->billingAddressRepository->index();
        return view('frontend.pages.customer.billing_address', $data);
    }

    public function store(Request $request): JsonResponse
    {
        $response = $this->billingAddressRepository->store($request);
        return response()->json($response, $response['code']);
    }

    public function list(Request $request): JsonResponse
    {
        $response = $this->billingAddressRepository->list($request);
        return response()->json($response, $response['code']);
    }

    public function edit(Request $request): JsonResponse
    {
        $response = $this->billingAddressRepository->edit($request);
        return response()->json($response, $response['code']);
    }

    public function delete(Request $request): JsonResponse
    {
        $response = $this->billingAddressRepository->delete($request);
        return response()->json($response, $response['code']);
    }

    public function setDefault(Request $request): JsonResponse
    {
        $response = $this->billingAddressRepository->setDefault($request);
        return response()->json($response, $response['code']);
    }
}
