<?php

namespace App\Console\Commands;

use Illuminate\Console\Command;
use Illuminate\Support\Facades\File;

class ClearUploads extends Command
{
    protected $signature = 'clear:uploads';
    protected $description = 'Delete all uploaded files in storage/app/public';

    public function handle()
    {
        $directory = storage_path('app/public');

        if (File::exists($directory)) {
            File::cleanDirectory($directory);
            $this->info('✅ All uploaded files in storage/app/public have been deleted.');
        } else {
            $this->warn('⚠️ Directory does not exist: ' . $directory);
        }
    }
}
