<?php

namespace Modules\Shops\app\Repositories\Contracts;

use Illuminate\Http\JsonResponse;
use Illuminate\Http\Request;
use Modules\Shops\app\Models\Shops;

interface ShopRepositoryInterface
{
    /**
     * Get active and inactive shops for the provider panel.
     */
    public function index(Request $request): array;

    /**
     * Get necessary data for the create shop form.
     */
    public function create(): array;

    /**
     * Store a new shop in the database.
     */
    public function store(Request $request): Shops;

    /**
     * Get the specific shop and related data for the edit form.
     */
    public function edit(string $slug): array;

    /**
     * Update an existing shop in the database.
     */
    public function update(Request $request, Shops $shop): Shops;

    /**
     * Update the status of a specific shop.
     */
    public function updateStatus(Request $request, Shops $shop): bool;
    
    /**
     * Get states for a given country from the database.
     */
    public function getStates(Request $request): array;

    /**
     * Get cities for a given state from the database.
     */
    public function getCities(Request $request): array;

    /**
     * Delete a shop from the database.
     */
    public function destroy(Shops $shop): bool;
}
