<?php

namespace Modules\Shops\app\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\HasMany;
use Modules\Categories\app\Models\Categories;
use App\Models\Branches;
use Modules\GlobalSetting\app\Models\ProductBrand;
use Modules\GlobalSetting\app\Models\Unit;
use Illuminate\Support\Str;
use Modules\Product\app\Models\Product;
use App\Models\Country;
use App\Models\City;
use Illuminate\Database\Eloquent\Relations\BelongsTo;
use Modules\Product\app\Models\Rating;
use App\Models\User;
use App\Models\State;
use Illuminate\Database\Eloquent\SoftDeletes;

class Shops extends Model
{
    use SoftDeletes;
    protected $table = 'shops';

    protected $fillable = [
        'shop_name', 'slug', 'owner_name', 'email', 'phone', 'address', 'city', 'country', 'state',
        'zip_code', 'about', 'shop_logo', 'description', 'created_by', 'status', 'gallery',
        'start_hour', 'end_hour', 'language_id', 'updated_by', 'working_day', 'social_links',
        'category_id', 'sub_category_id', 'tax_status', 'tax_number'
    ];

    protected $casts = [
        'gallery' => 'array',
        'social_links' => 'array',
    ];

    // --- Existing Relationships ---
    public function category() { return $this->belongsTo(Categories::class); }
    public function brand() { return $this->belongsTo(ProductBrand::class); }
    public function unit() { return $this->belongsTo(Unit::class); }
    public function branch() { return $this->belongsTo(Branches::class); }

     public function services(): HasMany
    {
        return $this->hasMany(Product::class, 'shop_id')->where('source_type', 'service');
    }

    public function actualProducts(): HasMany
    {
        return $this->hasMany(Product::class, 'shop_id')->where('source_type', 'product');
    }

    public function owner(): BelongsTo
    {
        return $this->belongsTo(User::class, 'created_by');
    }

    public function countryRelation(): BelongsTo
    {
        return $this->belongsTo(Country::class, 'country');
    }

    public function cityRelation(): BelongsTo
    {
        return $this->belongsTo(City::class, 'city');
    }

     public function stateRelation(): BelongsTo
    {
        return $this->belongsTo(State::class, 'state');
    }

    public function reviews(): HasMany
    {
        return $this->hasMany(Rating::class, 'product_id');
    }

    public function services_list()
    {
        return $this->hasMany(Product::class, 'shop_id')->where('source_type', 'service');
    }

    public function products_list()
    {
        return $this->hasMany(Product::class, 'shop_id')->where('source_type', 'product');
    }

    public function products(): HasMany
    {
        return $this->hasMany(Product::class, 'shop_id');
    }

    public function ratings()
    {
        return $this->hasManyThrough(
            Rating::class,   // final table
            Product::class,  // intermediate table
            'shop_id',       // FK on products
            'product_id',    // FK on ratings
            'id',            // local key on shops
            'id'             // local key on products
        );
    }
}