<?php

namespace Modules\Shops\app\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;

class ShopStoreRequest extends FormRequest
{
    public function authorize(): bool
    {
        return true;
    }

    /**
     * @return array<string, string>
     */
    public function rules(): array
    {
        return [
            'shop_name' => 'required|string|max:255',
            'owner_name' => 'required|string|max:255',
            'email' => 'required|email|max:255',
            'phone_number' => 'nullable|string|max:255',
            'address' => 'required|string|max:255',
            'country' => 'required|string|max:255',
            'state' => 'required|string|max:255',
            'city' => 'required|string|max:255',
            'zip_code' => 'required|string|max:255',
            'start_hour' => 'required|string|max:10',
            'end_hour' => 'required|string|max:10',
            'working_day' => 'required|array|min:1',
            // File validations are handled manually in the repository to avoid generic
            // "failed to upload" errors when PHP blocks the upload before validation.
            'shop_logo' => 'nullable|file|mimes:jpg,jpeg,png,webp,gif|max:10240',
            'gallery' => 'nullable|array',
            'gallery.*' => 'nullable|file|mimes:jpg,jpeg,png,webp,gif|max:10240',
            'social_links' => 'nullable',
        ];
    }
}


