<?php

namespace Modules\Shops\app\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;
use Illuminate\Support\Facades\Auth;

class ShopRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     */
    public function authorize(): bool
    {
        return Auth::check();
    }

    /**
     * Get the validation rules that apply to the request.
     */
    public function rules(): array
    {
        // If we are updating, `this->shop` will be the Shop instance.
        $shopId = $this->shop ? $this->shop->id : null;

        return [
            'shop_name' => 'required|string|max:255|unique:shops,shop_name,' . $shopId,
            'owner_name' => 'required|string|max:255',
            'phone' => 'required|string|max:20',
            'email' => 'required|email|max:255',
            'description' => 'nullable|string',
            'address' => 'required|string|max:255',
            'country' => 'required|integer|exists:countries,id',
            'state' => 'required|integer|exists:states,id',
            'city' => 'required|integer|exists:cities,id',
            'zip_code' => 'required|string|max:20',
            'shop_logo' => 'nullable|image|mimes:jpeg,png,jpg,webp|max:10240',
            'gallery' => 'nullable|array',
            'gallery.*' => 'image|mimes:jpeg,png,jpg,webp|max:10240',
            'availability' => 'nullable|array',
            'removed_gallery_images' => 'nullable|array', // For edit form
        ];
    }
}